package com.xforceplus.phoenix.split.model;

import com.alibaba.fastjson.JSON;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.util.List;

/**
 * 拆分后的预制发票
 */
@ApiModel
public class SplitPreInvoiceInfo {

    @ApiModelProperty(value = "拆分规则id")
    private String ruleId;

    @ApiModelProperty(value = "预制发票主信息")
    private PreInvoiceMain preInvoiceMain;

    @ApiModelProperty(value = "预制发票明细信息")
    private List<PreInvoiceItem> preInvoiceItems;

    @ApiModelProperty(value = "预制发票扩展信息")
    private PreInvoiceExt preInvoiceExt;

    public PreInvoiceMain getPreInvoiceMain() {
        return preInvoiceMain;
    }

    public void setPreInvoiceMain(PreInvoiceMain preInvoiceMain) {
        this.preInvoiceMain = preInvoiceMain;
    }

    public List<PreInvoiceItem> getPreInvoiceItems() {
        return preInvoiceItems;
    }

    public void setPreInvoiceItems(List<PreInvoiceItem> preInvoiceItems) {
        this.preInvoiceItems = preInvoiceItems;
    }

    public PreInvoiceExt getPreInvoiceExt() {
        return preInvoiceExt;
    }

    public void setPreInvoiceExt(PreInvoiceExt preInvoiceExt) {
        this.preInvoiceExt = preInvoiceExt;
    }

    public String getRuleId() {
        return ruleId;
    }

    public void setRuleId(String ruleId) {
        this.ruleId = ruleId;
    }

    @Override
    public String toString() {
        return JSON.toJSONString(this);
    }
}
