package com.xforceplus.phoenix.split.model;

import com.alibaba.fastjson.JSON;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import javax.validation.Valid;
import javax.validation.constraints.*;
import java.math.BigDecimal;
import java.util.List;

/**
 * 拆票规则
 */
@ApiModel
public class SplitRule {

    @ApiModelProperty(name = "拆票限额", required = true, value = "拆票限额")
    @NotNull(message = "拆票限额不能为空")
    @DecimalMin(message = "拆票限额必须大于0", value = "0.00", inclusive = false)
    private BigDecimal invoiceLimit;

    @ApiModelProperty(name = "拆票限额是否是含税金额，默认false", value = "拆票限额是否是含税金额，默认false")
    private boolean limitIsAmountWithTax;

    @ApiModelProperty(name = "自定义拆票字段", value = "自定义拆票字段")
    private List<String> splitFiledList;


    @ApiModelProperty(name = "明细顺序:0-顺序优先 1-张数优先，2-顺序顶额拆分", required = true, value = "明细顺序:0-顺序优先 1-张数优先，2-顺序顶额拆分")
    @NotBlank(message = "明细顺序不能为空")
    private String itemSort;

    @ApiModelProperty(name = "销货清单最大行数", value = "销货清单最大行数")
    private Integer salesListMaxRow;

    @ApiModelProperty(value = "单价数量选项 0-打印单价数量 1-不打印单价数量")
    private String unitPriceAmountOps;

    @ApiModelProperty(value = "金额拆分规则, 1=按数量拆单价,2=按单价拆数量，并保证数量为整数,3=按单价拆数量", required = true)
    @NotBlank(message = "金额拆分规则不能为空")
    private String amountSplitRule;


    @ApiModelProperty(value = "发票票面明细最大数")
    private Integer invoiceItemMaxRow;


    @ApiModelProperty(value = "销货清单选项 0-不启用销货清单 1-启用销货清单 2-强制启用销货清单", required = true)
    @NotBlank(message = "销货清单选项不能为空")
    private String saleListOption;

    @ApiModelProperty(value = "发票规格")
    private String invoiceSpec;

    @ApiModelProperty(value = "发票类型")
    private String invoiceType;

    @ApiModelProperty(value = "价格方式, 0=不含税，1=含税")
    private PriceMethod priceMethod;

    @ApiModelProperty(name = "规则Id", required = true, value = "业务方拆票规则Id")
    @NotNull(message = "规则Id不能为空")
    private Long ruleId;

    @ApiModelProperty(value = "补充备注")
    private String extRemark;

    @ApiModelProperty(value = "零税率发票类型, 0 = 不处理，1=专改普", required = true)
    @NotNull(message = "零税率发票类型不能为空")
    private ZeroTaxOption zeroTaxOption;
    @ApiModelProperty("固定备注内容")
    private String fixedRemarkText;

    @ApiModelProperty("折扣率限制")
    @DecimalMin(value = "0.00")
    @DecimalMax(value = "1", inclusive = false)
    private BigDecimal discountLimit;




    @ApiModelProperty(value = "备注列表元数据")
    @Valid
    private List<RemarkFieldMetadata> remarkFiledMetadataBeanList;


    @ApiModelProperty(value = "商品名称拼接字段列表")
    @Valid
    private List<RemarkFieldMetadata> cargoNameFiledMetadatas;

    @ApiModelProperty(value = "自定义商品品名长度, 默认100")
    @Min(value = 1, message = "长度限制最小为1")
    private Integer cargoNameLength;


    @ApiModelProperty(value = "规格型号称拼接字段列表")
    @Valid
    private List<RemarkFieldMetadata> itemSpecFiledMetadatas;

    @ApiModelProperty(value = "自定义规格型号名称长度, 默认40")
    @Min(value = 1, message = "长度限制最小为1")
    private Integer itemSpecNameLength;

    @ApiModelProperty(value = "自定义备注长度 默认168，电票默认130")
    @Min(value = 1, message = "长度限制最小为1")
    private Integer customRemarkSize;


    @ApiModelProperty(value = "单价精度,默认15位")
    @PositiveOrZero(message = "精度必须非负数")
    private Integer unitPriceScale;

    @ApiModelProperty(value = "忽略截取单价小数位误差值, 默认为false 不忽略")
    private boolean ignoreAllowableError;

    @ApiModelProperty(value = "是否根据拆分关键字合并, 立邦项目使用，默认false")
    private boolean mergeBySplitFiled;

    @ApiModelProperty(value = "默认为true, 表示根据传递的备注参数进行去重，否则备注不去重，且换行")
    private boolean remarkDuplicateFlag;

    public Integer getCustomRemarkSize() {
        return customRemarkSize;
    }

    public void setCustomRemarkSize(Integer customRemarkSize) {
        this.customRemarkSize = customRemarkSize;
    }

    public Long getRuleId() {
        return ruleId;
    }

    public void setRuleId(Long ruleId) {
        this.ruleId = ruleId;
    }

    public String getExtRemark() {
        return extRemark;
    }

    public void setExtRemark(String extRemark) {
        this.extRemark = extRemark;
    }

    public List<RemarkFieldMetadata> getRemarkFiledMetadataBeanList() {
        return remarkFiledMetadataBeanList;
    }

    public void setRemarkFiledMetadataBeanList(List<RemarkFieldMetadata> remarkFiledMetadataBeanList) {
        this.remarkFiledMetadataBeanList = remarkFiledMetadataBeanList;
    }

    public BigDecimal getInvoiceLimit() {
        return invoiceLimit;
    }

    public void setInvoiceLimit(BigDecimal invoiceLimit) {
        this.invoiceLimit = invoiceLimit;
    }

    public List<String> getSplitFiledList() {
        return splitFiledList;
    }

    public void setSplitFiledList(List<String> splitFiledList) {
        this.splitFiledList = splitFiledList;
    }

    public String getItemSort() {
        return itemSort;
    }

    public void setItemSort(String itemSort) {
        this.itemSort = itemSort;
    }

    public Integer getSalesListMaxRow() {
        return salesListMaxRow;
    }

    public void setSalesListMaxRow(Integer salesListMaxRow) {
        this.salesListMaxRow = salesListMaxRow;
    }

    public String getUnitPriceAmountOps() {
        return unitPriceAmountOps;
    }

    public void setUnitPriceAmountOps(String unitPriceAmountOps) {
        this.unitPriceAmountOps = unitPriceAmountOps;
    }

    public String getAmountSplitRule() {
        return amountSplitRule;
    }

    public void setAmountSplitRule(String amountSplitRule) {
        this.amountSplitRule = amountSplitRule;
    }


    public Integer getInvoiceItemMaxRow() {
        return invoiceItemMaxRow;
    }

    public void setInvoiceItemMaxRow(Integer invoiceItemMaxRow) {
        this.invoiceItemMaxRow = invoiceItemMaxRow;
    }


    public String getSaleListOption() {
        return saleListOption;
    }

    public void setSaleListOption(String saleListOption) {
        this.saleListOption = saleListOption;
    }

    public String getInvoiceSpec() {
        return invoiceSpec;
    }

    public void setInvoiceSpec(String invoiceSpec) {
        this.invoiceSpec = invoiceSpec;
    }

    public String getInvoiceType() {
        return invoiceType;
    }

    public void setInvoiceType(String invoiceType) {
        this.invoiceType = invoiceType;
    }

    public PriceMethod getPriceMethod() {
        return priceMethod;
    }

    public void setPriceMethod(PriceMethod priceMethod) {
        this.priceMethod = priceMethod;
    }

    public ZeroTaxOption getZeroTaxOption() {
        return zeroTaxOption;
    }

    public void setZeroTaxOption(ZeroTaxOption zeroTaxOption) {
        this.zeroTaxOption = zeroTaxOption;
    }

    public String getFixedRemarkText() {
        return fixedRemarkText;
    }

    public void setFixedRemarkText(String fixedRemarkText) {
        this.fixedRemarkText = fixedRemarkText;
    }


    public boolean isLimitIsAmountWithTax() {
        return limitIsAmountWithTax;
    }

    public void setLimitIsAmountWithTax(boolean limitIsAmountWithTax) {
        this.limitIsAmountWithTax = limitIsAmountWithTax;
    }

    public List<RemarkFieldMetadata> getCargoNameFiledMetadatas() {
        return cargoNameFiledMetadatas;
    }

    public void setCargoNameFiledMetadatas(List<RemarkFieldMetadata> cargoNameFiledMetadatas) {
        this.cargoNameFiledMetadatas = cargoNameFiledMetadatas;
    }

    public List<RemarkFieldMetadata> getItemSpecFiledMetadatas() {
        return itemSpecFiledMetadatas;
    }

    public void setItemSpecFiledMetadatas(List<RemarkFieldMetadata> itemSpecFiledMetadatas) {
        this.itemSpecFiledMetadatas = itemSpecFiledMetadatas;
    }

    public Integer getCargoNameLength() {
        return cargoNameLength;
    }

    public void setCargoNameLength(Integer cargoNameLength) {
        this.cargoNameLength = cargoNameLength;
    }

    public Integer getItemSpecNameLength() {
        return itemSpecNameLength;
    }

    public void setItemSpecNameLength(Integer itemSpecNameLength) {
        this.itemSpecNameLength = itemSpecNameLength;
    }

    public Integer getUnitPriceScale() {
        return unitPriceScale;
    }

    public void setUnitPriceScale(Integer unitPriceScale) {
        this.unitPriceScale = unitPriceScale;
    }

    public boolean isMergeBySplitFiled() {
        return mergeBySplitFiled;
    }

    public void setMergeBySplitFiled(boolean mergeBySplitFiled) {
        this.mergeBySplitFiled = mergeBySplitFiled;
    }


    public boolean isIgnoreAllowableError() {
        return ignoreAllowableError;
    }

    public void setIgnoreAllowableError(boolean ignoreAllowableError) {
        this.ignoreAllowableError = ignoreAllowableError;
    }

    public BigDecimal getDiscountLimit() {
        return discountLimit;
    }

    public void setDiscountLimit(BigDecimal discountLimit) {
        this.discountLimit = discountLimit;
    }

    @Override
    public String toString() {
        return JSON.toJSONString(this);
    }
}
