/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.phoenix.split.model;

import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;

public enum ItemTypeCodeEnum {
    VEHICLE("jdc", "\u673a\u52a8\u8f66", "4"),
    OIL("CPY", "\u6210\u54c1\u6cb9", "2"),
    MINERALS("KCP", "\u77ff\u4ea7\u54c1", "9"),
    BUILDING("03", "\u5efa\u7b51\u670d\u52a1", "5"),
    CARGO_TRANSPORT("04", "\u8d27\u7269\u8fd0\u8f93\u670d\u52a1", "6"),
    PROPERTY_SALE("05", "\u4e0d\u52a8\u4ea7\u9500\u552e", "7"),
    PROPERTY_RENT("06", "\u4e0d\u52a8\u4ea7\u7ecf\u8425\u79df\u51ed\u670d\u52a1", "8"),
    AGRICULTURAL_PRODUCTS_SALE("12", "\u519c\u4ea7\u54c1\u9500\u552e", "10"),
    AGRICULTURAL_PRODUCT_ACQUISITION("16", "\u519c\u4ea7\u54c1\u6536\u8d2d", "12"),
    SCRAPPED_PRODUCT_ACQUISITION("24", "\u62a5\u5e9f\u4ea7\u54c1\u6536\u8d2d", "11"),
    GOLD_WHOLE_SALE("26", "\u91d1\u94f6\u9996\u9970\u6279\u53d1", "60"),
    GOLD_RETAIL("27", "\u91d1\u94f6\u9996\u9970\u96f6\u552e", "61");

    private final String value;
    private final String description;
    private final String specialInvoiceFlag;

    public static ItemTypeCodeEnum fromValue(String value) {
        for (ItemTypeCodeEnum itemTypeCodeEnum : ItemTypeCodeEnum.values()) {
            if (!itemTypeCodeEnum.getValue().equals(value)) continue;
            return itemTypeCodeEnum;
        }
        return null;
    }

    public static Optional<ItemTypeCodeEnum> getEnumByValueIgnoreCase(String value) {
        return value == null ? Optional.empty() : Stream.of(ItemTypeCodeEnum.values()).filter(r -> r.getValue().equalsIgnoreCase(value)).findFirst();
    }

    public static boolean isAllElectronicSpecialInvoice(String itemTypeCode) {
        return Arrays.asList(ItemTypeCodeEnum.BUILDING.value, ItemTypeCodeEnum.CARGO_TRANSPORT.value, ItemTypeCodeEnum.PROPERTY_SALE.value, ItemTypeCodeEnum.PROPERTY_RENT.value, ItemTypeCodeEnum.SCRAPPED_PRODUCT_ACQUISITION.value).contains(itemTypeCode);
    }

    public static boolean isAllElectronicPropertySpecialInvoice(String itemTypeCode) {
        return Arrays.asList(ItemTypeCodeEnum.PROPERTY_SALE.value, ItemTypeCodeEnum.PROPERTY_RENT.value).contains(itemTypeCode);
    }

    public static List<String> specialInvoiceAddressKeyWord() {
        return Arrays.asList("\u8857", "\u8def", "\u6751", "\u4e61", "\u9547", "\u9053", "\u5df7", "\u53f7");
    }

    public static boolean isSpecialInvoice(String itemTypeCode) {
        return Arrays.asList(ItemTypeCodeEnum.MINERALS.value, ItemTypeCodeEnum.OIL.value, ItemTypeCodeEnum.AGRICULTURAL_PRODUCTS_SALE.value, ItemTypeCodeEnum.AGRICULTURAL_PRODUCT_ACQUISITION.value, ItemTypeCodeEnum.GOLD_WHOLE_SALE.value, ItemTypeCodeEnum.GOLD_RETAIL.value).contains(itemTypeCode);
    }

    public static boolean isSpecialInvoiceAndJDC(String itemTypeCode) {
        return Arrays.asList(ItemTypeCodeEnum.MINERALS.value, ItemTypeCodeEnum.OIL.value, ItemTypeCodeEnum.AGRICULTURAL_PRODUCTS_SALE.value, ItemTypeCodeEnum.VEHICLE.value, ItemTypeCodeEnum.AGRICULTURAL_PRODUCT_ACQUISITION.value, ItemTypeCodeEnum.GOLD_WHOLE_SALE.value, ItemTypeCodeEnum.GOLD_RETAIL.value).contains(itemTypeCode);
    }

    private ItemTypeCodeEnum(String value, String description, String specialInvoiceFlag) {
        this.value = value;
        this.description = description;
        this.specialInvoiceFlag = specialInvoiceFlag;
    }

    public String getValue() {
        return this.value;
    }

    public String getDescription() {
        return this.description;
    }

    public String getSpecialInvoiceFlag() {
        return this.specialInvoiceFlag;
    }
}

