package com.xforceplus.phoenix.split.constant;

import java.util.Arrays;
import java.util.List;

/**
 * @Author chenlingwei
 * @create 2023/3/1 11:14 AM
 */
public enum ProductMinerals {

    DEFAULT("", "矿产品", Arrays.asList("吨", "立方米", "千克", "克", "克拉")),
    NATURAL_OIL("1020201010000000000", "天然原油", Arrays.asList("桶")),
    ASPHALT_OIL("1020201020000000000", "沥青矿原油", Arrays.asList("桶"));

    String value;

    /**
     * 税收名称
     */
    String description;
    List<String> quantityUnits;

    ProductMinerals(String value, String description, List<String> quantityUnits) {
        this.value = value;
        this.description = description;
        this.quantityUnits = quantityUnits;
    }

    public String getValue() {
        return value;
    }

    public String getDescription() {
        return description;
    }

    public List<String> getQuantityUnits() {
        return quantityUnits;
    }

    public static List<String> getMineralQuantityUnits() {
        return Arrays.asList("吨", "立方米", "千克", "克", "克拉", "桶");
    }

    public static List<String> getMineralOilGoodsTaxNos() {
        return Arrays.asList(NATURAL_OIL.value, ASPHALT_OIL.value);
    }
}
