package com.xforceplus.phoenix.split.constant;

import com.xforceplus.phoenix.split.exception.SplitRuleParamException;
import org.apache.commons.lang3.StringUtils;

import java.util.Arrays;

/**
 * 规则配置的备注字段枚举
 * @Author chenlingwei
 * @create 6/8/22 4:18 PM
 */
public enum RemarkFieldNameEnum {

    /**
     * 原生备注内容
     */
    REMARK("remark"),

    /**
     * 固定备注内容
     */
    FIXED_REMARK("fixedRemark"),

    /**
     * 是否享受优惠政策
     */
    TAX_PRE("taxPre"),

    /**
     * 零税率标志
     */
    ZERO_TAX("zeroTax"),

    /**
     * 计价方式
     */
    PRICE_METHOD("priceMethod"),

    /**
     * 金额类备注
     */
    AMOUNT_WITHOUT_TAX("amountWithoutTax"),

    AMOUNT_WITH_TAX("amountWithTax"),

    TAX_AMOUNT("taxAmount"),

    INNER_DISCOUNT_TAX("innerDiscountTax"),

    INNER_DISCOUNT_WITHOUT_TAX("innerDiscountWithoutTax"),

    INNER_DISCOUNT_WITH_TAX("innerDiscountWithTax"),

    OUTER_DISCOUNT_TAX("outterDiscountTax"),

    OUTER_DISCOUNT_WITHOUT_TAX("outterDiscountWithoutTax"),

    OUTER_DISCOUNT_WITH_TAX("outterDiscountWithTax");

    private String value;

    public String getValue() {
        return value;
    }

    RemarkFieldNameEnum(String value) {
        this.value = value;
    }

    /**
     * 是否为金额类备注
     * @param fieldName
     * @return
     */
    public static boolean isAmountKindField(String fieldName) {
        return Arrays.asList(
                AMOUNT_WITHOUT_TAX.value, AMOUNT_WITH_TAX.value, TAX_AMOUNT.value,
                INNER_DISCOUNT_TAX.value, INNER_DISCOUNT_WITHOUT_TAX.value, INNER_DISCOUNT_WITH_TAX.value,
                OUTER_DISCOUNT_TAX.value, OUTER_DISCOUNT_WITHOUT_TAX.value, OUTER_DISCOUNT_WITH_TAX.value).contains(fieldName);
    }

    public static RemarkFieldNameEnum getDefaultOrByValue(String value) {
        if (StringUtils.isBlank(value)) {
            return null;
        } else {
            for (RemarkFieldNameEnum returnMode : RemarkFieldNameEnum.values()) {
                if (returnMode.value.equals(value)) {
                    return returnMode;
                }
            }
        }
        throw new SplitRuleParamException(String.format("returnMode = [%s] is invalid", value));
    }
}
