package com.xforceplus.phoenix.split.constant;

public enum SpecialAreaUnitEnum {

    AREA_01("01","平方米","0"),
    AREA_02("02","亩","0"),
    AREA_03("03","㎡","0"),
    AREA_04("04","平方千米","0"),
    AREA_05("05","公顷","0"),
    AREA_06("06","h㎡","0"),
    AREA_07("07","k㎡","0"),
    AREA_08("08","米（铁路线与管道等使用）","1"),
    AREA_09("09","孔公里","2");


    private final String value;

    private final String description;


    private final String code;


    SpecialAreaUnitEnum(String value, String description, String code) {
        this.value = value;
        this.description = description;
        this.code = code;
    }

    public String getValue() {
        return value == null ? null : value.trim();
    }

    public String getDescription() {
        return description == null ? null : description.trim();
    }

    public String getCode() {
        return code == null ? null : code.trim();
    }

    public static SpecialAreaUnitEnum getEnum(String value) {
        for (SpecialAreaUnitEnum specialAreaUnitEnum : SpecialAreaUnitEnum.values()) {
            if (value.equals(specialAreaUnitEnum.getValue())) {
                return specialAreaUnitEnum;
            }
        }
        return null;
    }

}
