package com.xforceplus.phoenix.split.domain;

import com.alibaba.fastjson.JSON;
import com.xforceplus.phoenix.split.exception.SplitBizException;
import com.xforceplus.phoenix.split.model.PriceMethod;
import com.xforceplus.phoenix.split.model.SplitRule;
import com.xforceplus.phoenix.split.service.AmountSplitRuleUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.math.BigDecimal;

import static java.math.BigDecimal.ONE;
import static java.math.BigDecimal.ROUND_DOWN;
import static java.math.BigDecimal.ROUND_HALF_UP;
import static java.math.BigDecimal.ZERO;
import static java.math.RoundingMode.DOWN;
import static java.math.RoundingMode.HALF_DOWN;
import static java.math.RoundingMode.HALF_UP;
import static java.math.RoundingMode.UP;

/**
 * 明细金额信息
 */
public class ItemAmountInfo {

    private static final BigDecimal MIN_QUANTITY = BigDecimal.ONE.movePointLeft(6);

    private Logger logger = LoggerFactory.getLogger(ItemAmountInfo.class);

    private static final BigDecimal MAX_SPLIT_RATE = new BigDecimal("0.99");

    private String salesbillItemId;

    private PriceMethod priceMethod; // 价格方式 2

    private BigDecimal quantity; // 数量

    private BigDecimal unitPrice; // 单价

    private String quantityUnit; // 数量单位

    private BigDecimal taxRate; // 税率

    private BigDecimal amountWithoutTax; // 不含税金额

    private BigDecimal taxAmount; // 税额

    private BigDecimal amountWithTax; // 含税金额

    private BigDecimal discountWithoutTax = BigDecimal.ZERO; // 不含税折扣金额(价外相加)

    private BigDecimal discountTax = BigDecimal.ZERO; // 折扣税额(价外相加)

    private BigDecimal discountWithTax = BigDecimal.ZERO; // 含税折扣金额(价外相加)

    private BigDecimal deductions = BigDecimal.ZERO; // 扣除额

    private BigDecimal outterDiscountWithTax = BigDecimal.ZERO; // 价外折扣含税

    private BigDecimal outterDiscountWithoutTax = BigDecimal.ZERO; // 价外折扣不含税

    private BigDecimal outterDiscountTax = BigDecimal.ZERO; // 价外折扣税额

    private BigDecimal innerDiscountWithTax = BigDecimal.ZERO; // 价内折扣含税

    private BigDecimal innerDiscountWithoutTax = BigDecimal.ZERO; // 价内折扣不含税

    private BigDecimal innerDiscountTax = BigDecimal.ZERO; // 价内折扣税额

    private BigDecimal outterPrepayAmountWithTax = BigDecimal.ZERO; // 价外预付卡含税

    private BigDecimal outterPrepayAmountWithoutTax = BigDecimal.ZERO; // 价外预付卡不含税

    private BigDecimal outterPrepayAmountTax = BigDecimal.ZERO; // 价外预付卡税额

    private BigDecimal innerPrepayAmountWithTax = BigDecimal.ZERO; // 价内预付卡含税

    private BigDecimal innerPrepayAmountWithoutTax = BigDecimal.ZERO; // 价内预付卡不含税

    private BigDecimal innerPrepayAmountTax = BigDecimal.ZERO; // 价内预付卡税额

    private boolean flag;

    private BigDecimal balanceInvoiceAmount;

    public String getSalesbillItemId() {
        return salesbillItemId;
    }

    public void setSalesbillItemId(String billItemId) {
        this.salesbillItemId = billItemId;
    }

    public boolean getFlag() {
        return flag;
    }

    public void setFlag(boolean flag) {
        this.flag = flag;
    }

    public PriceMethod getPriceMethod() {
        return priceMethod;
    }

    public void setPriceMethod(PriceMethod priceMethod) {
        this.priceMethod = priceMethod;
    }

    public BigDecimal getQuantity() {
        return quantity;
    }

    public void setQuantity(BigDecimal quantity) {
        this.quantity = quantity;
    }

    public BigDecimal getUnitPrice() {
        return unitPrice;
    }

    public void setUnitPrice(BigDecimal unitPrice) {
        this.unitPrice = unitPrice;
    }

    public String getQuantityUnit() {
        return quantityUnit;
    }

    public void setQuantityUnit(String quantityUnit) {
        this.quantityUnit = quantityUnit;
    }

    public BigDecimal getTaxRate() {
        return taxRate;
    }

    public void setTaxRate(BigDecimal taxRate) {
        this.taxRate = taxRate;
    }

    public BigDecimal getAmountWithoutTax() {
        return amountWithoutTax;
    }

    public void setAmountWithoutTax(BigDecimal amountWithoutTax) {
        this.amountWithoutTax = amountWithoutTax;
    }

    public BigDecimal getTaxAmount() {
        return taxAmount;
    }

    public void setTaxAmount(BigDecimal taxAmount) {
        this.taxAmount = taxAmount;
    }

    public BigDecimal getAmountWithTax() {
        return amountWithTax;
    }

    public void setAmountWithTax(BigDecimal amountWithTax) {
        this.amountWithTax = amountWithTax;
    }

    public BigDecimal getDiscountWithoutTax() {
        return discountWithoutTax;
    }

    public void setDiscountWithoutTax(BigDecimal discountWithoutTax) {
        this.discountWithoutTax = discountWithoutTax;
    }

    public BigDecimal getDiscountTax() {
        return discountTax == null ? ZERO : discountTax;
    }

    public void setDiscountTax(BigDecimal discountTax) {
        this.discountTax = discountTax;
    }

    public BigDecimal getDiscountWithTax() {
        return discountWithTax;
    }

    public void setDiscountWithTax(BigDecimal discountWithTax) {
        this.discountWithTax = discountWithTax;
    }

    public BigDecimal getDeductions() {
        return deductions;
    }

    public void setDeductions(BigDecimal deductions) {
        this.deductions = deductions;
    }

    public BigDecimal getOutterDiscountWithTax() {
        return outterDiscountWithTax;
    }

    public void setOutterDiscountWithTax(BigDecimal outterDiscountWithTax) {
        this.outterDiscountWithTax = outterDiscountWithTax;
    }

    public BigDecimal getOutterDiscountWithoutTax() {
        return outterDiscountWithoutTax;
    }

    public void setOutterDiscountWithoutTax(BigDecimal outterDiscountWithoutTax) {
        this.outterDiscountWithoutTax = outterDiscountWithoutTax;
    }

    public BigDecimal getOutterDiscountTax() {
        return outterDiscountTax;
    }

    public void setOutterDiscountTax(BigDecimal outterDiscountTax) {
        this.outterDiscountTax = outterDiscountTax;
    }

    public BigDecimal getInnerDiscountWithTax() {
        return innerDiscountWithTax;
    }

    public void setInnerDiscountWithTax(BigDecimal innerDiscountWithTax) {
        this.innerDiscountWithTax = innerDiscountWithTax;
    }

    public BigDecimal getInnerDiscountWithoutTax() {
        return innerDiscountWithoutTax;
    }

    public void setInnerDiscountWithoutTax(BigDecimal innerDiscountWithoutTax) {
        this.innerDiscountWithoutTax = innerDiscountWithoutTax;
    }

    public BigDecimal getInnerDiscountTax() {
        return innerDiscountTax;
    }

    public void setInnerDiscountTax(BigDecimal innerDiscountTax) {
        this.innerDiscountTax = innerDiscountTax;
    }

    public BigDecimal getOutterPrepayAmountWithTax() {
        return outterPrepayAmountWithTax;
    }

    public void setOutterPrepayAmountWithTax(BigDecimal outterPrepayAmountWithTax) {
        this.outterPrepayAmountWithTax = outterPrepayAmountWithTax;
    }

    public BigDecimal getOutterPrepayAmountWithoutTax() {
        return outterPrepayAmountWithoutTax;
    }

    public void setOutterPrepayAmountWithoutTax(BigDecimal outterPrepayAmountWithoutTax) {
        this.outterPrepayAmountWithoutTax = outterPrepayAmountWithoutTax;
    }

    public BigDecimal getOutterPrepayAmountTax() {
        return outterPrepayAmountTax;
    }

    public void setOutterPrepayAmountTax(BigDecimal outterPrepayAmountTax) {
        this.outterPrepayAmountTax = outterPrepayAmountTax;
    }

    public BigDecimal getInnerPrepayAmountWithTax() {
        return innerPrepayAmountWithTax;
    }

    public void setInnerPrepayAmountWithTax(BigDecimal innerPrepayAmountWithTax) {
        this.innerPrepayAmountWithTax = innerPrepayAmountWithTax;
    }

    public BigDecimal getInnerPrepayAmountWithoutTax() {
        return innerPrepayAmountWithoutTax;
    }

    public void setInnerPrepayAmountWithoutTax(BigDecimal innerPrepayAmountWithoutTax) {
        this.innerPrepayAmountWithoutTax = innerPrepayAmountWithoutTax;
    }

    public BigDecimal getInnerPrepayAmountTax() {
        return innerPrepayAmountTax;
    }

    public void setInnerPrepayAmountTax(BigDecimal innerPrepayAmountTax) {
        this.innerPrepayAmountTax = innerPrepayAmountTax;
    }

    public BigDecimal getBalanceInvoiceAmount() {
        return balanceInvoiceAmount;
    }

    public void setBalanceInvoiceAmount(BigDecimal balanceInvoiceAmount) {
        this.balanceInvoiceAmount = balanceInvoiceAmount;
    }

    /**
     * `
     * 根据限额计算不含税金额，按比例拆分单据金额
     */
    public ItemAmountInfo createItemAmountByAmountWithoutTax(SplitRule rule, BigDecimal limitAmount) {
        ItemAmountInfo newItemAmountInfo = JSON.parseObject(JSON.toJSONString(this), ItemAmountInfo.class);

        BigDecimal splitRate = limitAmount.divide(amountWithoutTax.subtract(discountWithoutTax), 10, ROUND_DOWN);
        if (splitRate.compareTo(MAX_SPLIT_RATE) > 0) {
            splitRate = MAX_SPLIT_RATE;
        }

        BigDecimal splitAmountWithoutTax = amountWithoutTax.multiply(splitRate).setScale(2, ROUND_HALF_UP);

        newItemAmountInfo.setAmountWithoutTax(splitAmountWithoutTax);
        processUnitPriceAndQuantity(newItemAmountInfo, rule);
        splitRate = newItemAmountInfo.getAmountWithoutTax().divide(amountWithoutTax, 10, ROUND_DOWN);

        splitAmountWithoutTax = newItemAmountInfo.getAmountWithoutTax();

        BigDecimal splitDeductions = deductions.multiply(splitRate).setScale(2, ROUND_DOWN);
        BigDecimal splitTaxAmount = splitAmountWithoutTax.subtract(splitDeductions).multiply(taxRate).setScale(2, ROUND_DOWN);
        BigDecimal splitAmountWithTax = splitAmountWithoutTax.add(splitTaxAmount);

        newItemAmountInfo.setAmountWithTax(splitAmountWithTax);
        newItemAmountInfo.setTaxAmount(splitTaxAmount);
        newItemAmountInfo.setDeductions(splitDeductions);
        this.splitDiscountByRateWithoutTax(newItemAmountInfo, splitRate);

        return newItemAmountInfo;
    }

    /**
     * 根据含税金额拆分
     */
    public ItemAmountInfo createItemAmountByAmountWithTax(SplitRule rule, BigDecimal limitAmount) {
        ItemAmountInfo newItemAmountInfo = JSON.parseObject(JSON.toJSONString(this), ItemAmountInfo.class);

        BigDecimal splitRate = limitAmount.divide(this.amountWithTax.subtract(this.discountWithTax), 20, ROUND_DOWN);

        BigDecimal splitDiscountAmountWithTax = this.discountWithTax.multiply(splitRate).setScale(2, HALF_UP);
        BigDecimal splitAmountWithTax = limitAmount.add(splitDiscountAmountWithTax).setScale(2, HALF_UP);
        BigDecimal splitDeductions = this.deductions.multiply(splitRate).setScale(2, HALF_UP);
        BigDecimal splitAmountWithoutTax = splitAmountWithTax.add(splitDeductions.multiply(taxRate))
                .divide(BigDecimal.ONE.add(taxRate), 2, HALF_UP);
        BigDecimal splitTaxAmount = splitAmountWithTax.subtract(splitAmountWithoutTax);

        newItemAmountInfo.setAmountWithoutTax(splitAmountWithoutTax);
        processUnitPriceAndQuantity(newItemAmountInfo, rule);

        if (newItemAmountInfo.getAmountWithoutTax().compareTo(splitAmountWithoutTax) != 0) {//不含税金额改变
            splitTaxAmount = newItemAmountInfo.getAmountWithoutTax().subtract(splitDeductions)
                    .multiply(taxRate).setScale(2, HALF_UP);
            splitAmountWithTax = newItemAmountInfo.getAmountWithoutTax().add(splitTaxAmount);
            if (splitDiscountAmountWithTax.compareTo(ZERO) > 0) {//有折扣的场景
                if (splitAmountWithTax.compareTo(limitAmount) <= 0) {
                    throw new SplitBizException("按照指定含税金额拆分时折扣无法拆分!");
                }
                splitDiscountAmountWithTax = splitAmountWithTax.subtract(limitAmount);
            } else {
                newItemAmountInfo.setFlag(true);
                logger.warn("处理单价数量时不含税金额已改变,如果没有折扣则不能按照指定含税金额拆分");
            }
        }

        newItemAmountInfo.setAmountWithTax(splitAmountWithTax);
        newItemAmountInfo.setTaxAmount(splitTaxAmount);
        newItemAmountInfo.setDeductions(splitDeductions);
        newItemAmountInfo.setDiscountWithTax(splitDiscountAmountWithTax);
        this.splitDiscountAmountByAmountWithTax(newItemAmountInfo);
        return newItemAmountInfo;
    }

    /**
     * 根据数量限额拆分
     */
    public ItemAmountInfo createItemAmountByQuantity(BigDecimal limitQuantity) {
        ItemAmountInfo newItemAmountInfo = JSON.parseObject(JSON.toJSONString(this), ItemAmountInfo.class);

        BigDecimal splitAmountWithoutTax = limitQuantity.multiply(unitPrice).setScale(2, HALF_UP);
        newItemAmountInfo.setAmountWithoutTax(splitAmountWithoutTax);
        newItemAmountInfo.setQuantity(limitQuantity);

        BigDecimal splitRate = newItemAmountInfo.getQuantity().divide(quantity, 10, DOWN);
        BigDecimal splitDeductions = deductions.multiply(splitRate).setScale(2, DOWN);
        BigDecimal splitTaxAmount = splitAmountWithoutTax.subtract(splitDeductions).multiply(taxRate).setScale(2, DOWN);
        BigDecimal splitAmountWithTax = splitAmountWithoutTax.add(splitTaxAmount);

        newItemAmountInfo.setAmountWithTax(splitAmountWithTax);
        newItemAmountInfo.setTaxAmount(splitTaxAmount);
        newItemAmountInfo.setDeductions(splitDeductions);

        this.splitDiscountByRateWithoutTax(newItemAmountInfo, splitRate);

        return newItemAmountInfo;
    }

    private void splitDiscountAmountByAmountWithTax(ItemAmountInfo newItemAmountInfo) {
        BigDecimal splitDiscountWithTax = newItemAmountInfo.getDiscountWithTax();
        if (splitDiscountWithTax.compareTo(ZERO) > 0) {
            BigDecimal splitDiscountWithoutTax = splitDiscountWithTax.divide(ONE.add(taxRate), 2, HALF_UP);
            BigDecimal splitDiscountTax = splitDiscountWithTax.subtract(splitDiscountWithoutTax);

            newItemAmountInfo.setDiscountTax(splitDiscountTax);
            newItemAmountInfo.setDiscountWithoutTax(splitDiscountWithoutTax);
        }
    }

    private void processUnitPriceAndQuantity(ItemAmountInfo newItemAmountInfo, SplitRule rule) {

        int unitPriceScale = rule.getUnitPriceScale();

        if (AmountSplitRuleUtils.isQuantity(rule.getAmountSplitRule())) {
            newItemAmountInfo.calculateUnitPrice(unitPriceScale);

        } else if (AmountSplitRuleUtils.isUnitPriceAndQuantityInteger(rule.getAmountSplitRule()) ||
                AmountSplitRuleUtils.recalculateQuantityRounding(rule.getAmountSplitRule())) {
            if (newItemAmountInfo.getUnitPrice().compareTo(BigDecimal.ZERO) > 0) {
                BigDecimal quantity = newItemAmountInfo.getAmountWithoutTax().divide(newItemAmountInfo.getUnitPrice(), 0, ROUND_DOWN);
                if (quantity.compareTo(BigDecimal.ZERO) != 0) {
                    newItemAmountInfo.calculateQuantityAndQuantityInteger();
                } else {
                    newItemAmountInfo.calculateQuantity(unitPriceScale);
                }
            }

        } else if (AmountSplitRuleUtils.isUnitPrice(rule.getAmountSplitRule()) ||
                AmountSplitRuleUtils.isUnitPriceAndRecalculateQuantity(rule.getAmountSplitRule())) {

            newItemAmountInfo.calculateQuantity(unitPriceScale);

        } else {
            throw new IllegalArgumentException(String.format("rule.amountSplitRule = [%s] is illegal!", rule.getAmountSplitRule()));
        }
    }

    /**
     * 扣除拆分金额
     */
    public void deductNewItemAmount(ItemAmountInfo newItemAmountInfo) {
        this.amountWithoutTax = this.amountWithoutTax.subtract(newItemAmountInfo.getAmountWithoutTax());
        this.amountWithTax = this.amountWithTax.subtract(newItemAmountInfo.getAmountWithTax());
        this.taxAmount = this.taxAmount.subtract(newItemAmountInfo.getTaxAmount());

        this.deductions = this.deductions.subtract(newItemAmountInfo.getDeductions());

        this.discountTax = this.discountTax.subtract(newItemAmountInfo.getDiscountTax());
        this.discountWithoutTax = this.discountWithoutTax.subtract(newItemAmountInfo.getDiscountWithoutTax());
        this.discountWithTax = this.discountWithTax.subtract(newItemAmountInfo.getDiscountWithTax());

    }

    /**
     * 拆分不含税折扣字段，并推算含税折扣跟折扣税额
     */
    private void splitDiscountByRateWithoutTax(ItemAmountInfo newItemAmountInfo, BigDecimal splitRate) {
        BigDecimal discountWithoutTax = this.discountWithoutTax.multiply(splitRate).setScale(2,
                UP);
        BigDecimal discountTax = discountWithoutTax.multiply(this.taxRate).setScale(2, ROUND_DOWN);
        BigDecimal discountWithTax = discountWithoutTax.add(discountTax);

        newItemAmountInfo.setDiscountWithTax(discountWithTax);
        newItemAmountInfo.setDiscountTax(discountTax);
        newItemAmountInfo.setDiscountWithoutTax(discountWithoutTax);

    }

    /**
     * 拆分不含税折扣字段，并推算含税折扣跟折扣税额
     */
    private void bwSplitDiscountByRateWithoutTax(ItemAmountInfo newItemAmountInfo, BigDecimal splitRate) {
        BigDecimal discountWithoutTax = this.discountWithoutTax.multiply(splitRate).setScale(2,
                UP);
        BigDecimal discountTax = discountWithoutTax.multiply(this.taxRate).setScale(2, HALF_DOWN);
        BigDecimal discountWithTax = discountWithoutTax.add(discountTax);

        newItemAmountInfo.setDiscountWithTax(discountWithTax);
        newItemAmountInfo.setDiscountTax(discountTax);
        newItemAmountInfo.setDiscountWithoutTax(discountWithoutTax);

    }

    private void calculateQuantityAndQuantityInteger() {
        if (unitPrice.compareTo(BigDecimal.ZERO) > 0) {
            quantity = amountWithoutTax.divide(unitPrice, 0, ROUND_DOWN);
            if (quantity.compareTo(BigDecimal.ZERO) != 0) {
                amountWithoutTax = quantity.multiply(unitPrice).setScale(2, ROUND_HALF_UP);
            }
        }
    }

    private void calculateUnitPrice(int unitPriceScale) {
        if (quantity.compareTo(BigDecimal.ZERO) > 0) {
            unitPrice = amountWithoutTax.divide(quantity, unitPriceScale, ROUND_DOWN);
            amountWithoutTax = quantity.multiply(unitPrice).setScale(2, ROUND_HALF_UP);
        }
    }

    private void calculateQuantity(int unitPriceScale) {
        if (unitPrice.compareTo(BigDecimal.ZERO) > 0) {
            quantity = amountWithoutTax.divide(unitPrice, 6,
                    ROUND_DOWN);

            BigDecimal newAmountWithoutTax = quantity.multiply(unitPrice).setScale(2, ROUND_HALF_UP);
            if (newAmountWithoutTax.compareTo(amountWithoutTax) < 0) {
                if (quantity.compareTo(BigDecimal.ZERO) == 0) {
                    quantity = MIN_QUANTITY;
                    unitPrice = amountWithoutTax.divide(quantity, unitPriceScale, ROUND_HALF_UP);
                } else {
                    amountWithoutTax = newAmountWithoutTax;
                }
            }
        }
    }

    /**
     * 百旺计算逻辑
     * 根据限额计算不含税金额，按比例拆分单据金额
     */
    public ItemAmountInfo bwCreateItemAmountByAmountWithoutTax(SplitRule rule, BigDecimal limitAmount) {
        ItemAmountInfo newItemAmountInfo = JSON.parseObject(JSON.toJSONString(this), ItemAmountInfo.class);
        BigDecimal splitRate = limitAmount.divide(amountWithoutTax.subtract(discountWithoutTax), 10, DOWN);
        if (splitRate.compareTo(MAX_SPLIT_RATE) > 0) {
            splitRate = MAX_SPLIT_RATE;
        }
        BigDecimal splitAmountWithoutTax = amountWithoutTax.multiply(splitRate).setScale(2, HALF_UP);
        newItemAmountInfo.setAmountWithoutTax(splitAmountWithoutTax);
        bwProcessUnitPriceAndQuantity(newItemAmountInfo, rule);
        splitRate = newItemAmountInfo.getAmountWithoutTax().divide(amountWithoutTax, 10, HALF_DOWN);
        splitAmountWithoutTax = newItemAmountInfo.getAmountWithoutTax();
        BigDecimal splitDeductions = deductions.multiply(splitRate).setScale(2, DOWN);
        BigDecimal splitTaxAmount = splitAmountWithoutTax.subtract(splitDeductions).multiply(taxRate).setScale(2, HALF_DOWN);
        BigDecimal splitAmountWithTax = splitAmountWithoutTax.add(splitTaxAmount);
        newItemAmountInfo.setAmountWithTax(splitAmountWithTax);
        newItemAmountInfo.setTaxAmount(splitTaxAmount);
        newItemAmountInfo.setDeductions(splitDeductions);
        this.bwSplitDiscountByRateWithoutTax(newItemAmountInfo, splitRate);
        return newItemAmountInfo;
    }

    /**
     * 百旺反算规则
     * @param newItemAmountInfo
     * @param rule
     */
    private void bwProcessUnitPriceAndQuantity(ItemAmountInfo newItemAmountInfo, SplitRule rule) {

        int unitPriceScale = rule.getUnitPriceScale();
        if (AmountSplitRuleUtils.isQuantity(rule.getAmountSplitRule())) {
            newItemAmountInfo.calculateUnitPrice(unitPriceScale);

        } else if (AmountSplitRuleUtils.isUnitPriceAndQuantityInteger(rule.getAmountSplitRule()) ||
                AmountSplitRuleUtils.recalculateQuantityRounding(rule.getAmountSplitRule())) {
            if (newItemAmountInfo.getUnitPrice().compareTo(BigDecimal.ZERO) > 0) {
                BigDecimal quantity = newItemAmountInfo.getAmountWithoutTax().divide(newItemAmountInfo.getUnitPrice(), 0, ROUND_DOWN);
                if (quantity.compareTo(BigDecimal.ZERO) != 0) {
                    newItemAmountInfo.calculateQuantityAndQuantityInteger();
                } else {
                    newItemAmountInfo.calculateQuantity(unitPriceScale);
                }
            }
        } else if (AmountSplitRuleUtils.isUnitPrice(rule.getAmountSplitRule()) || AmountSplitRuleUtils.isUnitPriceAndRecalculateQuantity(rule.getAmountSplitRule())) {
            newItemAmountInfo.bwCalculateQuantity(rule.getInvoiceLimit());
        } else {
            throw new IllegalArgumentException(String.format("rule.amountSplitRule = [%s] is illegal!", rule.getAmountSplitRule()));
        }
    }

    private void bwCalculateQuantity(BigDecimal limite) {
        if (unitPrice.compareTo(BigDecimal.ZERO) > 0) {
            quantity = amountWithoutTax.divide(unitPrice, 6, DOWN);
            if (quantity.compareTo(BigDecimal.ZERO) == 0) {
                throw new IllegalArgumentException(String.format("限额[%s] 单价 [%s],无法保证数量小数位6位 !", limite, unitPrice));
            }
            BigDecimal newAmountWithoutTax = quantity.multiply(unitPrice).setScale(2, HALF_UP);
            if (newAmountWithoutTax.compareTo(amountWithoutTax) < 0) {
                amountWithoutTax = newAmountWithoutTax;
            }
        }
    }

    @Override
    public String toString() {
        return JSON.toJSONString(this);
    }

}
