package com.xforceplus.phoenix.split.service.dataflow;

import com.xforceplus.phoenix.split.constant.TaxDeviceType;
import com.xforceplus.phoenix.split.domain.ItemGroup;
import com.xforceplus.phoenix.split.domain.RuleInfo;
import com.xforceplus.phoenix.split.model.BillInfo;
import com.xforceplus.phoenix.split.model.BillItem;

import java.math.BigDecimal;
import java.util.List;

/**
 * 数据处理插件接口
 */
public interface DataProcessPlugin {

    /**
     * 处理数据
     * @param itemGroups
     * @param ruleInfo
     * @return
     */
    List<ItemGroup> processData(List<ItemGroup> itemGroups, BillInfo billInfo, RuleInfo ruleInfo);

    /**
     * 根据不同的设备类型，进行不同的处理
     * @param itemGroups
     * @param billInfo
     * @param ruleInfo
     * @param taxDeviceType
     * @return
     */
    List<ItemGroup> processData(List<ItemGroup> itemGroups, BillInfo billInfo, RuleInfo ruleInfo, TaxDeviceType taxDeviceType);

    /**
     * 返回明细生成预制发票时占用行数
     *
     * @param item 单据明细
     * @return 明细生成预制发票时占用行数
     */
    default int needLineNum(BillItem item) {
        if (item.getDiscountWithoutTax().compareTo(BigDecimal.ZERO) > 0
                && (item.getOutterDiscountWithoutTax().compareTo(BigDecimal.ZERO) > 0
                // 有折扣时,判断税率汇总计数行是否存在
                || item.getOutterPrepayAmountWithoutTax().compareTo(BigDecimal.ZERO) > 0)) {
            return 2;
        }
        return 1;
    }
}
