package com.xforceplus.phoenix.split.service.dataflow.impl;

import com.xforceplus.phoenix.split.constant.TaxInvoiceSourceEnum;
import com.xforceplus.phoenix.split.domain.ItemGroup;
import com.xforceplus.phoenix.split.model.BillItem;
import com.xforceplus.phoenix.split.model.SplitRule;
import com.xforceplus.phoenix.split.service.dataflow.AbstractBillItemGroupPlugin;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.math.BigDecimal;
import java.util.List;

/**
 * 税编内容分组
 * @Author chenlingwei
 * @create 2023/7/26 2:15 PM
 */
@Service
public class GroupItemByTaxPreConPlugin extends AbstractBillItemGroupPlugin {

    @Override
    protected String generateKey(BillItem billItem, SplitRule rule) {
        //PHOENIX-56487数电下，不根据税率拆票时，若业务单下有0税率，仅【不征税】需要被单独拆分，其余0税率场景可开具在一张发票上
        return "不征税".equals(billItem.getTaxPreCon()) ? "no_taxation" : "else_zero_tax";
    }

    @Override
    protected boolean support(SplitRule rule, List<ItemGroup> itemGroups) {

        String taxInvoiceSource = rule.getTaxInvoiceSource();
        if (TaxInvoiceSourceEnum.QD.getValue().equals(taxInvoiceSource)) {

            return itemGroups.stream().anyMatch(e -> {
                List<BillItem> billItems = e.getBillItems();
                return !CollectionUtils.isEmpty(billItems) && billItems.stream().
                        filter(billItem -> StringUtils.isNotBlank(billItem.getTaxPreCon())).
                        anyMatch(billItem -> billItem.getTaxPreCon().equals("不征税"));
            });

        } else {
            return false;
        }

    }
}
