package com.xforceplus.phoenix.split.service.dataflow.impl;

import com.xforceplus.phoenix.split.constant.TaxDeviceType;
import com.xforceplus.phoenix.split.domain.ItemGroup;
import com.xforceplus.phoenix.split.domain.RuleInfo;
import com.xforceplus.phoenix.split.model.BillInfo;
import com.xforceplus.phoenix.split.model.BillItem;
import com.xforceplus.phoenix.split.service.dataflow.DataProcessPlugin;
import org.springframework.stereotype.Service;

import java.util.List;

@Service
public class RedBillItemProcessPlugin implements DataProcessPlugin {

    @Override
    public List<ItemGroup> processData(List<ItemGroup> itemGroups, BillInfo billInfo, RuleInfo ruleInfo) {

        for (ItemGroup itemGroup : itemGroups) {
            List<BillItem> billItems = itemGroup.getBillItems();
            billItems.forEach(billItem -> {
                if (isRedItem(billItem)) {
                    amount2Positive(billItem);
                }
            });
        }

        return itemGroups;
    }

    @Override
    public List<ItemGroup> processData(List<ItemGroup> itemGroups, BillInfo billInfo, RuleInfo ruleInfo, TaxDeviceType taxDeviceType) {
        return processData(itemGroups, billInfo, ruleInfo);
    }

    private void amount2Positive(BillItem billItem) {

        /**
         * 计算 红票下的 不含税金额 值 = 不含金额-价内折扣-预制发票金额（正负号的结果不一样）
         */
        billItem.setAmountWithoutTax(billItem.getAmountWithoutTax().subtract(billItem.getInnerDiscountWithoutTax()).subtract(billItem.getInnerPrepayAmountWithoutTax()));
        billItem.setAmountWithTax(billItem.getAmountWithTax().subtract(billItem.getInnerDiscountWithTax()).subtract(billItem.getInnerPrepayAmountWithTax()));
        billItem.setTaxAmount(billItem.getTaxAmount().subtract(billItem.getInnerPrepayAmountTax()).subtract(billItem.getInnerDiscountTax()));
        billItem.setDiscountWithTax(billItem.getOutterDiscountWithTax().add(billItem.getOutterPrepayAmountWithTax()));
        billItem.setDiscountTax(billItem.getOutterDiscountTax().add(billItem.getOutterPrepayAmountTax()));

        /**
         * 考虑到后续的 reCalulationItem 方法，需要保留原因的 价内折扣 ，预制发票数据，反算正值不含税金额，此次反算会在 reCalulationItem 抵消，不会影响最终的不含税等数据
         */
        billItem.setAmountWithoutTax(billItem.getAmountWithoutTax().abs().add(billItem.getInnerDiscountWithoutTax().abs()).add(billItem.getInnerPrepayAmountWithoutTax().abs()));
        billItem.setTaxAmount(billItem.getTaxAmount().abs().add(billItem.getInnerPrepayAmountTax().abs()).add(billItem.getInnerDiscountTax().abs()));
        billItem.setAmountWithTax(billItem.getAmountWithTax().abs().add(billItem.getInnerDiscountWithTax().abs()).add(billItem.getInnerPrepayAmountWithTax().abs()));

        billItem.setUnitPrice(billItem.getUnitPrice().abs());
        billItem.setOutterDiscountWithTax(billItem.getOutterDiscountWithTax().abs());
        billItem.setOutterDiscountWithoutTax(billItem.getOutterDiscountWithoutTax().abs());
        billItem.setOutterDiscountTax(billItem.getOutterDiscountTax().abs());
        billItem.setInnerDiscountWithTax(billItem.getInnerDiscountWithTax().abs());
        billItem.setInnerDiscountWithoutTax(billItem.getInnerDiscountWithoutTax().abs());
        billItem.setInnerDiscountTax(billItem.getInnerDiscountTax().abs());
        billItem.setInnerPrepayAmountWithTax(billItem.getInnerPrepayAmountWithTax().abs());
        billItem.setInnerPrepayAmountWithoutTax(billItem.getInnerPrepayAmountWithoutTax().abs());
        billItem.setInnerPrepayAmountTax(billItem.getInnerPrepayAmountTax().abs());
        billItem.setOutterPrepayAmountWithTax(billItem.getOutterPrepayAmountWithTax().abs());
        billItem.setOutterPrepayAmountWithoutTax(billItem.getOutterPrepayAmountWithoutTax().abs());
        billItem.setOutterPrepayAmountTax(billItem.getOutterPrepayAmountTax().abs());
        billItem.setQuantity(billItem.getQuantity().abs());

        billItem.setDeductions(billItem.getDeductions().abs());

    }

    private boolean isRedItem(BillItem billItem) {
        return billItem.isRedItem();
    }
}
