package com.xforceplus.phoenix.split.service.impl;

import com.alibaba.fastjson.JSON;
import com.xforceplus.phoenix.split.domain.ItemAmountInfo;
import com.xforceplus.phoenix.split.exception.BWSplitRuleSpliteAmountException;
import com.xforceplus.phoenix.split.model.SplitRule;
import org.springframework.beans.BeanUtils;

import java.math.BigDecimal;
import java.util.*;

import static java.math.RoundingMode.*;

/**
 * 百旺拆票规则实现类,不含税金额拆票 已废弃（百旺0.005元规则不存在）
 */
@Deprecated
public class BWSplitBillItemWithOutTaxServiceImpl extends DefaultSplitBillItemAmountServiceImpl {
    /**
     *
     * @param itemAmountInfo
     * @param rule
     * @return
     */
    @Override
    public List<ItemAmountInfo> splitAmount(ItemAmountInfo itemAmountInfo, SplitRule rule) {

        ItemAmountInfo splitAmountInfo = JSON.parseObject(JSON.toJSONString(itemAmountInfo), ItemAmountInfo.class);
        mergeDiscountAmount(splitAmountInfo);
        ItemAmountInfo tmpAountInfo = new ItemAmountInfo();
        BeanUtils.copyProperties(splitAmountInfo, tmpAountInfo);
        BigDecimal limitAmount = rule.getInvoiceLimit();
        /**
         * 计算最初的最优拆分数据
         */
        ItemAmountInfo splitItemAmountInfo  = splitFirstItemAmountInfo(rule, splitAmountInfo, limitAmount);
        /**
         * 找出最优的 不含税金额 组合
         */
        List<ItemAmountInfo> itemAmountInfos = optimumItemAmount(splitItemAmountInfo, splitAmountInfo, rule);
        return itemAmountInfos;
    }


    @Override
    protected ItemAmountInfo splitFirstItemAmountInfo(SplitRule rule, ItemAmountInfo itemAmountInfo, BigDecimal limitAmount) {
        return itemAmountInfo.bwCreateItemAmountByAmountWithoutTax( rule, limitAmount);
    }

    /**
     * 查找最佳值,
     * 从限额开始，列举20个值，每个值递减0.01,
     * 每个值乘以税率，计算精确税额，以及 税额四舍五入后 与精确值的差值，标记为X
     * 依次执行，得出20个X 值
     * 计算X 与其相邻的X 绝对值之和，步长最短的一对值，
     * 以总金额的 税额精确与四舍五入值 误差值为标杆，通过上述值的的误差进行分摊，保证最后的数据组合的误差值最小且再0.005范围内
     * 以上规则 不考虑 扣除，以及 极限的 数量不够用的情况
     * @return
     */
    private List<ItemAmountInfo> optimumItemAmount(ItemAmountInfo splitItemAmountInfo,ItemAmountInfo itemAmountInfo,SplitRule rule) {
        boolean hasQuantity = itemAmountInfo.getQuantity().compareTo(BigDecimal.ZERO) != 0;
        BigDecimal totalAmount = itemAmountInfo.getAmountWithoutTax();
        BigDecimal taxAmount = totalAmount.multiply(itemAmountInfo.getTaxRate());
        BigDecimal totalTaxAmountDiff = taxAmount.subtract(taxAmount.setScale(2, HALF_UP));
        BigDecimal discountAmount = splitItemAmountInfo.getDiscountWithoutTax();
        BigDecimal discountTaxAmount = discountAmount.multiply(itemAmountInfo.getTaxRate());
        BigDecimal totalDisscountTaxAmountDiff = discountTaxAmount.subtract(discountTaxAmount.setScale(2, HALF_UP));
        BigDecimal limitAmount = rule.getInvoiceLimit();
        List<ItemAmountInfo> res = new ArrayList<>();
        Map<Boolean, ItemValueDistribution> taxAmountWithOutTaxPair = this.seekOptimumAmounts(itemAmountInfo,limitAmount,splitItemAmountInfo.getUnitPrice(),splitItemAmountInfo.getQuantity(), 20 ,rule.getAmountSplitRule(),splitItemAmountInfo.getTaxRate() ,splitItemAmountInfo );
        if (Objects.isNull(taxAmountWithOutTaxPair)) {
            throw new IllegalArgumentException("未知的拆票规则["+rule.getAmountSplitRule()+"]");
        }

        /**
         * 根据不含税金额 分摊结果  计算折扣金额，
         */
        DiscountRatio discountRatio =  assessDiscount(discountAmount,taxAmountWithOutTaxPair, rule.getInvoiceLimit(),totalAmount,itemAmountInfo.getDiscountWithoutTax());
        Map<Boolean, ItemValueDistribution> discountTaxAmountWithOutTaxPair = this.seekOptimumDiscountAmounts(discountRatio.amount, splitItemAmountInfo.getTaxRate(), 10, BigDecimal.ZERO,discountRatio.flag?BigDecimal.valueOf(-0.01):BigDecimal.valueOf(0.01));

        Map<String, ItemAmountInfo> itemAmountInfoMap = initialAmountGroup(splitItemAmountInfo,   taxAmountWithOutTaxPair, discountTaxAmountWithOutTaxPair);
        //计算 折扣金额 与 不含税金额的比例
        Boolean negation = totalTaxAmountDiff.compareTo(BigDecimal.ZERO) < 0;
        ItemValueDistribution tmpDistribution = taxAmountWithOutTaxPair.get(negation);
        Boolean discountNegation = totalDisscountTaxAmountDiff.compareTo(BigDecimal.ZERO) < 0;
        ItemValueDistribution tmpDiscountDistribution = discountTaxAmountWithOutTaxPair.get(discountNegation);
        if(tmpDistribution.preLessLimit && !negation){
            negation = tmpDistribution.preLessLimit;
         }
        while (itemAmountInfo.getAmountWithoutTax()  .subtract(tmpDiscountDistribution.getValue()) .compareTo(tmpDistribution.getValue()) > 0) {
            tmpDistribution = taxAmountWithOutTaxPair.get(negation);
            totalTaxAmountDiff = totalTaxAmountDiff.subtract(tmpDistribution.getDiff());

            tmpDiscountDistribution = discountTaxAmountWithOutTaxPair.get(discountNegation);
            totalDisscountTaxAmountDiff = totalDisscountTaxAmountDiff.subtract(tmpDiscountDistribution.getDiff());

            ItemAmountInfo tmpItemAmountInfo = itemAmountInfoMap.get(calculateKey(negation, discountNegation));
            deductSplitItemAmount(rule, itemAmountInfo, tmpItemAmountInfo);
            negation = totalTaxAmountDiff.compareTo(BigDecimal.ZERO) < 0;

            discountNegation = totalDisscountTaxAmountDiff.compareTo(BigDecimal.ZERO) < 0;
            res.add(tmpItemAmountInfo);
        }
        processLastItemUnitPriceAndQuantity(itemAmountInfo, hasQuantity, rule);
        if (itemAmountInfo.getAmountWithoutTax().add(itemAmountInfo.getOutterDiscountWithoutTax()).compareTo(BigDecimal.ZERO) > 0) {
            res.add(itemAmountInfo);
        }

        return res;
    }

    /**
     * 处理最后一条
     *  @param itemAmountInfo
     * @param hasQuantity
     * @param rule
     */
    public void processLastItemUnitPriceAndQuantity(ItemAmountInfo itemAmountInfo, boolean hasQuantity, SplitRule rule) {
        if (hasQuantity) {
            BigDecimal quantity = itemAmountInfo.getQuantity();
            if (quantity.compareTo(BigDecimal.ZERO) == 0) {
                quantity = MIN_QUANTITY;
            }
            if (rule.getAmountSplitRule().equals("3")) {
                itemAmountInfo.setQuantity(itemAmountInfo.getAmountWithoutTax()
                        .divide(itemAmountInfo.getUnitPrice(), 6, HALF_UP));
            }
            if (rule.getAmountSplitRule().equals("1")) {
                itemAmountInfo.setUnitPrice(itemAmountInfo.getAmountWithoutTax()
                        .divide(quantity, rule.getUnitPriceScale(), HALF_UP));
            }
            BigDecimal res = itemAmountInfo.getQuantity().multiply(itemAmountInfo.getUnitPrice()).setScale(2, HALF_UP);
            if (res.compareTo(itemAmountInfo.getAmountWithoutTax()) != 0) {
                super.processLastItemUnitPriceAndQuantity(itemAmountInfo, hasQuantity, rule);
            }
        }
    }

    /**
     * 预估折扣值,表示折扣最小的值,对于这个值的调整，不断加0.01
     * 1.如果不含税金额>限额，去最小 折扣额
     * 2.如果不含税金额<限额
     *
     * @return
     */
    private DiscountRatio assessDiscount(BigDecimal discountAmount, Map<Boolean, ItemValueDistribution> taxAmountWithOutTaxPair, BigDecimal limiteAmount,BigDecimal totalAmountWithOutTax,BigDecimal totalDiscountWithOutTax) {
        if (discountAmount.compareTo(BigDecimal.ZERO) == 0 || totalDiscountWithOutTax.compareTo(BigDecimal.ZERO) == 0) {
            return new DiscountRatio(BigDecimal.ZERO,false);
        }
        Boolean flag = Boolean.FALSE;
        if (taxAmountWithOutTaxPair.get(Boolean.TRUE).getValue().compareTo(taxAmountWithOutTaxPair.get(Boolean.FALSE).getValue()) > 0) {
             flag = Boolean.TRUE;
        }
        BigDecimal amountWithOutTax = taxAmountWithOutTaxPair.get(flag).getValue();

        if (amountWithOutTax.compareTo(limiteAmount) > 0) {
            // 不含额金额超过限额， 取最大的 折扣金额 ，折扣金额 调整 只能 累加调整，保证不超过限额
            return new DiscountRatio(amountWithOutTax.subtract(limiteAmount),Boolean.TRUE);
        }else{
            // 取最小的折扣金额,折扣金额 按照累减调整
            amountWithOutTax = taxAmountWithOutTaxPair.get(!flag).getValue();
            BigDecimal ratio = amountWithOutTax.divide(totalAmountWithOutTax, 10, HALF_UP);
            return new DiscountRatio(ratio.multiply(totalDiscountWithOutTax).setScale(2, HALF_UP) ,Boolean.FALSE);
        }
   }

    /**
     * 初始化 不含税金额，折扣金额的组合
     * @param itemAmountInfo
     * @param rule
     * @param taxAmountWithOutTaxPair
     * @param discountTaxAmountWithOutTaxPair
     * @return
     */
    private Map<String, ItemAmountInfo> initialAmountGroup(ItemAmountInfo itemAmountInfo,   Map<Boolean, ItemValueDistribution> taxAmountWithOutTaxPair, Map<Boolean, ItemValueDistribution> discountTaxAmountWithOutTaxPair) {
        Map<String, ItemAmountInfo> itemAmountInfoMap = new HashMap<>();

        ItemAmountInfo tempAmountInfoTT = reCalculate(taxAmountWithOutTaxPair.get(Boolean.TRUE), itemAmountInfo);
        reCalculateDiscount(discountTaxAmountWithOutTaxPair.get(Boolean.TRUE), tempAmountInfoTT);
        itemAmountInfoMap.put(calculateKey(true, true), tempAmountInfoTT);

        ItemAmountInfo tempAmountInfoFF = reCalculate(taxAmountWithOutTaxPair.get(Boolean.FALSE), itemAmountInfo);
        reCalculateDiscount(discountTaxAmountWithOutTaxPair.get(Boolean.FALSE), tempAmountInfoFF);
         itemAmountInfoMap.put(calculateKey(false, false), tempAmountInfoFF);

        ItemAmountInfo tempAmountInfoFT = reCalculate(taxAmountWithOutTaxPair.get(Boolean.FALSE), itemAmountInfo);
        reCalculateDiscount(discountTaxAmountWithOutTaxPair.get(Boolean.TRUE), tempAmountInfoFT);
        itemAmountInfoMap.put(calculateKey(false, true), tempAmountInfoFT);

        ItemAmountInfo tempAmountInfoTF =reCalculate(taxAmountWithOutTaxPair.get(Boolean.TRUE), itemAmountInfo);
        reCalculateDiscount(discountTaxAmountWithOutTaxPair.get(Boolean.FALSE), tempAmountInfoTF);
        itemAmountInfoMap.put(calculateKey(true, false), tempAmountInfoTF);
        return itemAmountInfoMap;
    }

    /**
     * 计算KEY
     * @param v1
     * @param v2
     * @return
     */
    private String calculateKey(Boolean v1, Boolean v2) {
        return (v1 ? "T" : "F") + (v2 ? "T" : "F");
    }

    /**
     * 计算自由的不含税金额组合
     * @param itemAmountInfo
     * @param ruleLimit
     * @param unitPrice
     * @param quality
     * @param num
     * @param amountSplitRule
     * @param taxRate
     * @param splitItemAmountInfo
     * @return
     */
    private Map<Boolean, ItemValueDistribution> seekOptimumAmounts(ItemAmountInfo itemAmountInfo,BigDecimal ruleLimit, BigDecimal unitPrice, BigDecimal quality, Integer num, String amountSplitRule,BigDecimal taxRate,ItemAmountInfo splitItemAmountInfo) {
        /**
         * 无数量单价的调整方式
         */
        if(itemAmountInfo.getQuantity().compareTo(BigDecimal.ZERO) == 0){
          return seekOptimumDiscountAmounts(splitItemAmountInfo.getAmountWithoutTax(), taxRate, 20, splitItemAmountInfo.getDeductions(), BigDecimal.valueOf(0.01));
        }
        if (amountSplitRule.equals("1")) {
            BigDecimal step = BigDecimal.valueOf(0.01).divide(quality, 6, HALF_UP);
            step = step.compareTo(BigDecimal.ZERO) == 0 ? BigDecimal.valueOf(0.000001) : step;
            //  调整 amountWithOutTax 0.2 范围内取值 计算 税额差值步长最小的两个值
            return rejustAmountByQuanlity(unitPrice, quality, taxRate, step, splitItemAmountInfo.getDeductions(),amountSplitRule,itemAmountInfo,ruleLimit);
        } else if (amountSplitRule.equals("2")) {
            //TODO 暂时不处理  对于 数量调整，小于等于当前数量 小于等于1的范围值，计算后的不含税单价 得出的税额误差步长 最小的两个值
            throw new BWSplitRuleSpliteAmountException("百旺,UKEY模式下，不支持数量取整规则，建议使用其他规则:保单价拆数量不取整或保数量拆单价");
        } else if (amountSplitRule.equals("3"))  {
            // 对于 数量调整， 调整位数 0.01 / 单价 保留 6位小数 调整20次
            BigDecimal step = BigDecimal.valueOf(0.01).divide(unitPrice, 6, HALF_UP);
            step = step.compareTo(BigDecimal.ZERO) == 0 ? BigDecimal.valueOf(0.000001) : step;
            return rejustAmountByQuanlity(unitPrice, quality, taxRate, step, splitItemAmountInfo.getDeductions(),amountSplitRule,itemAmountInfo,ruleLimit);
        }
        //TODO 计算完成 新的 不含税金额后，计算 折扣金额数值
        return null;
    }



    /**
     *   如果是 按单价拆数量  ，调整数量最小位 20位, 取步长最小的两个值（一正一负）,
     *   按单价拆数量 之所以这么调，是因为，如果预期最优值是 999996.34  999996.33  单价 6508020.69 反算的数量为 0.1536559866099627 数量只能按照down的方式舍得6位以后的所有小数 = 0.153655
     *   0.153655 * 6508020.69 = 999,989.91912195  = 999,989.92,与预期值差别太大，而且 税额差值无法保证
     * @param unitPrice
     * @param quality
     * @param taxRate
     * @param step
     * @param deduction 扣除额
     */
    private   Map<Boolean, BWSplitBillItemWithOutTaxServiceImpl.ItemValueDistribution> rejustAmountByQuanlity(BigDecimal unitPrice, BigDecimal quality, BigDecimal taxRate, BigDecimal step, BigDecimal deduction, String type,ItemAmountInfo itemAmountInfo,BigDecimal ruleLimit) {
        Map<Boolean, BWSplitBillItemWithOutTaxServiceImpl.ItemValueDistribution> ite = new HashMap<>();
        int num = 20;
        if (type.equals("3")) {
            num = (quality.divide(step, 0, DOWN)).intValue();
        }else{
            num = (unitPrice.divide(step, 0, DOWN)).intValue();
        }
        num =  num > 20 ? 20 : num;
        BigDecimal resQuality = BigDecimal.ZERO;
        BigDecimal resUnitPrice = BigDecimal.ZERO;
        BigDecimal resLimitValue = BigDecimal.ZERO;
        BigDecimal resTaxValue = BigDecimal.ZERO;
        BigDecimal resTaxValueDiff = BigDecimal.ZERO;

        BigDecimal resPreQuality = BigDecimal.ZERO;
        BigDecimal resPreUnitPrice = BigDecimal.ZERO;
        BigDecimal resPreLimitValue = BigDecimal.ZERO;
        BigDecimal resPreTaxValue = BigDecimal.ZERO;
        BigDecimal resPreTaxValueDiff = BigDecimal.ZERO;

        BigDecimal min = BigDecimal.ONE;
        boolean brk = false;
        boolean contin = false;
        boolean preLessLimit = false;
        for (int i = 0; i <= num-2; i++) {
            BigDecimal tmpQuality = type.equals("3") ? quality.subtract(step.multiply(BigDecimal.valueOf(i))) : quality;
            BigDecimal tmpUnitPrice = type.equals("1") ? unitPrice.subtract(step.multiply(BigDecimal.valueOf(i))) : unitPrice;
            BigDecimal limitValue = tmpQuality.multiply(tmpUnitPrice).setScale(2, HALF_UP);

            BigDecimal preTmpQuality = type.equals("3")?tmpQuality.subtract(step):tmpQuality;
            BigDecimal preUnitPrice = type.equals("1") ? tmpUnitPrice.subtract(step) : tmpUnitPrice;
            BigDecimal preLimitValue = preTmpQuality.multiply(preUnitPrice).setScale(2, HALF_UP);
            /**
             * 如果推算最佳不含税金额组合过程种，发现第二个不含税金额，不超限额，则说明是拆出来的明细只有两条，进行相减即可
             * 只需要计算limitValue 与  preLimitValue 税额的最优值即可
             */
            preLessLimit = ruleLimit.compareTo(itemAmountInfo.getAmountWithoutTax().subtract(limitValue)) >= 0;
            preLimitValue = preLessLimit ? itemAmountInfo.getAmountWithoutTax().subtract(limitValue) : preLimitValue;
            BigDecimal preDeduction = preLessLimit ? itemAmountInfo.getDeductions().subtract(deduction) : deduction;
            /**
             * 如果当前 总金额 - limitValue
             */
            BigDecimal taxValue =  (limitValue.subtract(deduction)).multiply(taxRate);
            BigDecimal preTaxValue =(preLimitValue.subtract(preDeduction))  .multiply(taxRate);
            BigDecimal preDiff = preTaxValue.subtract(preTaxValue.setScale(2, HALF_UP));
            BigDecimal diff = taxValue.subtract(taxValue.setScale(2, HALF_UP));

            if (diff.compareTo(BigDecimal.ZERO) == 0  ) {
                 preLimitValue = limitValue;
                 preTmpQuality = tmpQuality;
                 preUnitPrice = tmpUnitPrice;
                 preTaxValue = taxValue;
                 preDiff = diff;
                 brk = true;
            }
            if (preDiff.compareTo(BigDecimal.ZERO) == 0  && !preLessLimit) {
                limitValue = preLimitValue;
                tmpQuality = preTmpQuality;
                tmpUnitPrice = preUnitPrice;
                taxValue = preTaxValue;
                brk = true;
            }
            if ((diff.add(preDiff).abs().compareTo(diff.abs().add(preDiff.abs())) < 0)) {
                if (min.compareTo(diff.abs().add(preDiff.abs()))> 0) {
                    min = diff.abs().add(preDiff.abs());
                    contin = true;
                }
            }
            if (contin || brk) {
                resQuality = tmpQuality;
                resUnitPrice = tmpUnitPrice;
                resLimitValue = limitValue;
                resTaxValue = taxValue.setScale(2, HALF_UP);;
                resTaxValueDiff = diff;
                resPreQuality = preTmpQuality;
                resPreUnitPrice = preUnitPrice;
                resPreLimitValue = preLimitValue;
                resPreTaxValue = preTaxValue.setScale(2, HALF_UP);
                resPreTaxValueDiff = preDiff;
                if (contin) {
                    contin = false;
                }
                if (brk) {
                    break;
                }
            }
        }
        BigDecimal firstDecimal =  resLimitValue;
        BigDecimal secondDecimal = resPreLimitValue;
        /**
         * 如果存在差值为0的情况，以不为零的数据为准 去正负标识，需要着重匹配数据测试
         */
        Boolean negation = preLessLimit?preLessLimit:resTaxValueDiff.compareTo(BigDecimal.ZERO) < 0;
        ite.put(negation, new BWSplitBillItemWithOutTaxServiceImpl.ItemValueDistribution(firstDecimal, resTaxValueDiff,resQuality ,resUnitPrice,resTaxValue,preLessLimit));
        ite.put(!negation, new BWSplitBillItemWithOutTaxServiceImpl.ItemValueDistribution(secondDecimal, resPreTaxValueDiff,resPreQuality,resPreUnitPrice,resPreTaxValue,preLessLimit));
        return ite;
    }

    /**
     * 根据计算的 数量 单价 不含税金额，反算，税额，总额，
     */
    private ItemAmountInfo reCalculate(ItemValueDistribution itemValueDistribution, ItemAmountInfo itemAmountInfo) {
        ItemAmountInfo newItemAmountInfo = JSON.parseObject(JSON.toJSONString(itemAmountInfo), ItemAmountInfo.class);
        newItemAmountInfo.setUnitPrice(itemValueDistribution.getUnitPrice());
        newItemAmountInfo.setQuantity(itemValueDistribution.getQuanlity());
        newItemAmountInfo.setAmountWithoutTax(itemValueDistribution.getValue());
        newItemAmountInfo.setTaxAmount(itemValueDistribution.getTaxValue());
        newItemAmountInfo.setAmountWithTax(newItemAmountInfo.getAmountWithoutTax().add(newItemAmountInfo.getTaxAmount()));
        newItemAmountInfo.setDeductions(itemAmountInfo.getDeductions());
        return newItemAmountInfo;
    }

    /**
     * 重新计算 折扣金额
     * @param itemValueDistribution
     * @param itemAmountInfo
     * @return
     */
    private ItemAmountInfo reCalculateDiscount(ItemValueDistribution itemValueDistribution, ItemAmountInfo itemAmountInfo) {
        itemAmountInfo.setDiscountWithoutTax(itemValueDistribution.getValue());
        itemAmountInfo.setDiscountTax(itemValueDistribution.getTaxValue());
        itemAmountInfo.setDiscountWithTax(itemValueDistribution.getValue().add(itemValueDistribution.getTaxValue()));
        return itemAmountInfo;
    }

    /**
     * 折扣分摊方法 也 适用 无数量单价场景
     * @param limitValue
     * @param taxRate
     * @param num
     * @param deduction
     * @return
     */
    private Map<Boolean, ItemValueDistribution> seekOptimumDiscountAmounts(BigDecimal limitValue, BigDecimal taxRate, Integer num ,BigDecimal deduction,  BigDecimal step ) {
        int flag = 0;
        BigDecimal min = new BigDecimal("1");
        List<BigDecimal> diffs = new ArrayList<>(2);
        diffs.add(BigDecimal.ZERO);
        diffs.add(BigDecimal.ZERO);
        List<BigDecimal> taxValues = new ArrayList<>(2);
        taxValues.add(BigDecimal.ZERO);
        taxValues.add(BigDecimal.ZERO);
        Map<Boolean, ItemValueDistribution> ite = new HashMap<>();
        if (limitValue.compareTo(BigDecimal.ZERO) == 0) {
            ite.put(Boolean.FALSE, new  ItemValueDistribution(BigDecimal.ZERO, BigDecimal.ZERO,BigDecimal.ZERO,BigDecimal.ZERO,BigDecimal.ZERO));
            ite.put(Boolean.TRUE,  new  ItemValueDistribution(BigDecimal.ZERO, BigDecimal.ZERO,BigDecimal.ZERO,BigDecimal.ZERO,BigDecimal.ZERO));
            return ite;
        }
        num = limitValue.divide(step, 0, DOWN).intValue();
        num = step.compareTo(BigDecimal.ZERO) > 0 ? (num > 10 ? 10 : num) : 10;
        for (int i = num-1; i>=1 ; i--) {
            BigDecimal taxValue = (limitValue.subtract(BigDecimal.valueOf(i).multiply(step)).subtract(deduction)).multiply(taxRate);
            BigDecimal preTaxValue = (limitValue.subtract(BigDecimal.valueOf(i-1).multiply(step)).subtract(deduction)).multiply(taxRate);
            BigDecimal preDiff = preTaxValue.subtract(preTaxValue.setScale(2, HALF_UP));
            BigDecimal diff = taxValue.subtract(taxValue.setScale(2, HALF_UP));
            BigDecimal diffStep = (diff.abs().add(preDiff.abs()));
            if (min.compareTo(diffStep) > 0 && (diff.add(preDiff).abs().compareTo(diff.abs().add(preDiff.abs())) < 0)) {
                diffs.set(0, diff);
                diffs.set(1, preDiff);
                min = diffStep;
                flag = i;
                taxValues.set(0, taxValue.setScale(2,HALF_UP));
                taxValues.set(1, preTaxValue.setScale(2,HALF_UP));
            }
        }
        BigDecimal firstDecimal = limitValue.subtract(BigDecimal.valueOf(flag).multiply(step));
        BigDecimal secondDecimal = limitValue.subtract(BigDecimal.valueOf(flag-1).multiply(step));
        /**
         * 如果存在差值为0的情况，以不为零的数据为准 去正负标识，需要着重匹配数据测试
         */
        Boolean negation = diffs.get(0).compareTo(BigDecimal.ZERO) < 0;
        ite.put(negation, new BWSplitBillItemWithOutTaxServiceImpl.ItemValueDistribution(firstDecimal, diffs.get(0), BigDecimal.ZERO, BigDecimal.ZERO, taxValues.get(0)));
        ite.put(!negation, new BWSplitBillItemWithOutTaxServiceImpl.ItemValueDistribution(secondDecimal, diffs.get(1), BigDecimal.ZERO, BigDecimal.ZERO, taxValues.get(1)));
        return ite;
    }

    /**
     * 明细数据分配信息，不同限额 的不同条数分配
     */

    static class ItemValueDistribution {
        /**
         * 不含税金额
         */
        private BigDecimal value;
        /**
         * 税额差异
         */
        private BigDecimal diff;
        private BigDecimal taxValue;
        private BigDecimal quanlity;
        private BigDecimal unitPrice;
        private Boolean preLessLimit;

        public ItemValueDistribution(BigDecimal value, BigDecimal diff ) {
            this.value = value;
            this.diff = diff;
        }

        public ItemValueDistribution(BigDecimal value, BigDecimal diff, BigDecimal quanlity, BigDecimal unitPrice, BigDecimal taxValue) {
            this.value = value;
            this.diff = diff;
            this.quanlity = quanlity;
            this.unitPrice = unitPrice;
            this.taxValue = taxValue;
        }
        public ItemValueDistribution(BigDecimal value, BigDecimal diff, BigDecimal quanlity, BigDecimal unitPrice, BigDecimal taxValue,Boolean preLessLimit) {
            this.value = value;
            this.diff = diff;
            this.quanlity = quanlity;
            this.unitPrice = unitPrice;
            this.taxValue = taxValue;
            this.preLessLimit = preLessLimit;
        }


        public BigDecimal getValue() {
            return value;
        }

        public void setValue(BigDecimal value) {
            this.value = value;
        }

        public BigDecimal getDiff() {
            return diff;
        }

        public void setDiff(BigDecimal diff) {
            this.diff = diff;
        }

        public BigDecimal getQuanlity() {
            return quanlity;
        }

        public void setQuanlity(BigDecimal quanlity) {
            this.quanlity = quanlity;
        }

        public BigDecimal getUnitPrice() {
            return unitPrice;
        }

        public void setUnitPrice(BigDecimal unitPrice) {
            this.unitPrice = unitPrice;
        }

        public BigDecimal getTaxValue() {
            return taxValue;
        }

        public void setTaxValue(BigDecimal taxValue) {
            this.taxValue = taxValue;
        }
    }

    class DiscountRatio{
        private BigDecimal amount;
        // 后续的 调整的方向  true :使用减操作  false  使用加操作
        private Boolean flag;

        private Integer num;

        public DiscountRatio(BigDecimal amount, Boolean flag) {
            this.amount = amount;
            this.flag = flag;
        }

        public BigDecimal getAmount() {
            return amount;
        }

        public void setAmount(BigDecimal amount) {
            this.amount = amount;
        }

        public Boolean getFlag() {
            return flag;
        }

        public void setFlag(Boolean flag) {
            this.flag = flag;
        }
    }


}
