/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.phoenix.split.checker;

import com.xforceplus.phoenix.split.domain.ItemAmountInfo;
import com.xforceplus.phoenix.split.model.BillItem;
import com.xforceplus.phoenix.split.model.SplitRule;
import com.xforceplus.phoenix.split.util.BigDecimalUtil;
import java.math.BigDecimal;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Component;

@Component
public class SplitLimitChecker {
    public boolean gtLimit(BillItem billItem, SplitRule rule) {
        return this.gtLimitAmount(billItem, rule) || this.gtLimitQuantity(billItem, rule);
    }

    private boolean gtLimitAmount(BillItem billItem, SplitRule rule) {
        BigDecimal amount = rule.isLimitIsAmountWithTax() ? billItem.getAmountWithTax().subtract(billItem.getInnerPrepayAmountWithTax()).subtract(billItem.getInnerDiscountWithTax()).subtract(billItem.getOutterDiscountWithTax()).subtract(billItem.getOutterPrepayAmountWithTax()) : billItem.getAmountWithoutTax().subtract(billItem.getInnerDiscountWithoutTax()).subtract(billItem.getInnerPrepayAmountWithoutTax()).subtract(billItem.getOutterDiscountWithoutTax()).subtract(billItem.getOutterPrepayAmountWithoutTax());
        return amount.compareTo(rule.getInvoiceLimit()) > 0;
    }

    private boolean gtLimitQuantity(BillItem billItem, SplitRule rule) {
        if (Objects.isNull(rule.getQuantityLimit()) || StringUtils.isBlank((CharSequence)rule.getQuantityLimitUnit())) {
            return false;
        }
        if (!StringUtils.equalsAny((CharSequence)billItem.getQuantityUnit(), (CharSequence[])new CharSequence[]{rule.getQuantityLimitUnit()})) {
            return false;
        }
        if (BigDecimalUtil.nullToZero(billItem.getQuantity()).compareTo(BigDecimal.ZERO) == 0) {
            return false;
        }
        return billItem.getQuantity().compareTo(rule.getQuantityLimit()) > 0;
    }

    public boolean gtLimit(ItemAmountInfo itemAmountInfo, SplitRule rule) {
        return this.gtLimitAmount(itemAmountInfo, rule) || this.gtLimitQuantity(itemAmountInfo, rule);
    }

    private boolean gtLimitAmount(ItemAmountInfo itemAmountInfo, SplitRule rule) {
        BigDecimal amount = rule.isLimitIsAmountWithTax() ? itemAmountInfo.getAmountWithTax().subtract(itemAmountInfo.getDiscountWithTax()) : itemAmountInfo.getAmountWithoutTax().subtract(itemAmountInfo.getDiscountWithoutTax());
        return amount.compareTo(rule.getInvoiceLimit()) > 0;
    }

    private boolean gtLimitQuantity(ItemAmountInfo itemAmountInfo, SplitRule rule) {
        return itemAmountInfo.getQuantity().compareTo(rule.getQuantityLimit()) > 0;
    }
}

