/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.phoenix.split.service;

import com.xforceplus.phoenix.split.checker.SplitLimitChecker;
import com.xforceplus.phoenix.split.constant.DataBasicRule;
import com.xforceplus.phoenix.split.constant.TaxInvoiceSourceEnum;
import com.xforceplus.phoenix.split.domain.ItemGroup;
import com.xforceplus.phoenix.split.exception.ItemUnitPriceException;
import com.xforceplus.phoenix.split.exception.SplitBizException;
import com.xforceplus.phoenix.split.model.BillItem;
import com.xforceplus.phoenix.split.model.PriceMethod;
import com.xforceplus.phoenix.split.model.SplitRule;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.List;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class BasicDataProcessService {
    private final SplitLimitChecker splitLimitChecker;
    private static final BigDecimal DEFAULT_ALLOWABLE_ERROR = BigDecimal.valueOf(0.01);

    public void adjustUnitPrice(BillItem billItem, SplitRule rule) {
        this.adjustBusinessUnitPrice(billItem, rule);
        this.adjustBasicUnitPrice(billItem, rule);
    }

    public void adjustBasicUnitPrice(BillItem billItem, SplitRule rule) {
        BigDecimal unitPrice = billItem.getUnitPrice();
        BigDecimal quantity = billItem.getQuantity();
        if (unitPrice == null) {
            return;
        }
        if (BigDecimal.ZERO.compareTo(unitPrice = unitPrice.stripTrailingZeros()) == 0 && BigDecimal.ZERO.compareTo(quantity) == 0) {
            return;
        }
        int decimalNumber = unitPrice.scale();
        int precision = unitPrice.precision();
        int integerNumber = precision - decimalNumber;
        String taxInvoiceSource = rule.getTaxInvoiceSource();
        int precisionRuleScale = TaxInvoiceSourceEnum.QD.getValue().equals(taxInvoiceSource) ? DataBasicRule.QD_UNIT_PRICE_PRECISION : DataBasicRule.SK_UNIT_PRICE_PRECISION;
        int decimalRuleScale = TaxInvoiceSourceEnum.QD.getValue().equals(taxInvoiceSource) ? DataBasicRule.QD_UNIT_PRICE_SCALE : DataBasicRule.SK_UNIT_PRICE_SCALE;
        int actualUnitPriceScale = Math.min(precisionRuleScale - integerNumber, decimalRuleScale);
        if (precision > precisionRuleScale || decimalNumber > decimalRuleScale) {
            BigDecimal newUnitPrice = this.calculationUnitPrice(billItem, actualUnitPriceScale, rule);
            BigDecimal newAmountWithoutTax = this.calculationAmountWithoutTax(newUnitPrice, quantity);
            BigDecimal newErrorAmount = this.calculationErrorAmount(newAmountWithoutTax, billItem);
            this.modifyUnitPriceOrProcessError(newErrorAmount, newUnitPrice, newAmountWithoutTax, billItem, rule, actualUnitPriceScale);
        }
    }

    public void adjustBusinessUnitPrice(BillItem billItem, SplitRule rule) {
        if (this.gtUnitPriceScale(billItem, rule.getUnitPriceScale()) && this.notNullQuantity(billItem) && !this.splitLimitChecker.gtLimit(billItem, rule)) {
            BigDecimal newUnitPrice = this.calculationUnitPrice(billItem, rule.getUnitPriceScale(), rule);
            BigDecimal newAmountWithoutTax = this.calculationAmountWithoutTax(newUnitPrice, billItem.getQuantity());
            BigDecimal newErrorAmount = this.calculationErrorAmount(newAmountWithoutTax, billItem);
            this.modifyUnitPriceOrProcessError(newErrorAmount, newUnitPrice, newAmountWithoutTax, billItem, rule, rule.getUnitPriceScale());
        }
    }

    public void adjustBasicQuantityPrecision(BillItem billItem, SplitRule rule) {
        BigDecimal quantity = billItem.getQuantity();
        if (quantity == null) {
            return;
        }
        quantity = quantity.stripTrailingZeros();
        BigDecimal unitPrice = billItem.getUnitPrice();
        int precisionRuleScale = DataBasicRule.QD_QUANTITY_PRECISION;
        int decimalRuleScale = DataBasicRule.QD_QUANTITY_SCALE;
        if (BigDecimal.ZERO.compareTo(unitPrice) == 0 && BigDecimal.ZERO.compareTo(quantity) == 0) {
            return;
        }
        int decimalNumber = quantity.scale();
        int precision = quantity.precision();
        int integerNumber = precision - decimalNumber;
        int actualQuantityScale = Math.min(precisionRuleScale - integerNumber, decimalRuleScale);
        if (precision > precisionRuleScale || decimalNumber > decimalRuleScale) {
            BigDecimal newQuantity = this.calculationQuantity(billItem, actualQuantityScale);
            BigDecimal newAmountWithoutTax = this.calculationAmountWithoutTax(unitPrice, newQuantity);
            BigDecimal newErrorAmount = this.calculationErrorAmount(newAmountWithoutTax, billItem);
            this.modifyQuantityOrProcessError(newErrorAmount, newQuantity, newAmountWithoutTax, billItem, rule);
        }
    }

    private BigDecimal calculationUnitPrice(BillItem billItem, Integer unitPriceScale, SplitRule rule) {
        boolean isRedItem;
        BigDecimal originUnitPrice = billItem.getUnitPrice();
        boolean bl = isRedItem = billItem.getAmountWithoutTax().compareTo(BigDecimal.ZERO) < 0 || billItem.isRedItem();
        if (new BigDecimal(originUnitPrice.intValue()).compareTo(originUnitPrice) == 0) {
            return originUnitPrice.setScale(unitPriceScale);
        }
        if (TaxInvoiceSourceEnum.QD.getValue().equals(rule.getTaxInvoiceSource()) && PriceMethod.WITH_TAX == rule.getPriceMethod() && !isRedItem) {
            BigDecimal amount = billItem.getAmountWithTax().subtract(billItem.getInnerDiscountWithTax()).subtract(billItem.getInnerPrepayAmountWithTax());
            BigDecimal taxRate = billItem.getTaxRate();
            BigDecimal divideTaxRate = taxRate.add(BigDecimal.ONE);
            return amount.divide(divideTaxRate, 15, RoundingMode.HALF_UP).divide(billItem.getQuantity(), (int)unitPriceScale, RoundingMode.HALF_UP);
        }
        BigDecimal amount = billItem.getAmountWithoutTax().subtract(billItem.getInnerDiscountWithoutTax()).subtract(billItem.getInnerPrepayAmountWithoutTax());
        return amount.divide(billItem.getQuantity(), (int)unitPriceScale, RoundingMode.HALF_UP);
    }

    private BigDecimal calculationQuantity(BillItem billItem, Integer quantityScale) {
        BigDecimal unitPrice = billItem.getUnitPrice();
        BigDecimal amount = billItem.getAmountWithoutTax().subtract(billItem.getInnerDiscountWithoutTax()).subtract(billItem.getInnerPrepayAmountWithoutTax());
        return amount.divide(unitPrice, (int)quantityScale, RoundingMode.HALF_UP);
    }

    private boolean gtUnitPriceScale(BillItem billItem, Integer unitPriceScale) {
        return billItem.getUnitPrice() != null && billItem.getUnitPrice().scale() > unitPriceScale;
    }

    private boolean notNullQuantity(BillItem billItem) {
        return billItem.getQuantity() != null && billItem.getQuantity().compareTo(BigDecimal.ZERO) != 0;
    }

    private BigDecimal calculationAmountWithoutTax(BigDecimal newUnitPrice, BigDecimal quantity) {
        return newUnitPrice.multiply(quantity).setScale(2, RoundingMode.HALF_UP);
    }

    private BigDecimal calculationErrorAmount(BigDecimal newAmountWithoutTax, BillItem billItem) {
        BigDecimal amount = billItem.getAmountWithoutTax().subtract(billItem.getInnerDiscountWithoutTax()).subtract(billItem.getInnerPrepayAmountWithoutTax());
        return newAmountWithoutTax.subtract(amount).abs();
    }

    private void modifyUnitPriceOrProcessError(BigDecimal errorAmount, BigDecimal newUnitPrice, BigDecimal newAmountWithoutTax, BillItem billItem, SplitRule rule, int scale) {
        if (errorAmount.compareTo(DEFAULT_ALLOWABLE_ERROR) >= 0) {
            if (rule.isIgnoreAllowableError()) {
                this.setNewAmount(newUnitPrice, newAmountWithoutTax, billItem);
            } else {
                if (TaxInvoiceSourceEnum.QD.getValue().equals(rule.getTaxInvoiceSource()) && PriceMethod.WITH_TAX == rule.getPriceMethod()) {
                    BigDecimal amount = billItem.getAmountWithoutTax().subtract(billItem.getInnerDiscountWithoutTax()).subtract(billItem.getInnerPrepayAmountWithoutTax());
                    billItem.setUnitPrice(amount.divide(billItem.getQuantity(), scale, RoundingMode.HALF_UP));
                }
                if (TaxInvoiceSourceEnum.QD.getValue().equals(rule.getTaxInvoiceSource()) && PriceMethod.WITH_TAX != rule.getPriceMethod()) {
                    throw new ItemUnitPriceException(String.format("\u660e\u7ec6id: [%s], \u660e\u7ec6\u5355\u53f7: [%s], \u660e\u7ec6\u540d\u79f0: [%s] \u6309\u6307\u5b9a\u5c0f\u6570\u4f4d\u622a\u53d6\u5355\u4ef7\u540e\u8d85\u8fc7\u5141\u8bb8\u7684\u5bb9\u5dee ", billItem.getSalesbillItemId(), billItem.getSalesbillItemNo(), billItem.getItemName()));
                }
            }
        } else {
            billItem.setUnitPrice(newUnitPrice);
        }
    }

    private void modifyQuantityOrProcessError(BigDecimal errorAmount, BigDecimal newQuantity, BigDecimal newAmountWithoutTax, BillItem billItem, SplitRule rule) {
        if (errorAmount.compareTo(DEFAULT_ALLOWABLE_ERROR) >= 0) {
            if (rule.isIgnoreAllowableError()) {
                billItem.setQuantity(newQuantity);
            } else if (TaxInvoiceSourceEnum.QD.getValue().equals(rule.getTaxInvoiceSource()) && PriceMethod.WITH_TAX != rule.getPriceMethod()) {
                throw new ItemUnitPriceException(String.format("\u660e\u7ec6id: [%s], \u660e\u7ec6\u5355\u53f7: [%s], \u660e\u7ec6\u540d\u79f0: [%s] \u6309\u6307\u5b9a\u5c0f\u6570\u4f4d\u622a\u53d6\u5355\u4ef7\u540e\u8d85\u8fc7\u5141\u8bb8\u7684\u5bb9\u5dee ", billItem.getSalesbillItemId(), billItem.getSalesbillItemNo(), billItem.getItemName()));
            }
        } else {
            billItem.setQuantity(newQuantity);
        }
    }

    private void setNewAmount(BigDecimal newUnitPrice, BigDecimal newAmountWithoutTax, BillItem billItem) {
        billItem.setUnitPrice(newUnitPrice);
        billItem.setAmountWithoutTax(newAmountWithoutTax.add(billItem.getInnerPrepayAmountWithoutTax()).add(billItem.getInnerDiscountWithoutTax()));
        billItem.setTaxAmount(billItem.getAmountWithoutTax().multiply(billItem.getTaxRate()).setScale(2, RoundingMode.HALF_UP));
        billItem.setAmountWithTax(billItem.getAmountWithoutTax().add(billItem.getTaxAmount()));
    }

    public List<ItemGroup> adjustInvoiceItemOrder(List<ItemGroup> itemGroups, List<ItemGroup> fullDiscountItemGroups) {
        itemGroups.removeAll(fullDiscountItemGroups);
        if (CollectionUtils.isEmpty(itemGroups)) {
            throw new SplitBizException("\u53d1\u7968\u91d1\u989d\u4e3a\u96f6,\u8bf7\u68c0\u67e5\u62c6\u7968\u6570\u636e");
        }
        for (ItemGroup fullDiscountItemGroup : fullDiscountItemGroups) {
            List<BillItem> fullDiscountBillItems = fullDiscountItemGroup.getBillItems();
            for (ItemGroup normalItemGroup : itemGroups) {
                List<BillItem> normalBillItems = normalItemGroup.getBillItems();
                int containFullDiscountCapacity = normalItemGroup.getContainFullDiscountCapacity();
                if (containFullDiscountCapacity <= 0) continue;
                BillItem fullDiscountBillItem = fullDiscountBillItems.get(fullDiscountBillItems.size() - 1);
                BillItem normalBillItem = normalBillItems.get(fullDiscountBillItems.size() - 1);
                fullDiscountBillItems.remove(fullDiscountBillItem);
                normalBillItems.remove(normalBillItem);
                fullDiscountBillItems.add(normalBillItem);
                normalBillItems.add(fullDiscountBillItem);
                normalItemGroup.setContainFullDiscountCapacity(--containFullDiscountCapacity);
                fullDiscountItemGroup.setDisplaced(true);
                break;
            }
            if (fullDiscountItemGroup.isDisplaced()) continue;
            throw new SplitBizException("\u53d1\u7968\u91d1\u989d\u4e3a\u96f6,\u8bf7\u68c0\u67e5\u62c6\u7968\u6570\u636e");
        }
        itemGroups.addAll(fullDiscountItemGroups);
        return itemGroups;
    }

    public BasicDataProcessService(SplitLimitChecker splitLimitChecker) {
        this.splitLimitChecker = splitLimitChecker;
    }
}

