/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.phoenix.split.service;

import com.xforceplus.phoenix.split.constant.TaxDeviceType;
import com.xforceplus.phoenix.split.model.BillItem;
import com.xforceplus.phoenix.split.model.SplitRule;
import com.xforceplus.phoenix.split.service.SplitBillItemAmountService;
import com.xforceplus.phoenix.split.service.impl.BWSplitBillItemByAmountWithTaxServiceImpl;
import com.xforceplus.phoenix.split.service.impl.SplitBillItemAmountByQuantityAndAmountLimitServiceImpl;
import com.xforceplus.phoenix.split.util.BigDecimalUtil;
import java.math.BigDecimal;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;

@Service
public class SplitBillItemAmountServiceFactory {
    @Autowired
    @Qualifier(value="defaultSplitBillItemAmountServiceImpl")
    private SplitBillItemAmountService defaultSplitBillItemAmountService;
    @Autowired
    @Qualifier(value="splitBillItemByAmountWithTaxServiceImpl")
    private SplitBillItemAmountService splitBillItemByAmountWithTaxServiceImpl;
    @Autowired
    @Qualifier(value="BWSplitBillItemByAmountWithTaxServiceImpl")
    private BWSplitBillItemByAmountWithTaxServiceImpl bWSplitBillItemByAmountWithTaxServiceImpl;
    @Autowired
    private SplitBillItemAmountByQuantityAndAmountLimitServiceImpl splitBillItemAmountByQuantityAndAmountLimitServiceImpl;

    public SplitBillItemAmountService getByRule(BillItem billItem, SplitRule rule, TaxDeviceType taxDeviceType) {
        if (BigDecimalUtil.nullToZero(billItem.getQuantity()).compareTo(BigDecimal.ZERO) != 0 && StringUtils.isNotBlank((CharSequence)rule.getQuantityLimitUnit()) && StringUtils.equals((CharSequence)rule.getQuantityLimitUnit(), (CharSequence)billItem.getQuantityUnit())) {
            return this.splitBillItemAmountByQuantityAndAmountLimitServiceImpl;
        }
        if (rule.isLimitIsAmountWithTax()) {
            return this.splitBillItemByAmountWithTaxServiceImpl;
        }
        return taxDeviceType == TaxDeviceType.BW_SERVER || taxDeviceType == TaxDeviceType.BW_SINGL ? this.bWSplitBillItemByAmountWithTaxServiceImpl : this.defaultSplitBillItemAmountService;
    }
}

