/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.phoenix.split.service.dataflow;

import com.google.common.collect.ListMultimap;
import com.google.common.collect.MultimapBuilder;
import com.xforceplus.phoenix.split.constant.TaxDeviceType;
import com.xforceplus.phoenix.split.domain.ItemGroup;
import com.xforceplus.phoenix.split.domain.RuleInfo;
import com.xforceplus.phoenix.split.model.BillInfo;
import com.xforceplus.phoenix.split.model.BillItem;
import com.xforceplus.phoenix.split.model.SplitRule;
import com.xforceplus.phoenix.split.service.dataflow.DataProcessPlugin;
import java.util.LinkedList;
import java.util.List;

public abstract class AbstractBillItemGroupPlugin
implements DataProcessPlugin {
    public List<ItemGroup> groupBillItemByRule(List<ItemGroup> itemGroups, SplitRule rule) {
        if (this.support(rule, itemGroups)) {
            return this.groupBillItem(itemGroups, rule);
        }
        return itemGroups;
    }

    public List<ItemGroup> groupBillItem(List<ItemGroup> itemGroups, SplitRule rule) {
        LinkedList<ItemGroup> result = new LinkedList<ItemGroup>();
        for (ItemGroup itemGroup : itemGroups) {
            List<BillItem> billItems = itemGroup.getBillItems();
            ListMultimap group = MultimapBuilder.linkedHashKeys().linkedListValues().build();
            billItems.forEach(billItem -> {
                String key = this.generateKey((BillItem)billItem, rule);
                group.put((Object)key, billItem);
            });
            group.keySet().forEach(key -> {
                ItemGroup newItemGroup = new ItemGroup();
                newItemGroup.setBillItems(group.get(key));
                result.add(newItemGroup);
            });
        }
        return result;
    }

    protected abstract String generateKey(BillItem var1, SplitRule var2);

    protected abstract boolean support(SplitRule var1, List<ItemGroup> var2);

    @Override
    public List<ItemGroup> processData(List<ItemGroup> itemGroups, BillInfo billInfo, RuleInfo rule) {
        return this.groupBillItemByRule(itemGroups, rule.getSplitRule());
    }

    @Override
    public List<ItemGroup> processData(List<ItemGroup> itemGroups, BillInfo billInfo, RuleInfo ruleInfo, TaxDeviceType taxDeviceType) {
        return this.processData(itemGroups, billInfo, ruleInfo);
    }
}

