/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.phoenix.split.service.dataflow.impl;

import com.google.common.base.Stopwatch;
import com.google.common.collect.Lists;
import com.xforceplus.phoenix.split.constant.TaxDeviceType;
import com.xforceplus.phoenix.split.domain.ItemGroup;
import com.xforceplus.phoenix.split.domain.RuleInfo;
import com.xforceplus.phoenix.split.exception.SplitBizException;
import com.xforceplus.phoenix.split.model.BillInfo;
import com.xforceplus.phoenix.split.model.BillItem;
import com.xforceplus.phoenix.split.model.PriceMethod;
import com.xforceplus.phoenix.split.service.BasicDataProcessService;
import com.xforceplus.phoenix.split.service.dataflow.DataProcessPlugin;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class BasicPlugin
implements DataProcessPlugin {
    private static final Logger log = LoggerFactory.getLogger(BasicPlugin.class);
    @Autowired
    private BasicDataProcessService basicDataProcessService;

    @Override
    public List<ItemGroup> processData(List<ItemGroup> itemGroups, BillInfo billInfo, RuleInfo rule) {
        BigDecimal discountLimit = rule.getSplitRule().getDiscountLimit();
        ArrayList fullDiscountItemGroups = Lists.newArrayListWithCapacity((int)itemGroups.size());
        for (ItemGroup itemGroup : itemGroups) {
            List<BillItem> billItems = itemGroup.getBillItems();
            billItems.parallelStream().forEach(e -> this.basicDataProcessService.adjustBasicUnitPrice((BillItem)e, rule.getSplitRule()));
            billItems.parallelStream().forEach(e -> this.basicDataProcessService.adjustBasicQuantityPrecision((BillItem)e, rule.getSplitRule()));
            BigDecimal invoiceTotalAmount = BigDecimal.ZERO;
            BigDecimal invoiceDiscountAmount = BigDecimal.ZERO;
            for (BillItem item : itemGroup.getBillItems()) {
                if (rule.getSplitRule().getPriceMethod() == PriceMethod.WITHOUT_TAX) {
                    invoiceTotalAmount = invoiceTotalAmount.add(item.getAmountWithoutTax());
                    invoiceDiscountAmount = invoiceDiscountAmount.add(item.getDiscountWithoutTax());
                    continue;
                }
                invoiceTotalAmount = invoiceTotalAmount.add(item.getAmountWithTax());
                invoiceDiscountAmount = invoiceDiscountAmount.add(item.getDiscountWithTax());
            }
            if (invoiceTotalAmount.compareTo(invoiceDiscountAmount) == 0) {
                fullDiscountItemGroups.add(itemGroup);
            }
            BigDecimal invoiceDiscountRate = invoiceDiscountAmount.divide(invoiceTotalAmount, 2, RoundingMode.HALF_UP);
            if (discountLimit != null && invoiceDiscountRate.compareTo(discountLimit) > 0 && CollectionUtils.isEmpty((Collection)fullDiscountItemGroups)) {
                throw new SplitBizException(String.format("\u8d85\u8fc7%s\u6298\u6263\u6bd4\u4f8b\u9650\u5236!", discountLimit));
            }
            int eachInvoiceFullDiscountCount = (int)billItems.stream().filter(e -> e.getAmountWithoutTax().compareTo(e.getOutterDiscountWithoutTax()) == 0).count();
            itemGroup.setContainFullDiscountCapacity(billItems.size() - eachInvoiceFullDiscountCount - 1);
        }
        if (!CollectionUtils.isEmpty((Collection)fullDiscountItemGroups)) {
            Stopwatch stopwatch = Stopwatch.createStarted();
            itemGroups = this.basicDataProcessService.adjustInvoiceItemOrder(itemGroups, fullDiscountItemGroups);
            log.info("BasicPlugin.processData adjustInvoiceItemOrder elapsed time = {} ms, fullDiscountItemGroups size:{}", (Object)stopwatch.elapsed().toMillis(), (Object)fullDiscountItemGroups.size());
        }
        return itemGroups;
    }

    @Override
    public List<ItemGroup> processData(List<ItemGroup> itemGroups, BillInfo billInfo, RuleInfo ruleInfo, TaxDeviceType taxDeviceType) {
        return this.processData(itemGroups, billInfo, ruleInfo);
    }
}

