/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.phoenix.split.service.dataflow.impl;

import com.xforceplus.phoenix.split.constant.GroupByKeyPatternEnum;
import com.xforceplus.phoenix.split.domain.ItemGroup;
import com.xforceplus.phoenix.split.model.BillItem;
import com.xforceplus.phoenix.split.model.SplitRule;
import com.xforceplus.phoenix.split.service.dataflow.AbstractBillItemGroupPlugin;
import com.xforceplus.phoenix.split.util.BigDecimalUtil;
import java.math.BigDecimal;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;

@Service
public class GroupItemByUnitPlugin
extends AbstractBillItemGroupPlugin {
    @Override
    protected String generateKey(BillItem billItem, SplitRule rule) {
        String quantityLimitUnit = rule.getQuantityLimitUnit();
        return StringUtils.equals((CharSequence)quantityLimitUnit, (CharSequence)billItem.getQuantityUnit()) ? String.format(GroupByKeyPatternEnum.UNIT_HIT.getValue(), quantityLimitUnit) : GroupByKeyPatternEnum.UNIT_MISS.getValue();
    }

    @Override
    protected boolean support(SplitRule rule, List<ItemGroup> itemGroups) {
        String quantityLimitUnit = rule.getQuantityLimitUnit();
        if (StringUtils.isBlank((CharSequence)quantityLimitUnit)) {
            return false;
        }
        return itemGroups.stream().anyMatch(e -> CollectionUtils.isNotEmpty(e.getBillItems()) && e.getBillItems().stream().anyMatch(billItem -> StringUtils.equals((CharSequence)billItem.getQuantityUnit(), (CharSequence)quantityLimitUnit) && BigDecimalUtil.nullToZero(billItem.getQuantity()).compareTo(BigDecimal.ZERO) != 0));
    }
}

