/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.phoenix.split.service.dataflow.impl;

import com.alibaba.fastjson.JSON;
import com.google.common.base.Stopwatch;
import com.xforceplus.phoenix.split.checker.SplitLimitChecker;
import com.xforceplus.phoenix.split.constant.InvoiceItemOrder;
import com.xforceplus.phoenix.split.constant.InvoiceType;
import com.xforceplus.phoenix.split.constant.TaxDeviceType;
import com.xforceplus.phoenix.split.constant.TaxInvoiceSourceEnum;
import com.xforceplus.phoenix.split.domain.ItemAmountInfo;
import com.xforceplus.phoenix.split.domain.ItemGroup;
import com.xforceplus.phoenix.split.domain.RuleInfo;
import com.xforceplus.phoenix.split.exception.SplitRuleParamException;
import com.xforceplus.phoenix.split.model.BillInfo;
import com.xforceplus.phoenix.split.model.BillItem;
import com.xforceplus.phoenix.split.model.ItemTypeCodeEnum;
import com.xforceplus.phoenix.split.model.SplitRule;
import com.xforceplus.phoenix.split.service.SplitBillItemAmountServiceFactory;
import com.xforceplus.phoenix.split.service.dataflow.DataProcessPlugin;
import com.xforceplus.phoenix.split.util.ThreadLocalFactory;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service
public class SplitBillItemPlugin
implements DataProcessPlugin {
    protected final Logger logger = LoggerFactory.getLogger(SplitBillItemPlugin.class);
    public static final String ORIGIN_INVOICE_CODE = "originInvoiceCode";
    public static final String ORIGIN_INVOICE_NO = "originInvoiceNo";
    public static final String RED_NOTIFICATION_NO = "redNotificationNo";
    @Autowired
    private SplitBillItemAmountServiceFactory splitBillItemAmountServiceFactory;
    @Autowired
    private SplitLimitChecker splitLimitChecker;

    @Override
    public List<ItemGroup> processData(List<ItemGroup> itemGroups, BillInfo billInfo, RuleInfo ruleInfo) {
        return this.processData(itemGroups, billInfo, ruleInfo, null);
    }

    @Override
    public List<ItemGroup> processData(List<ItemGroup> itemGroups, BillInfo billInfo, RuleInfo ruleInfo, TaxDeviceType taxDeviceType) {
        if (InvoiceItemOrder.ITEM_NO_MINIMUM_INVOICES.value().equals(ruleInfo.getSplitRule().getItemSort())) {
            return itemGroups;
        }
        Stopwatch stopwatch = Stopwatch.createStarted();
        String invoiceType = billInfo.getInvoiceType();
        for (ItemGroup itemGroup : itemGroups) {
            LinkedList<BillItem> billItemList = new LinkedList<BillItem>();
            for (BillItem billItem : itemGroup.getBillItems()) {
                SplitRule rule = ruleInfo.getSplitRule();
                this.checkPriceAndQuantity(billItem);
                if (this.split(ruleInfo.getExtRule(), billItem, rule, invoiceType)) {
                    billItemList.addAll(this.splitBillItemByLimitAmount(billItem, rule, taxDeviceType));
                    continue;
                }
                billItemList.add(billItem);
            }
            itemGroup.setBillItems(billItemList);
        }
        this.logger.info("process bill items elapsed time = {} ms", (Object)stopwatch.elapsed().toMillis());
        return itemGroups;
    }

    protected void checkPriceAndQuantity(BillItem billItem) {
        BigDecimal price = billItem.getUnitPrice();
        BigDecimal quantity = billItem.getQuantity();
        if (price.compareTo(BigDecimal.ZERO) != 0 && quantity.compareTo(BigDecimal.ZERO) == 0 || price.compareTo(BigDecimal.ZERO) == 0 && quantity.compareTo(BigDecimal.ZERO) != 0) {
            throw new SplitRuleParamException(String.format("salesBillItemId = [%s] \u5355\u4ef7\u8ddf\u6570\u91cf\u5fc5\u987b\u540c\u65f6\u4e3a\u96f6\u6216\u8005\u540c\u65f6\u4e0d\u4e3a\u96f6!", billItem.getSalesbillItemId()));
        }
    }

    protected boolean split(Map<String, Object> extRule, BillItem billItem, SplitRule rule, String invoiceType) {
        if (this.gtLimitAmount(billItem, rule, invoiceType)) {
            return !billItem.isRedItem() || this.splitRed(extRule, billItem);
        }
        return false;
    }

    private boolean splitRed(Map<String, Object> extRule, BillItem billItem) {
        return billItem.isRedItem() && StringUtils.isEmpty((Object)extRule.get(ORIGIN_INVOICE_CODE)) && StringUtils.isEmpty((Object)extRule.get(ORIGIN_INVOICE_NO)) && StringUtils.isEmpty((Object)extRule.get(RED_NOTIFICATION_NO));
    }

    private List<BillItem> splitBillItemByLimitAmount(BillItem billItem, SplitRule rule, TaxDeviceType taxDeviceType) {
        ThreadLocalFactory.initThreadLocal(billItem);
        ItemAmountInfo itemAmountInfo = this.copyBillItemAmountInfo(billItem, rule);
        List<ItemAmountInfo> itemAmountInfoList = this.splitBillItemAmountServiceFactory.getByRule(billItem, rule, taxDeviceType).splitAmount(itemAmountInfo, rule);
        ThreadLocalFactory.clearContext();
        this.logger.debug("split id = {} itemAmount, result = {}", (Object)billItem.getSalesbillItemId(), itemAmountInfoList);
        return this.reCreateBillItem(itemAmountInfoList, billItem);
    }

    protected List<BillItem> reCreateBillItem(List<ItemAmountInfo> itemAmountInfoList, BillItem billItem) {
        ArrayList<BillItem> result = new ArrayList<BillItem>(itemAmountInfoList.size());
        for (ItemAmountInfo itemAmountInfo : itemAmountInfoList) {
            BillItem newBillItem = this.createNewBillItem(itemAmountInfo, billItem);
            result.add(newBillItem);
        }
        return result;
    }

    private BillItem createNewBillItem(ItemAmountInfo itemAmountInfo, BillItem billItem) {
        BillItem result = (BillItem)JSON.parseObject((String)JSON.toJSONString((Object)billItem), BillItem.class);
        result.setOriginalAmountWithoutTax(billItem.getAmountWithoutTax());
        result.setAmountWithoutTax(itemAmountInfo.getAmountWithoutTax());
        result.setAmountWithTax(itemAmountInfo.getAmountWithTax());
        result.setTaxAmount(itemAmountInfo.getTaxAmount());
        result.setDeductions(itemAmountInfo.getDeductions());
        result.setDiscountTax(itemAmountInfo.getDiscountTax());
        result.setDiscountWithoutTax(itemAmountInfo.getDiscountWithoutTax());
        result.setDiscountWithTax(itemAmountInfo.getDiscountWithTax());
        result.setUnitPrice(itemAmountInfo.getUnitPrice());
        result.setQuantity(itemAmountInfo.getQuantity());
        result.setSplitItem(true);
        return result;
    }

    protected ItemAmountInfo copyBillItemAmountInfo(BillItem billItem, SplitRule rule) {
        ItemAmountInfo itemAmountInfo = (ItemAmountInfo)JSON.parseObject((String)JSON.toJSONString((Object)billItem), ItemAmountInfo.class);
        itemAmountInfo.setPriceMethod(rule.getPriceMethod());
        return itemAmountInfo;
    }

    protected boolean gtLimitAmount(BillItem billItem, SplitRule rule, String invoiceType) {
        String taxInvoiceSource = rule.getTaxInvoiceSource();
        String itemTypeCode = billItem.getItemTypeCode();
        boolean isAllElectronicSpecialInvoice = ItemTypeCodeEnum.isAllElectronicSpecialInvoice((String)itemTypeCode);
        if (TaxInvoiceSourceEnum.QD.getValue().equals(taxInvoiceSource) && !InvoiceType.isAllElectronicNormalInvoice(invoiceType) && isAllElectronicSpecialInvoice) {
            return false;
        }
        return this.splitLimitChecker.gtLimit(billItem, rule);
    }
}

