/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.phoenix.split.service.impl;

import com.google.common.base.Strings;
import com.xforceplus.phoenix.split.constant.InvoiceType;
import com.xforceplus.phoenix.split.constant.RemarkConstant;
import com.xforceplus.phoenix.split.constant.RemarkFieldNameEnum;
import com.xforceplus.phoenix.split.model.BillInfo;
import com.xforceplus.phoenix.split.model.BillItem;
import com.xforceplus.phoenix.split.model.FieldOfObj;
import com.xforceplus.phoenix.split.model.PriceMethod;
import com.xforceplus.phoenix.split.model.RemarkFieldMetadata;
import com.xforceplus.phoenix.split.model.SplitRule;
import com.xforceplus.phoenix.split.service.RemarkService;
import com.xforceplus.phoenix.split.util.CommonTools;
import com.xforceplus.phoenix.split.util.FieldUtils;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.ibatis.reflection.ReflectionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class RemarkServiceImpl
implements RemarkService {
    private static final Logger logger = LoggerFactory.getLogger(RemarkServiceImpl.class);

    @Override
    public String splice(BillInfo billInfo, SplitRule rule) {
        if (InvoiceType.isVehicle(billInfo.getInvoiceType())) {
            return "\u4e00\u8f66\u4e00\u7968";
        }
        StringBuilder sb = new StringBuilder();
        sb.append(this.handleRedInvoiceRemark(billInfo));
        List remarkFieldMetadataBeanList = rule.getRemarkFiledMetadataBeanList();
        if (CollectionUtils.isNotEmpty((Collection)remarkFieldMetadataBeanList)) {
            sb.append(this.handleRemark(billInfo, rule, remarkFieldMetadataBeanList));
        }
        this.appendSpace(sb);
        if (StringUtils.isNotBlank((CharSequence)rule.getExtRemark())) {
            sb.append(rule.getExtRemark());
        }
        return sb.toString();
    }

    protected String handleRemark(BillInfo billInfo, SplitRule rule, List<RemarkFieldMetadata> remarkFieldMetadataBeanList) {
        List billItems = billInfo.getBillItems();
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < remarkFieldMetadataBeanList.size(); ++i) {
            RemarkFieldMetadata metadataBean = remarkFieldMetadataBeanList.get(i);
            int type = metadataBean.getType();
            if (type == 1) {
                sb.append(metadataBean.getFieldFixedValue());
            } else if (metadataBean.getFieldGroupIndex() == FieldOfObj.BILL_INFO) {
                sb.append(this.processMainRemark(billInfo, rule, metadataBean));
            } else if (rule.isRemarkDuplicateFlag()) {
                sb.append(this.processItemRemark(billItems, rule, metadataBean));
            }
            if (i == remarkFieldMetadataBeanList.size() - 1) continue;
            this.concatSeparator(rule, sb);
        }
        if (!rule.isRemarkDuplicateFlag()) {
            if (Objects.nonNull(sb) && sb.length() > 0) {
                if (StringUtils.endsWith((CharSequence)sb.toString(), (CharSequence)RemarkConstant.SPACE)) {
                    sb.replace(sb.lastIndexOf(RemarkConstant.SPACE), sb.length(), RemarkConstant.TAB);
                } else {
                    sb.append(RemarkConstant.TAB);
                }
            }
            sb.append(this.processDuplicateItemRemark(billItems, rule, remarkFieldMetadataBeanList));
        }
        return sb.toString();
    }

    protected String handleOriginalRemark(BillInfo billInfo, SplitRule rule, List<RemarkFieldMetadata> remarkFieldMetadataBeanList) {
        StringBuilder sb = new StringBuilder();
        long size = this.checkMainRemark(remarkFieldMetadataBeanList);
        if (size > 0L) {
            this.appendSpace(sb);
            sb.append(Objects.toString(billInfo.getRemark(), ""));
            boolean remarkWrapsFlag = rule.getRemarkWrapsFlag();
            if (remarkWrapsFlag) {
                this.appendTab(sb);
            }
        }
        this.appendSpace(sb);
        return sb.toString();
    }

    protected String handleCustomRemark(BillInfo billInfo, SplitRule rule, List<RemarkFieldMetadata> remarkFieldMetadataBeanList) {
        List billItems = billInfo.getBillItems();
        StringBuilder sb = new StringBuilder();
        for (RemarkFieldMetadata metadataBean : remarkFieldMetadataBeanList) {
            if (metadataBean.getFieldGroupIndex() == FieldOfObj.BILL_INFO) {
                if (StringUtils.equals((CharSequence)metadataBean.getFieldName(), (CharSequence)RemarkFieldNameEnum.REMARK.getValue())) continue;
                sb.append(this.processMainRemark(billInfo, rule, metadataBean));
            } else if (rule.isRemarkDuplicateFlag()) {
                sb.append(this.processItemRemark(billItems, rule, metadataBean));
            }
            boolean remarkWrapsFlag = rule.getRemarkWrapsFlag();
            if (remarkWrapsFlag) {
                this.appendTab(sb);
                continue;
            }
            this.appendSpace(sb);
        }
        if (!rule.isRemarkDuplicateFlag()) {
            if (Objects.nonNull(sb) && sb.length() > 0) {
                if (StringUtils.endsWith((CharSequence)sb.toString(), (CharSequence)RemarkConstant.SPACE)) {
                    sb.replace(sb.lastIndexOf(RemarkConstant.SPACE), sb.length(), RemarkConstant.TAB);
                } else {
                    sb.append(RemarkConstant.TAB);
                }
            }
            sb.append(this.processDuplicateItemRemark(billItems, rule, remarkFieldMetadataBeanList));
        }
        return sb.toString();
    }

    protected void concatSeparator(SplitRule rule, StringBuilder sb) {
        Integer separatorType = rule.getRemarkSeparatorType();
        if (separatorType == null) {
            boolean remarkWrapsFlag = rule.getRemarkWrapsFlag();
            if (remarkWrapsFlag) {
                this.appendTab(sb);
            } else {
                this.appendSpace(sb);
            }
        } else {
            switch (separatorType) {
                case 1: {
                    this.appendComma(sb);
                    break;
                }
                case 2: {
                    this.appendDawn(sb);
                    break;
                }
                case 3: {
                    this.appendColon(sb);
                    break;
                }
                case 4: {
                    this.appendSemiColon(sb);
                    break;
                }
                case 5: {
                    this.appendDash(sb);
                    break;
                }
                case 6: {
                    this.appendVerticalBar(sb);
                    break;
                }
                case 7: {
                    this.appendSpace(sb);
                    break;
                }
                case 8: {
                    this.appendTab(sb);
                }
            }
        }
    }

    protected String getSeparator(SplitRule rule) {
        String separator = RemarkConstant.SPACE;
        Integer separatorType = rule.getRemarkSeparatorType();
        if (null == separatorType) {
            return separator;
        }
        switch (separatorType) {
            case 1: {
                separator = RemarkConstant.COMMA;
                break;
            }
            case 2: {
                separator = RemarkConstant.DAWN;
                break;
            }
            case 3: {
                separator = RemarkConstant.COLON;
                break;
            }
            case 4: {
                separator = RemarkConstant.SEMICOLON;
                break;
            }
            case 5: {
                separator = RemarkConstant.DASH;
                break;
            }
            case 6: {
                separator = RemarkConstant.VERTICAL_BAR;
                break;
            }
            case 7: {
                separator = RemarkConstant.SPACE;
                break;
            }
            case 8: {
                separator = RemarkConstant.TAB;
            }
        }
        return separator;
    }

    protected long checkMainRemark(List<RemarkFieldMetadata> remarkFieldMetadataBeanList) {
        return remarkFieldMetadataBeanList.stream().filter(remarkFieldMetadata -> RemarkFieldNameEnum.REMARK.getValue().equalsIgnoreCase(remarkFieldMetadata.getFieldName()) && FieldOfObj.BILL_INFO == remarkFieldMetadata.getFieldGroupIndex()).count();
    }

    protected String processItemRemark(List<BillItem> billItems, SplitRule splitRule, RemarkFieldMetadata metadataBean) {
        StringBuilder sb = new StringBuilder();
        boolean removeRemarkItemDuplicate = splitRule.isRemoveRemarkItemDuplicate();
        String value = StringUtils.equals((CharSequence)metadataBean.getFieldName(), (CharSequence)RemarkFieldNameEnum.TAX_PRE.getValue()) ? billItems.stream().map(billItem -> this.getTaxPre(billItem.getTaxPre())).filter(StringUtils::isNotBlank).distinct().collect(Collectors.joining(this.getSeparator(splitRule))) : (StringUtils.equals((CharSequence)metadataBean.getFieldName(), (CharSequence)RemarkFieldNameEnum.ZERO_TAX.getValue()) ? billItems.stream().map(billItem -> this.getZeroTaxMark(billItem.getZeroTax())).filter(StringUtils::isNotBlank).distinct().collect(Collectors.joining(this.getSeparator(splitRule))) : (removeRemarkItemDuplicate ? this.removeItemDuplicate(billItems, splitRule, metadataBean) : billItems.stream().map(billItem -> this.getCustomFieldValue(billItem, metadataBean.getFieldName())).filter(StringUtils::isNotBlank).distinct().collect(Collectors.joining(this.getSeparator(splitRule)))));
        String key = this.getDefault(metadataBean.getFieldDisplayName());
        sb.append(this.assembleRemarkUnit(key, value, splitRule));
        return sb.toString();
    }

    protected String removeItemDuplicate(List<BillItem> billItems, SplitRule splitRule, RemarkFieldMetadata metadataBean) {
        String value = billItems.stream().map(billItem -> {
            ArrayList<String> results = new ArrayList<String>();
            String eachValue = this.getCustomFieldValue(billItem, metadataBean.getFieldName());
            if (eachValue.contains(",")) {
                String[] strings = eachValue.split(",");
                results.addAll(Arrays.asList(strings));
            } else {
                results.add(eachValue);
            }
            return results;
        }).flatMap(Collection::stream).filter(StringUtils::isNotBlank).distinct().collect(Collectors.joining(this.getSeparator(splitRule)));
        return value;
    }

    protected String processDuplicateItemRemark(List<BillItem> billItems, SplitRule splitRule, List<RemarkFieldMetadata> metadataBeans) {
        StringBuilder sb = new StringBuilder();
        billItems.forEach(billItem -> {
            for (RemarkFieldMetadata metadataBean : metadataBeans) {
                String value;
                BigDecimal amount;
                if (metadataBean.getFieldGroupIndex() == FieldOfObj.BILL_INFO) continue;
                value = StringUtils.equals((CharSequence)metadataBean.getFieldName(), (CharSequence)RemarkFieldNameEnum.TAX_PRE.getValue()) ? this.getTaxPre(billItem.getTaxPre()) : (StringUtils.equals((CharSequence)metadataBean.getFieldName(), (CharSequence)RemarkFieldNameEnum.ZERO_TAX.getValue()) ? this.getZeroTaxMark(billItem.getZeroTax()) : (RemarkFieldNameEnum.isAmountKindField(metadataBean.getFieldName()) ? ((amount = (BigDecimal)Optional.ofNullable(CommonTools.getBigDecimal(value = this.getCustomFieldValue(billItem, metadataBean.getFieldName()))).map(e -> e.setScale(2, RoundingMode.HALF_UP)).orElse(null)) != null ? amount.toString() : "") : this.getCustomFieldValue(billItem, metadataBean.getFieldName())));
                String key = this.getDefault(metadataBean.getFieldDisplayName());
                sb.append(this.assembleRemarkUnit(key, value, splitRule));
            }
            sb.append(RemarkConstant.TAB);
        });
        return sb.toString();
    }

    protected String processMainRemark(BillInfo billInfo, SplitRule rule, RemarkFieldMetadata metadataBean) {
        StringBuilder sb = new StringBuilder();
        if (StringUtils.equals((CharSequence)metadataBean.getFieldName(), (CharSequence)RemarkFieldNameEnum.FIXED_REMARK.getValue())) {
            sb.append(Strings.nullToEmpty((String)rule.getFixedRemarkText()));
        } else if (StringUtils.equals((CharSequence)metadataBean.getFieldName(), (CharSequence)RemarkFieldNameEnum.REMARK.getValue())) {
            sb.append(Strings.nullToEmpty((String)billInfo.getRemark()));
        } else if (StringUtils.equals((CharSequence)metadataBean.getFieldName(), (CharSequence)RemarkFieldNameEnum.PRICE_METHOD.getValue())) {
            PriceMethod priceMethod = rule.getPriceMethod();
            String key = this.getDefault(metadataBean.getFieldDisplayName());
            String value = this.getPriceMethod(priceMethod);
            sb.append(this.assembleRemarkUnit(key, value, rule));
        } else if (RemarkFieldNameEnum.isAmountKindField(metadataBean.getFieldName())) {
            String key = this.getDefault(metadataBean.getFieldDisplayName());
            String value = this.getCustomFieldValue(billInfo, metadataBean.getFieldName());
            BigDecimal amount = Optional.ofNullable(CommonTools.getBigDecimal(value)).map(e -> e.setScale(2, RoundingMode.HALF_UP)).orElse(null);
            String formatValue = amount != null ? amount.toString() : "";
            sb.append(this.assembleRemarkUnit(key, formatValue, rule));
        } else {
            String key = this.getDefault(metadataBean.getFieldDisplayName());
            String value = this.getCustomFieldValue(billInfo, metadataBean.getFieldName());
            sb.append(this.assembleRemarkUnit(key, value, rule));
        }
        return sb.toString();
    }

    private String getDefault(String key) {
        return StringUtils.isEmpty((CharSequence)key) ? "" : key;
    }

    protected String assembleRemarkUnit(String key, String value, SplitRule rule) {
        boolean hideRemarkFieldName = rule.isHideRemarkFieldName();
        StringBuilder sb = new StringBuilder();
        if (rule.getRemarkKeyValueShowType() == null) {
            rule.setRemarkKeyValueShowType(Integer.valueOf(0));
        }
        if (StringUtils.isNotBlank((CharSequence)value)) {
            switch (rule.getRemarkKeyValueShowType()) {
                case 1: {
                    if (hideRemarkFieldName) {
                        sb.append(RemarkConstant.COMMA).append(value);
                        break;
                    }
                    sb.append(key).append(RemarkConstant.COMMA).append(value);
                    break;
                }
                case 2: {
                    if (hideRemarkFieldName) {
                        sb.append(RemarkConstant.DAWN).append(value);
                        break;
                    }
                    sb.append(key).append(RemarkConstant.DAWN).append(value);
                    break;
                }
                case 3: {
                    if (hideRemarkFieldName) {
                        sb.append(RemarkConstant.COLON).append(value);
                        break;
                    }
                    sb.append(key).append(RemarkConstant.COLON).append(value);
                    break;
                }
                case 4: {
                    if (hideRemarkFieldName) {
                        sb.append(RemarkConstant.SEMICOLON).append(value);
                        break;
                    }
                    sb.append(key).append(RemarkConstant.SEMICOLON).append(value);
                    break;
                }
                case 5: {
                    if (hideRemarkFieldName) {
                        sb.append(RemarkConstant.DASH).append(value);
                        break;
                    }
                    sb.append(key).append(RemarkConstant.DASH).append(value);
                    break;
                }
                case 6: {
                    if (hideRemarkFieldName) {
                        sb.append(RemarkConstant.VERTICAL_BAR).append(value);
                        break;
                    }
                    sb.append(key).append(RemarkConstant.VERTICAL_BAR).append(value);
                    break;
                }
                case 7: {
                    if (hideRemarkFieldName) {
                        sb.append(RemarkConstant.SPACE).append(value);
                        break;
                    }
                    sb.append(key).append(RemarkConstant.SPACE).append(value);
                    break;
                }
                case 8: {
                    if (hideRemarkFieldName) {
                        sb.append(RemarkConstant.TAB).append(value);
                        break;
                    }
                    sb.append(key).append(RemarkConstant.TAB).append(value);
                    break;
                }
                default: {
                    if (hideRemarkFieldName) {
                        sb.append("[").append(value).append("]");
                        break;
                    }
                    sb.append(key).append("[").append(value).append("]");
                }
            }
        }
        return sb.toString();
    }

    protected String handleRedInvoiceRemark(BillInfo billInfo) {
        StringBuilder sb = new StringBuilder();
        if (InvoiceType.SPECIAL.value().equals(billInfo.getInvoiceType())) {
            if (StringUtils.isNotBlank((CharSequence)billInfo.getRedNotificationNo())) {
                sb.append(CommonTools.format(RemarkConstant.RED_SPECIAL_REMARK, billInfo.getRedNotificationNo()));
            }
        } else if (InvoiceType.NORMAL.value().equals(billInfo.getInvoiceType()) || InvoiceType.ELECTRONIC.value().equals(billInfo.getInvoiceType())) {
            if (StringUtils.isNotBlank((CharSequence)billInfo.getOriginInvoiceCode())) {
                sb.append(RemarkConstant.RED_NORMAL_REMARK).append(CommonTools.format(RemarkConstant.RED_NORMAL_REMARK_CODE, billInfo.getOriginInvoiceCode()));
                if (StringUtils.isNotBlank((CharSequence)billInfo.getOriginInvoiceNo())) {
                    sb.append(CommonTools.format(RemarkConstant.RED_NORMAL_REMARK_NO, billInfo.getOriginInvoiceNo()));
                }
            } else if (StringUtils.isNotBlank((CharSequence)billInfo.getOriginInvoiceNo())) {
                sb.append(RemarkConstant.RED_NORMAL_REMARK).append(CommonTools.format(RemarkConstant.RED_NORMAL_REMARK_NO, billInfo.getOriginInvoiceNo()));
            }
        }
        return sb.toString();
    }

    private void appendSpace(StringBuilder sb) {
        if (StringUtils.isNotBlank((CharSequence)sb.toString()) && !StringUtils.endsWith((CharSequence)sb.toString(), (CharSequence)RemarkConstant.SPACE)) {
            sb.append(RemarkConstant.SPACE);
        }
    }

    private void appendTab(StringBuilder sb) {
        if (StringUtils.isNotBlank((CharSequence)sb.toString()) && !StringUtils.endsWith((CharSequence)sb.toString(), (CharSequence)RemarkConstant.TAB)) {
            sb.append(RemarkConstant.TAB);
        }
    }

    private void appendComma(StringBuilder sb) {
        if (StringUtils.isNotBlank((CharSequence)sb.toString()) && !StringUtils.endsWith((CharSequence)sb.toString(), (CharSequence)RemarkConstant.COMMA)) {
            sb.append(RemarkConstant.COMMA);
        }
    }

    private void appendDawn(StringBuilder sb) {
        if (StringUtils.isNotBlank((CharSequence)sb.toString()) && !StringUtils.endsWith((CharSequence)sb.toString(), (CharSequence)RemarkConstant.DAWN)) {
            sb.append(RemarkConstant.DAWN);
        }
    }

    private void appendColon(StringBuilder sb) {
        if (StringUtils.isNotBlank((CharSequence)sb.toString()) && !StringUtils.endsWith((CharSequence)sb.toString(), (CharSequence)RemarkConstant.COLON)) {
            sb.append(RemarkConstant.COLON);
        }
    }

    private void appendSemiColon(StringBuilder sb) {
        if (StringUtils.isNotBlank((CharSequence)sb.toString()) && !StringUtils.endsWith((CharSequence)sb.toString(), (CharSequence)RemarkConstant.SEMICOLON)) {
            sb.append(RemarkConstant.SEMICOLON);
        }
    }

    private void appendDash(StringBuilder sb) {
        if (StringUtils.isNotBlank((CharSequence)sb.toString()) && !StringUtils.endsWith((CharSequence)sb.toString(), (CharSequence)RemarkConstant.DASH)) {
            sb.append(RemarkConstant.DASH);
        }
    }

    private void appendVerticalBar(StringBuilder sb) {
        if (StringUtils.isNotBlank((CharSequence)sb.toString()) && !StringUtils.endsWith((CharSequence)sb.toString(), (CharSequence)RemarkConstant.VERTICAL_BAR)) {
            sb.append(RemarkConstant.VERTICAL_BAR);
        }
    }

    protected String getCustomFieldValue(Object object, String fieldName) {
        String text = "";
        if (object instanceof BillItem) {
            text = "\u660e\u7ec6\u4fe1\u606f";
        } else if (object instanceof BillInfo) {
            text = "\u4e3b\u4fe1\u606f";
        }
        try {
            return Objects.toString(FieldUtils.getFieldValue(object, fieldName), "");
        }
        catch (ReflectionException e) {
            logger.warn("\u5143\u6570\u636e\u83b7\u53d6{}\u5b57\u6bb5\u503c\u9519\u8bef:{}", (Object)text, (Object)e.getMessage());
            return "";
        }
    }

    private String getTaxPre(String taxPre) {
        return StringUtils.equals((CharSequence)taxPre, (CharSequence)"1") ? "\u4eab\u53d7" : "\u4e0d\u4eab\u53d7";
    }

    private String getZeroTaxMark(String zeroTax) {
        return StringUtils.equals((CharSequence)zeroTax, (CharSequence)"0") ? "\u51fa\u53e3\u9000\u7a0e" : (StringUtils.equals((CharSequence)zeroTax, (CharSequence)"1") ? "\u514d\u7a0e" : (StringUtils.equals((CharSequence)zeroTax, (CharSequence)"2") ? "\u4e0d\u5f81\u7a0e" : (StringUtils.equals((CharSequence)zeroTax, (CharSequence)"3") ? "\u666e\u901a\u96f6\u7a0e\u7387" : "\u975e\u96f6\u7a0e\u7387")));
    }

    private String getPriceMethod(PriceMethod priceMethod) {
        return priceMethod == PriceMethod.WITH_TAX ? "\u542b\u7a0e" : "\u4e0d\u542b\u7a0e";
    }
}

