package com.xforceplus.phoenix.split.constant;

import com.xforceplus.phoenix.split.exception.SplitRuleParamException;
import org.apache.commons.lang3.StringUtils;

import java.util.Arrays;

/**
 * @Author chenlingwei
 * @create 2023/8/24 11:00 AM
 */
public enum SpecialGoodsTaxNoEnum {

    INTANGIBLE_ASSETS_OLD("4060000000000000000"),
    INTANGIBLE_ASSETS_NEW("4069900000000000000");

    private String value;

    public String getValue() {
        return value;
    }

    SpecialGoodsTaxNoEnum(String value) {
        this.value = value;
    }

    /**
     * 是否为金额类备注
     * @param value
     * @return
     */
    public static boolean isIntangibleAssets(String value) {
        return Arrays.asList(INTANGIBLE_ASSETS_OLD.value, INTANGIBLE_ASSETS_NEW.value).contains(value);
    }

    public static SpecialGoodsTaxNoEnum getDefaultOrByValue(String value) {
        if (StringUtils.isBlank(value)) {
            return null;
        } else {
            for (SpecialGoodsTaxNoEnum returnMode : SpecialGoodsTaxNoEnum.values()) {
                if (returnMode.value.equals(value)) {
                    return returnMode;
                }
            }
        }
        throw new SplitRuleParamException(String.format("returnMode = [%s] is invalid", value));
    }

}
