package com.xforceplus.phoenix.split.constant;

import java.util.Optional;

/**
 * 设备类型，销项仅在使用 1、3、8
 */
public enum TaxDeviceType {
    /**
     * 1 百望单盘 2 百望服务器 3 航信单盘 4 航信服务器 5 虚拟UKey设备 8 税务UKey设备 7 税务证书
     */
    BW_SINGL("1", "BW","百望单盘"),
    BW_SERVER("2", "BW","百望服务器"),
    HX_SINGL("3", "HX","航信单盘"),
    HX_SERVER("4", "HX","航信服务器"),
    V_UKEY("5", "BW","虚拟UKey设备"),
    UKEY("8", "BW","税务UKey设备"),
    TAX_CER("7", "HX","税务证书"),
    ;

    TaxDeviceType(String type,String code , String typeDesc) {
        this.type = type;
        this.typeDesc = typeDesc;
        this.code = code;
    }

    private String type;
    private String code;
    private String typeDesc;

    public String getType() {
        return type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getTypeDesc() {
        return typeDesc;
    }

    public void setTypeDesc(String typeDesc) {
        this.typeDesc = typeDesc;
    }

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    /**
     * 根据设备类型获取
     * @param type
     * @return
     */
    public static Optional<TaxDeviceType> getDeviceTypeByType(String type) {
        TaxDeviceType[] taxDeviceTypes = TaxDeviceType.values();
        for (TaxDeviceType tmp : taxDeviceTypes) {
            if (tmp.getType().equals(type)) {
                return Optional.of(tmp);
            }
        }
        return Optional.of(HX_SINGL);
    }



    public static boolean isBW(TaxDeviceType taxDeviceType) {
        if(taxDeviceType == BW_SERVER || taxDeviceType == BW_SINGL || taxDeviceType == UKEY || taxDeviceType == V_UKEY){
            return true;
        }
        return false;
    }
}
