package com.xforceplus.phoenix.split.service;

import com.xforceplus.phoenix.split.constant.TaxDeviceType;
import com.xforceplus.phoenix.split.model.BillItem;
import com.xforceplus.phoenix.split.model.SplitRule;
import com.xforceplus.phoenix.split.service.impl.BWSplitBillItemByAmountWithTaxServiceImpl;
import com.xforceplus.phoenix.split.service.impl.SplitBillItemAmountByQuantityAndAmountLimitServiceImpl;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;

@Service
public class SplitBillItemAmountServiceFactory {

    @Autowired
    @Qualifier("defaultSplitBillItemAmountServiceImpl")
    private SplitBillItemAmountService defaultSplitBillItemAmountService;

    @Autowired
    @Qualifier("splitBillItemByAmountWithTaxServiceImpl")
    private SplitBillItemAmountService splitBillItemByAmountWithTaxServiceImpl;

    @Autowired
    @Qualifier("BWSplitBillItemByAmountWithTaxServiceImpl")
    private BWSplitBillItemByAmountWithTaxServiceImpl bWSplitBillItemByAmountWithTaxServiceImpl;

    @Autowired
    private SplitBillItemAmountByQuantityAndAmountLimitServiceImpl splitBillItemAmountByQuantityAndAmountLimitServiceImpl;

    public SplitBillItemAmountService getByRule(BillItem billItem, SplitRule rule, TaxDeviceType taxDeviceType) {
        if (MapUtils.isNotEmpty(rule.getQuantityLimitMap())
                && StringUtils.isNotBlank(billItem.getQuantityUnit())
                && rule.getQuantityLimitMap().containsKey(billItem.getQuantityUnit())) {
            return splitBillItemAmountByQuantityAndAmountLimitServiceImpl;
        } else {
            if (rule.isLimitIsAmountWithTax()) {
                //限额为含税限额时的限额拆分逻辑
                return splitBillItemByAmountWithTaxServiceImpl;
            } else {
                //限额为不含税限额时的拆分逻辑
                return (taxDeviceType == TaxDeviceType.BW_SERVER || taxDeviceType == TaxDeviceType.BW_SINGL)
                        //百旺系列逻辑（TODO 理论上数电场景无用，但是有配置）
                        ? bWSplitBillItemByAmountWithTaxServiceImpl
                        //通用逻辑
                        : defaultSplitBillItemAmountService;

            }
        }
    }

}
