package com.xforceplus.phoenix.split.service.dataflow.impl;

import com.xforceplus.phoenix.split.constant.GroupByKeyPatternEnum;
import com.xforceplus.phoenix.split.domain.ItemGroup;
import com.xforceplus.phoenix.split.model.BillItem;
import com.xforceplus.phoenix.split.model.SplitRule;
import com.xforceplus.phoenix.split.service.dataflow.AbstractBillItemGroupPlugin;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * 当存在数量限额时，根据单位分组
 */
@Service
public class GroupItemByUnitPlugin extends AbstractBillItemGroupPlugin {

    /**
     * 分组key
     */
    @Override
    protected String generateKey(BillItem billItem, SplitRule rule) {
        return StringUtils.isNotBlank(billItem.getQuantityUnit()) && rule.getQuantityLimitMap().containsKey(billItem.getQuantityUnit())
                ? String.format(GroupByKeyPatternEnum.UNIT_HIT.getValue(), billItem.getQuantityUnit())
                : GroupByKeyPatternEnum.UNIT_MISS.getValue();
    }

    /**
     * 是否需要分组
     */
    @Override
    protected boolean support(SplitRule rule, List<ItemGroup> itemGroups) {
        if (MapUtils.isEmpty(rule.getQuantityLimitMap())) {
            return false;
        }

        return itemGroups.stream().anyMatch(e -> CollectionUtils.isNotEmpty(e.getBillItems())
                && e.getBillItems().stream().anyMatch(billItem -> StringUtils.isNotBlank(billItem.getQuantityUnit()) && rule.getQuantityLimitMap().containsKey(billItem.getQuantityUnit()))
        );
    }
}
