package com.xforceplus.phoenix.split.config;

import com.google.common.collect.Lists;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.stereotype.Component;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

@Component
@ConfigurationProperties(prefix = "rule")
public class DataProcessPluginConfig implements InitializingBean {

    private Map<String, List<String>> pluginBeanNames;

    public Map<String, List<String>> getPluginBeanNames() {
        return pluginBeanNames;
    }

    public void setPluginBeanNames(Map<String, List<String>> pluginBeanNames) {
        this.pluginBeanNames = pluginBeanNames;
    }

    public List<String> getBeanNamesByRuleCode(String ruleCode) {
        return pluginBeanNames.get(ruleCode);
    }

    @Override
    public void afterPropertiesSet() {
        if (pluginBeanNames == null) {
            pluginBeanNames = new HashMap<>(4);
        }

        List<String> plugins = Lists.newArrayListWithCapacity(16);
        plugins.add("fieldProcessPlugin");
        plugins.add("groupItemByZeroTaxPlugin");
        plugins.add("groupItemByRedAndBluePlugin");
        plugins.add("groupItemBySplitCodePlugin");
        plugins.add("groupItemByPriceNumNonPlugin");
        plugins.add("groupItemBySplitFieldPlugin");
        plugins.add("groupItemByItemTypeCodePlugin");
        plugins.add("groupItemByTaxPreConPlugin");
        //TODO 立邦定制拆票插件？
        plugins.add("groupItemByUnitPlugin");
        plugins.add("redBillItemProcessPlugin");
        plugins.add("splitBillItemPlugin");
        plugins.add("minSplitBillItemPlugin");
        plugins.add("billItemDiscountAmountProcessPlugin");
        plugins.add("invoiceLimitProcessPlugin");
        plugins.add("basicPlugin");
        pluginBeanNames.put("default", plugins);
    }
}
