package com.xforceplus.phoenix.split.service.impl;

import com.alibaba.fastjson.JSON;
import com.google.common.collect.Lists;
import com.xforceplus.phoenix.split.domain.ItemAmountInfo;
import com.xforceplus.phoenix.split.model.SplitRule;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;
import java.util.List;

/**
 * 百旺拆票规则实现类
 */
@Service
public class BWSplitBillItemByAmountWithTaxServiceImpl extends DefaultSplitBillItemAmountServiceImpl {

    /**
     * @param itemAmountInfo
     * @param rule
     * @return
     */
    @Override
    public List<ItemAmountInfo> splitAmount(ItemAmountInfo itemAmountInfo, SplitRule rule) {
        ItemAmountInfo splitAmountInfo = JSON.parseObject(JSON.toJSONString(itemAmountInfo), ItemAmountInfo.class);
        boolean hasQuantity = itemAmountInfo.getQuantity().compareTo(BigDecimal.ZERO) != 0;
        mergeDiscountAmount(splitAmountInfo);

        ItemAmountInfo tmpAmountInfo = new ItemAmountInfo();
        BeanUtils.copyProperties(splitAmountInfo, tmpAmountInfo);

        BigDecimal limitAmount = rule.getInvoiceLimit();
        List<ItemAmountInfo> result = Lists.newArrayList();
        ItemAmountInfo splitItemAmountInfo = splitFirstItemAmountInfo(rule, splitAmountInfo, limitAmount);
        while (gtLimitAmount(splitAmountInfo, limitAmount)) {
            if (splitItemAmountInfo == null) {
                splitItemAmountInfo = splitFirstItemAmountInfo(rule, splitAmountInfo, limitAmount);
            } else {
                splitItemAmountInfo = copyFirstItemAmount(limitAmount, rule, splitAmountInfo, splitItemAmountInfo);
            }
            deductSplitItemAmount(rule, splitAmountInfo, splitItemAmountInfo);
            result.add(splitItemAmountInfo);
        }
        /**
         * 处理最后一条尾差，最后一条的税额 折扣税额 问题，根据具体情况，进行不同的分摊
         * 税额分摊从
         */
        processLastItemUnitPriceAndQuantity(splitAmountInfo, hasQuantity, rule);

        result = processLastItemErrorAmount(splitAmountInfo, result, rule);
        return result;
    }

    @Override
    protected ItemAmountInfo splitFirstItemAmountInfo(SplitRule rule, ItemAmountInfo itemAmountInfo, BigDecimal limitAmount) {
        return itemAmountInfo.bwCreateItemAmountByAmountWithoutTax(rule, limitAmount);
    }

}
