/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.phoenix.split.config;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.stereotype.Component;

@Component
@ConfigurationProperties(prefix="rule")
public class DataProcessPluginConfig
implements InitializingBean {
    private Map<String, List<String>> pluginBeanNames;

    public Map<String, List<String>> getPluginBeanNames() {
        return this.pluginBeanNames;
    }

    public void setPluginBeanNames(Map<String, List<String>> pluginBeanNames) {
        this.pluginBeanNames = pluginBeanNames;
    }

    public List<String> getBeanNamesByRuleCode(String ruleCode) {
        return this.pluginBeanNames.get(ruleCode);
    }

    public void afterPropertiesSet() {
        if (this.pluginBeanNames == null) {
            this.pluginBeanNames = new HashMap<String, List<String>>(4);
        }
        ArrayList plugins = Lists.newArrayListWithCapacity((int)16);
        plugins.add("fieldProcessPlugin");
        plugins.add("groupItemByZeroTaxPlugin");
        plugins.add("groupItemByRedAndBluePlugin");
        plugins.add("groupItemBySplitCodePlugin");
        plugins.add("groupItemByPriceNumNonPlugin");
        plugins.add("groupItemBySplitFieldPlugin");
        plugins.add("groupItemByItemTypeCodePlugin");
        plugins.add("groupItemByTaxPreConPlugin");
        plugins.add("groupItemByUnitPlugin");
        plugins.add("redBillItemProcessPlugin");
        plugins.add("splitBillItemPlugin");
        plugins.add("minSplitBillItemPlugin");
        plugins.add("billItemDiscountAmountProcessPlugin");
        plugins.add("invoiceLimitProcessPlugin");
        plugins.add("basicPlugin");
        this.pluginBeanNames.put("default", plugins);
    }
}

