/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.phoenix.split.service;

import com.xforceplus.phoenix.split.constant.TaxDeviceType;
import com.xforceplus.phoenix.split.model.BillItem;
import com.xforceplus.phoenix.split.model.SplitRule;
import com.xforceplus.phoenix.split.service.SplitBillItemAmountService;
import com.xforceplus.phoenix.split.service.impl.BWSplitBillItemByAmountWithTaxServiceImpl;
import com.xforceplus.phoenix.split.service.impl.SplitBillItemAmountByQuantityAndAmountLimitServiceImpl;
import java.util.Map;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;

@Service
public class SplitBillItemAmountServiceFactory {
    @Autowired
    @Qualifier(value="defaultSplitBillItemAmountServiceImpl")
    private SplitBillItemAmountService defaultSplitBillItemAmountService;
    @Autowired
    @Qualifier(value="splitBillItemByAmountWithTaxServiceImpl")
    private SplitBillItemAmountService splitBillItemByAmountWithTaxServiceImpl;
    @Autowired
    @Qualifier(value="BWSplitBillItemByAmountWithTaxServiceImpl")
    private BWSplitBillItemByAmountWithTaxServiceImpl bWSplitBillItemByAmountWithTaxServiceImpl;
    @Autowired
    private SplitBillItemAmountByQuantityAndAmountLimitServiceImpl splitBillItemAmountByQuantityAndAmountLimitServiceImpl;

    public SplitBillItemAmountService getByRule(BillItem billItem, SplitRule rule, TaxDeviceType taxDeviceType) {
        if (MapUtils.isNotEmpty((Map)rule.getQuantityLimitMap()) && StringUtils.isNotBlank((CharSequence)billItem.getQuantityUnit()) && rule.getQuantityLimitMap().containsKey(billItem.getQuantityUnit())) {
            return this.splitBillItemAmountByQuantityAndAmountLimitServiceImpl;
        }
        if (rule.isLimitIsAmountWithTax()) {
            return this.splitBillItemByAmountWithTaxServiceImpl;
        }
        return taxDeviceType == TaxDeviceType.BW_SERVER || taxDeviceType == TaxDeviceType.BW_SINGL ? this.bWSplitBillItemByAmountWithTaxServiceImpl : this.defaultSplitBillItemAmountService;
    }
}

