/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.phoenix.split.service.dataflow;

import com.google.common.collect.Lists;
import com.xforceplus.phoenix.split.constant.InvoiceItemOrder;
import com.xforceplus.phoenix.split.constant.InvoiceType;
import com.xforceplus.phoenix.split.constant.TaxDeviceType;
import com.xforceplus.phoenix.split.domain.ItemGroup;
import com.xforceplus.phoenix.split.domain.SplitGroupLimit;
import com.xforceplus.phoenix.split.model.BillInfo;
import com.xforceplus.phoenix.split.model.BillItem;
import com.xforceplus.phoenix.split.model.ItemTypeCodeEnum;
import com.xforceplus.phoenix.split.model.SplitRule;
import com.xforceplus.phoenix.split.service.dataflow.impl.InvoiceLimitProcessPlugin;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import org.springframework.stereotype.Service;

@Service
public class SpecialInvoiceService
extends InvoiceLimitProcessPlugin {
    protected Integer getAllElectronicSpecialInvoiceItemMaxRow(String itemTypeCode, String invoiceType) {
        ItemTypeCodeEnum itemTypeCodeEnum = ItemTypeCodeEnum.fromValue((String)itemTypeCode);
        if (itemTypeCodeEnum == ItemTypeCodeEnum.BUILDING) {
            return 1;
        }
        if (itemTypeCodeEnum == ItemTypeCodeEnum.CARGO_TRANSPORT) {
            if (InvoiceType.isNormalOrSpecialInvoice(invoiceType)) {
                return 1;
            }
            return 2000;
        }
        if (itemTypeCodeEnum == ItemTypeCodeEnum.PROPERTY_SALE) {
            return 1;
        }
        if (itemTypeCodeEnum == ItemTypeCodeEnum.PROPERTY_RENT) {
            return 2000;
        }
        if (itemTypeCodeEnum == ItemTypeCodeEnum.SCRAPPED_PRODUCT_ACQUISITION) {
            return 2000;
        }
        return null;
    }

    public List<ItemGroup> assembleItems(SplitRule rule, ItemGroup itemGroup, BillInfo billInfo, List<BillItem> specialBillItems) {
        Map<String, List<BillItem>> itemTypeCodeBillItemMap = specialBillItems.stream().collect(Collectors.groupingBy(BillItem::getItemTypeCode));
        ArrayList<ItemGroup> results = new ArrayList<ItemGroup>();
        for (Map.Entry<String, List<BillItem>> entry : itemTypeCodeBillItemMap.entrySet()) {
            String itemTypeCode = entry.getKey();
            List<BillItem> billItems = entry.getValue();
            SplitGroupLimit splitGroupLimit = new SplitGroupLimit();
            splitGroupLimit.setLimitIsAmountWithTax(rule.isLimitIsAmountWithTax());
            splitGroupLimit.setInvoiceMaxErrorAmount(rule.getInvoiceMaxErrorAmount());
            splitGroupLimit.setLimitAmount(BigDecimal.valueOf(9.999999999999E10));
            splitGroupLimit.setInvoiceItemOrder(InvoiceItemOrder.fromValue(rule.getItemSort()));
            splitGroupLimit.setLimitLine(this.getAllElectronicSpecialInvoiceItemMaxRow(itemTypeCode, billInfo.getInvoiceType()));
            while (!billItems.isEmpty()) {
                List<BillItem> processedItemList = this.splitByAmountAndLineLimit(billItems, itemTypeCode, splitGroupLimit);
                ItemGroup processedItemGroup = new ItemGroup(itemGroup.getParentGroupFlag());
                processedItemGroup.setInvoiceOfGroupKey(UUID.randomUUID().toString());
                processedItemGroup.setBillItems(processedItemList);
                results.add(processedItemGroup);
            }
        }
        return results;
    }

    protected List<BillItem> splitByAmountAndLineLimit(List<BillItem> billItems, String itemTypeCode, SplitGroupLimit splitGroupLimit) {
        BigDecimal amount = BigDecimal.ZERO;
        int lineNum = 0;
        LinkedList splitGroup = Lists.newLinkedList();
        BigDecimal totalErrorAmount = BigDecimal.ZERO;
        BigDecimal totalErrorAmountAbs = BigDecimal.ZERO;
        BigDecimal basicInvoiceMaxErrorAmount = BigDecimal.valueOf(1.26);
        BigDecimal businessInvoiceMaxErrorAmount = splitGroupLimit.getInvoiceMaxErrorAmount();
        Iterator<BillItem> it = billItems.iterator();
        while (it.hasNext()) {
            BillItem item = it.next();
            if (item.getDeductions().compareTo(BigDecimal.ZERO) > 0) {
                if (splitGroup.size() > 0) continue;
                splitGroup.add(item);
                it.remove();
                return splitGroup;
            }
            boolean isAmountGtLimit = amount.add(this.actualAmount(item, splitGroupLimit.isLimitIsAmountWithTax())).compareTo(splitGroupLimit.getLimitAmount()) > 0;
            boolean isLineGtLimit = lineNum + this.needLineNum(item) > splitGroupLimit.getLimitLine();
            BigDecimal currentItemErrorAmount = this.errorAmountCalculation(item, TaxDeviceType.HX_SINGL);
            BigDecimal currentItemErrorAmountAbs = this.errorAmountCalculation(item, TaxDeviceType.HX_SINGL);
            boolean rateFor1dot27 = this.totalErrorAmountCalculation(totalErrorAmount, currentItemErrorAmount, basicInvoiceMaxErrorAmount, TaxDeviceType.HX_SINGL);
            boolean rateForBusinessRule = this.totalErrorAmountCalculationForBusiness(totalErrorAmountAbs, currentItemErrorAmountAbs, businessInvoiceMaxErrorAmount);
            if (isLineGtLimit || rateFor1dot27 || rateForBusinessRule) {
                return splitGroup;
            }
            if (isAmountGtLimit) continue;
            amount = amount.add(this.actualAmount(item, splitGroupLimit.isLimitIsAmountWithTax()));
            lineNum += this.needLineNum(item);
            totalErrorAmount = totalErrorAmount.add(currentItemErrorAmount);
            totalErrorAmountAbs = totalErrorAmountAbs.add(currentItemErrorAmountAbs);
            splitGroup.add(item);
            it.remove();
        }
        return splitGroup;
    }

    @Override
    public int needLineNum(BillItem item) {
        return 1;
    }
}

