/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.phoenix.split.service.dataflow.impl;

import com.google.common.collect.Lists;
import com.xforceplus.phoenix.split.constant.InvoiceType;
import com.xforceplus.phoenix.split.constant.TaxInvoiceSourceEnum;
import com.xforceplus.phoenix.split.domain.ItemGroup;
import com.xforceplus.phoenix.split.model.BillItem;
import com.xforceplus.phoenix.split.model.ItemTypeCodeEnum;
import com.xforceplus.phoenix.split.model.SplitRule;
import com.xforceplus.phoenix.split.service.dataflow.AbstractBillItemGroupPlugin;
import java.util.List;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
public class GroupItemByItemTypeCodePlugin
extends AbstractBillItemGroupPlugin {
    private static final String DEFAULT_ITEM_TYPE_CODE = "default_item_type_code";

    @Override
    public boolean support(SplitRule rule, List<ItemGroup> itemGroups) {
        return itemGroups.stream().anyMatch(e -> {
            List<BillItem> billItems = e.getBillItems();
            if (TaxInvoiceSourceEnum.QD.getValue().equals(rule.getTaxInvoiceSource()) && !CollectionUtils.isEmpty(billItems) && billItems.stream().anyMatch(e1 -> Lists.newArrayList((Object[])new String[]{InvoiceType.SPECIAL.value(), InvoiceType.SE.value()}).contains(rule.getInvoiceType()))) {
                return billItems.stream().anyMatch(e1 -> ItemTypeCodeEnum.isSpecialInvoiceAndJDC((String)e1.getItemTypeCode()));
            }
            return !CollectionUtils.isEmpty(billItems) && billItems.stream().anyMatch(e1 -> ItemTypeCodeEnum.isSpecialInvoice((String)e1.getItemTypeCode()));
        });
    }

    @Override
    public String generateKey(BillItem billItem, SplitRule rule) {
        String itemTypeCode = billItem.getItemTypeCode();
        if (StringUtils.isEmpty((Object)itemTypeCode)) {
            return DEFAULT_ITEM_TYPE_CODE;
        }
        ItemTypeCodeEnum itemTypeCodeEnum = ItemTypeCodeEnum.fromValue((String)itemTypeCode);
        if (itemTypeCodeEnum == null) {
            return DEFAULT_ITEM_TYPE_CODE;
        }
        return itemTypeCodeEnum.getValue();
    }
}

