/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.phoenix.split.service.dataflow.impl;

import com.xforceplus.phoenix.split.domain.ItemGroup;
import com.xforceplus.phoenix.split.model.BillItem;
import com.xforceplus.phoenix.split.model.SplitRule;
import com.xforceplus.phoenix.split.service.dataflow.AbstractBillItemGroupPlugin;
import java.math.BigDecimal;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;

@Service
public class GroupItemByPriceNumNonPlugin
extends AbstractBillItemGroupPlugin {
    @Override
    protected String generateKey(BillItem billItem, SplitRule rule) {
        String priceFlag = "not-non";
        String qualityFlag = "not-non";
        if (Objects.isNull(billItem.getUnitPrice()) || billItem.getUnitPrice().compareTo(BigDecimal.ZERO) == 0) {
            priceFlag = "non";
        }
        if (Objects.isNull(billItem.getQuantity()) || billItem.getQuantity().compareTo(BigDecimal.ZERO) == 0) {
            qualityFlag = "non";
        }
        return StringUtils.equals((CharSequence)qualityFlag, (CharSequence)priceFlag) ? qualityFlag : "not-non";
    }

    @Override
    protected boolean support(SplitRule rule, List<ItemGroup> itemGroups) {
        return rule.isSplitByItemPriceQuantityNon();
    }
}

