/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.phoenix.split.service.dataflow.impl;

import com.xforceplus.phoenix.split.constant.InvoiceType;
import com.xforceplus.phoenix.split.domain.ItemGroup;
import com.xforceplus.phoenix.split.model.BillItem;
import com.xforceplus.phoenix.split.model.SplitRule;
import com.xforceplus.phoenix.split.model.ZeroTaxOption;
import com.xforceplus.phoenix.split.service.dataflow.AbstractBillItemGroupPlugin;
import java.math.BigDecimal;
import java.util.List;
import org.springframework.stereotype.Service;

@Service
public class GroupItemByZeroTaxPlugin
extends AbstractBillItemGroupPlugin {
    @Override
    protected String generateKey(BillItem billItem, SplitRule rule) {
        return billItem.getTaxRate().compareTo(BigDecimal.ZERO) == 0 ? "zero" : "no_zero";
    }

    @Override
    protected boolean support(SplitRule rule, List<ItemGroup> itemGroups) {
        InvoiceType invoiceType = InvoiceType.fromValue(rule.getInvoiceType());
        return invoiceType == InvoiceType.SPECIAL && rule.getZeroTaxOption() == ZeroTaxOption.PROCESS;
    }
}

