/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.phoenix.split.service.dataflow.impl.invoiceLimit;

import com.xforceplus.phoenix.split.config.SplitProperties;
import com.xforceplus.phoenix.split.constant.ErrorAmountPolicyEnum;
import com.xforceplus.phoenix.split.constant.TaxDeviceType;
import com.xforceplus.phoenix.split.model.BillItem;
import com.xforceplus.phoenix.split.model.SplitRule;
import java.math.BigDecimal;
import java.util.Optional;

public abstract class AbstractCombineItemService {
    private final SplitProperties splitProperties;

    protected BigDecimal actualAmount(BillItem item, boolean limitIsAmountWithTax) {
        BigDecimal result = limitIsAmountWithTax ? item.getAmountWithTax().subtract(item.getDiscountWithTax()) : item.getAmountWithoutTax().subtract(item.getDiscountWithoutTax());
        return result;
    }

    protected int actualLineNum(BillItem item) {
        if (item.getDiscountWithoutTax().compareTo(BigDecimal.ZERO) > 0 && (item.getOutterDiscountWithoutTax().compareTo(BigDecimal.ZERO) > 0 || item.getOutterPrepayAmountWithoutTax().compareTo(BigDecimal.ZERO) > 0)) {
            return 2;
        }
        return 1;
    }

    protected BigDecimal errorAmountCalculation(BillItem item, TaxDeviceType taxDeviceType) {
        String type = this.splitProperties.getCalculationConfig().get(taxDeviceType.getCode());
        BigDecimal diff = item.getAmountWithoutTax().multiply(item.getTaxRate()).subtract(item.getTaxAmount()).subtract(item.getDiscountWithoutTax().multiply(item.getTaxRate()).subtract(item.getDiscountTax()));
        return ErrorAmountPolicyEnum.ABS.name().equals(type) ? diff.abs() : diff;
    }

    protected Boolean totalErrorAmountCalculation(BigDecimal totalErrorAmount, BigDecimal currentItemAmount, BigDecimal basicInvoiceMaxErrorAmount, TaxDeviceType taxDeviceType) {
        if (TaxDeviceType.isBW(taxDeviceType)) {
            return Boolean.FALSE;
        }
        return totalErrorAmount.add(currentItemAmount).abs().compareTo(basicInvoiceMaxErrorAmount) > 0;
    }

    public Boolean totalErrorAmountCalculationForBusiness(BigDecimal totalErrorAmount, BigDecimal currentItemErrorAmount, BigDecimal businessInvoiceMaxErrorAmount) {
        return businessInvoiceMaxErrorAmount != null && businessInvoiceMaxErrorAmount.compareTo(BigDecimal.ZERO) != 0 && totalErrorAmount.add(currentItemErrorAmount).abs().compareTo(businessInvoiceMaxErrorAmount) > 0;
    }

    protected BigDecimal getMaxErrorAmountByTaxDeviceType(TaxDeviceType taxDeviceType, SplitRule splitRule) {
        boolean isQdSpecialAddition = splitRule.isEnableAdvancedValidation();
        if (isQdSpecialAddition) {
            return BigDecimal.valueOf(1.27);
        }
        return Optional.ofNullable(this.splitProperties.getInvoiceMaxErrorAmountPolicy()).map(r -> (BigDecimal)r.get(taxDeviceType.getCode())).orElse(new BigDecimal("1.26"));
    }

    public AbstractCombineItemService(SplitProperties splitProperties) {
        this.splitProperties = splitProperties;
    }
}

