/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.phoenix.split.service.impl;

import com.alibaba.fastjson.JSON;
import com.xforceplus.phoenix.split.domain.ItemAmountInfo;
import com.xforceplus.phoenix.split.exception.BWSplitRuleSpliteAmountException;
import com.xforceplus.phoenix.split.model.SplitRule;
import com.xforceplus.phoenix.split.service.impl.DefaultSplitBillItemAmountServiceImpl;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.springframework.beans.BeanUtils;

@Deprecated
public class BWSplitBillItemWithOutTaxServiceImpl
extends DefaultSplitBillItemAmountServiceImpl {
    @Override
    public List<ItemAmountInfo> splitAmount(ItemAmountInfo itemAmountInfo, SplitRule rule) {
        ItemAmountInfo splitAmountInfo = (ItemAmountInfo)JSON.parseObject((String)JSON.toJSONString((Object)itemAmountInfo), ItemAmountInfo.class);
        this.mergeDiscountAmount(splitAmountInfo);
        ItemAmountInfo tmpAountInfo = new ItemAmountInfo();
        BeanUtils.copyProperties((Object)splitAmountInfo, (Object)tmpAountInfo);
        BigDecimal limitAmount = rule.getInvoiceLimit();
        ItemAmountInfo splitItemAmountInfo = this.splitFirstItemAmountInfo(rule, splitAmountInfo, limitAmount);
        List<ItemAmountInfo> itemAmountInfos = this.optimumItemAmount(splitItemAmountInfo, splitAmountInfo, rule);
        return itemAmountInfos;
    }

    @Override
    protected ItemAmountInfo splitFirstItemAmountInfo(SplitRule rule, ItemAmountInfo itemAmountInfo, BigDecimal limitAmount) {
        return itemAmountInfo.bwCreateItemAmountByAmountWithoutTax(rule, limitAmount);
    }

    private List<ItemAmountInfo> optimumItemAmount(ItemAmountInfo splitItemAmountInfo, ItemAmountInfo itemAmountInfo, SplitRule rule) {
        boolean hasQuantity = itemAmountInfo.getQuantity().compareTo(BigDecimal.ZERO) != 0;
        BigDecimal totalAmount = itemAmountInfo.getAmountWithoutTax();
        BigDecimal taxAmount = totalAmount.multiply(itemAmountInfo.getTaxRate());
        BigDecimal totalTaxAmountDiff = taxAmount.subtract(taxAmount.setScale(2, RoundingMode.HALF_UP));
        BigDecimal discountAmount = splitItemAmountInfo.getDiscountWithoutTax();
        BigDecimal discountTaxAmount = discountAmount.multiply(itemAmountInfo.getTaxRate());
        BigDecimal totalDisscountTaxAmountDiff = discountTaxAmount.subtract(discountTaxAmount.setScale(2, RoundingMode.HALF_UP));
        BigDecimal limitAmount = rule.getInvoiceLimit();
        ArrayList<ItemAmountInfo> res = new ArrayList<ItemAmountInfo>();
        Map<Boolean, ItemValueDistribution> taxAmountWithOutTaxPair = this.seekOptimumAmounts(itemAmountInfo, limitAmount, splitItemAmountInfo.getUnitPrice(), splitItemAmountInfo.getQuantity(), 20, rule.getAmountSplitRule(), splitItemAmountInfo.getTaxRate(), splitItemAmountInfo);
        if (Objects.isNull(taxAmountWithOutTaxPair)) {
            throw new IllegalArgumentException("\u672a\u77e5\u7684\u62c6\u7968\u89c4\u5219[" + rule.getAmountSplitRule() + "]");
        }
        DiscountRatio discountRatio = this.assessDiscount(discountAmount, taxAmountWithOutTaxPair, rule.getInvoiceLimit(), totalAmount, itemAmountInfo.getDiscountWithoutTax());
        Map<Boolean, ItemValueDistribution> discountTaxAmountWithOutTaxPair = this.seekOptimumDiscountAmounts(discountRatio.amount, splitItemAmountInfo.getTaxRate(), 10, BigDecimal.ZERO, discountRatio.flag != false ? BigDecimal.valueOf(-0.01) : BigDecimal.valueOf(0.01));
        Map<String, ItemAmountInfo> itemAmountInfoMap = this.initialAmountGroup(splitItemAmountInfo, taxAmountWithOutTaxPair, discountTaxAmountWithOutTaxPair);
        Boolean negation = totalTaxAmountDiff.compareTo(BigDecimal.ZERO) < 0;
        ItemValueDistribution tmpDistribution = taxAmountWithOutTaxPair.get(negation);
        Boolean discountNegation = totalDisscountTaxAmountDiff.compareTo(BigDecimal.ZERO) < 0;
        ItemValueDistribution tmpDiscountDistribution = discountTaxAmountWithOutTaxPair.get(discountNegation);
        if (tmpDistribution.preLessLimit.booleanValue() && !negation.booleanValue()) {
            negation = tmpDistribution.preLessLimit;
        }
        while (itemAmountInfo.getAmountWithoutTax().subtract(tmpDiscountDistribution.getValue()).compareTo(tmpDistribution.getValue()) > 0) {
            tmpDistribution = taxAmountWithOutTaxPair.get(negation);
            totalTaxAmountDiff = totalTaxAmountDiff.subtract(tmpDistribution.getDiff());
            tmpDiscountDistribution = discountTaxAmountWithOutTaxPair.get(discountNegation);
            totalDisscountTaxAmountDiff = totalDisscountTaxAmountDiff.subtract(tmpDiscountDistribution.getDiff());
            ItemAmountInfo tmpItemAmountInfo = itemAmountInfoMap.get(this.calculateKey(negation, discountNegation));
            this.deductSplitItemAmount(rule, itemAmountInfo, tmpItemAmountInfo);
            negation = totalTaxAmountDiff.compareTo(BigDecimal.ZERO) < 0;
            discountNegation = totalDisscountTaxAmountDiff.compareTo(BigDecimal.ZERO) < 0;
            res.add(tmpItemAmountInfo);
        }
        this.processLastItemUnitPriceAndQuantity(itemAmountInfo, hasQuantity, rule);
        if (itemAmountInfo.getAmountWithoutTax().add(itemAmountInfo.getOutterDiscountWithoutTax()).compareTo(BigDecimal.ZERO) > 0) {
            res.add(itemAmountInfo);
        }
        return res;
    }

    @Override
    public void processLastItemUnitPriceAndQuantity(ItemAmountInfo itemAmountInfo, boolean hasQuantity, SplitRule rule) {
        if (hasQuantity) {
            BigDecimal res;
            BigDecimal quantity = itemAmountInfo.getQuantity();
            if (quantity.compareTo(BigDecimal.ZERO) == 0) {
                quantity = MIN_QUANTITY;
            }
            if (rule.getAmountSplitRule().equals("3")) {
                itemAmountInfo.setQuantity(itemAmountInfo.getAmountWithoutTax().divide(itemAmountInfo.getUnitPrice(), 6, RoundingMode.HALF_UP));
            }
            if (rule.getAmountSplitRule().equals("1")) {
                itemAmountInfo.setUnitPrice(itemAmountInfo.getAmountWithoutTax().divide(quantity, (int)rule.getUnitPriceScale(), RoundingMode.HALF_UP));
            }
            if ((res = itemAmountInfo.getQuantity().multiply(itemAmountInfo.getUnitPrice()).setScale(2, RoundingMode.HALF_UP)).compareTo(itemAmountInfo.getAmountWithoutTax()) != 0) {
                super.processLastItemUnitPriceAndQuantity(itemAmountInfo, hasQuantity, rule);
            }
        }
    }

    private DiscountRatio assessDiscount(BigDecimal discountAmount, Map<Boolean, ItemValueDistribution> taxAmountWithOutTaxPair, BigDecimal limiteAmount, BigDecimal totalAmountWithOutTax, BigDecimal totalDiscountWithOutTax) {
        BigDecimal amountWithOutTax;
        if (discountAmount.compareTo(BigDecimal.ZERO) == 0 || totalDiscountWithOutTax.compareTo(BigDecimal.ZERO) == 0) {
            return new DiscountRatio(BigDecimal.ZERO, false);
        }
        Boolean flag = Boolean.FALSE;
        if (taxAmountWithOutTaxPair.get(Boolean.TRUE).getValue().compareTo(taxAmountWithOutTaxPair.get(Boolean.FALSE).getValue()) > 0) {
            flag = Boolean.TRUE;
        }
        if ((amountWithOutTax = taxAmountWithOutTaxPair.get(flag).getValue()).compareTo(limiteAmount) > 0) {
            return new DiscountRatio(amountWithOutTax.subtract(limiteAmount), Boolean.TRUE);
        }
        amountWithOutTax = taxAmountWithOutTaxPair.get(flag == false).getValue();
        BigDecimal ratio = amountWithOutTax.divide(totalAmountWithOutTax, 10, RoundingMode.HALF_UP);
        return new DiscountRatio(ratio.multiply(totalDiscountWithOutTax).setScale(2, RoundingMode.HALF_UP), Boolean.FALSE);
    }

    private Map<String, ItemAmountInfo> initialAmountGroup(ItemAmountInfo itemAmountInfo, Map<Boolean, ItemValueDistribution> taxAmountWithOutTaxPair, Map<Boolean, ItemValueDistribution> discountTaxAmountWithOutTaxPair) {
        HashMap<String, ItemAmountInfo> itemAmountInfoMap = new HashMap<String, ItemAmountInfo>();
        ItemAmountInfo tempAmountInfoTT = this.reCalculate(taxAmountWithOutTaxPair.get(Boolean.TRUE), itemAmountInfo);
        this.reCalculateDiscount(discountTaxAmountWithOutTaxPair.get(Boolean.TRUE), tempAmountInfoTT);
        itemAmountInfoMap.put(this.calculateKey(true, true), tempAmountInfoTT);
        ItemAmountInfo tempAmountInfoFF = this.reCalculate(taxAmountWithOutTaxPair.get(Boolean.FALSE), itemAmountInfo);
        this.reCalculateDiscount(discountTaxAmountWithOutTaxPair.get(Boolean.FALSE), tempAmountInfoFF);
        itemAmountInfoMap.put(this.calculateKey(false, false), tempAmountInfoFF);
        ItemAmountInfo tempAmountInfoFT = this.reCalculate(taxAmountWithOutTaxPair.get(Boolean.FALSE), itemAmountInfo);
        this.reCalculateDiscount(discountTaxAmountWithOutTaxPair.get(Boolean.TRUE), tempAmountInfoFT);
        itemAmountInfoMap.put(this.calculateKey(false, true), tempAmountInfoFT);
        ItemAmountInfo tempAmountInfoTF = this.reCalculate(taxAmountWithOutTaxPair.get(Boolean.TRUE), itemAmountInfo);
        this.reCalculateDiscount(discountTaxAmountWithOutTaxPair.get(Boolean.FALSE), tempAmountInfoTF);
        itemAmountInfoMap.put(this.calculateKey(true, false), tempAmountInfoTF);
        return itemAmountInfoMap;
    }

    private String calculateKey(Boolean v1, Boolean v2) {
        return (v1 != false ? "T" : "F") + (v2 != false ? "T" : "F");
    }

    private Map<Boolean, ItemValueDistribution> seekOptimumAmounts(ItemAmountInfo itemAmountInfo, BigDecimal ruleLimit, BigDecimal unitPrice, BigDecimal quality, Integer num, String amountSplitRule, BigDecimal taxRate, ItemAmountInfo splitItemAmountInfo) {
        if (itemAmountInfo.getQuantity().compareTo(BigDecimal.ZERO) == 0) {
            return this.seekOptimumDiscountAmounts(splitItemAmountInfo.getAmountWithoutTax(), taxRate, 20, splitItemAmountInfo.getDeductions(), BigDecimal.valueOf(0.01));
        }
        if (amountSplitRule.equals("1")) {
            BigDecimal step = BigDecimal.valueOf(0.01).divide(quality, 6, RoundingMode.HALF_UP);
            step = step.compareTo(BigDecimal.ZERO) == 0 ? BigDecimal.valueOf(1.0E-6) : step;
            return this.rejustAmountByQuanlity(unitPrice, quality, taxRate, step, splitItemAmountInfo.getDeductions(), amountSplitRule, itemAmountInfo, ruleLimit);
        }
        if (amountSplitRule.equals("2")) {
            throw new BWSplitRuleSpliteAmountException("\u767e\u65fa,UKEY\u6a21\u5f0f\u4e0b\uff0c\u4e0d\u652f\u6301\u6570\u91cf\u53d6\u6574\u89c4\u5219\uff0c\u5efa\u8bae\u4f7f\u7528\u5176\u4ed6\u89c4\u5219:\u4fdd\u5355\u4ef7\u62c6\u6570\u91cf\u4e0d\u53d6\u6574\u6216\u4fdd\u6570\u91cf\u62c6\u5355\u4ef7");
        }
        if (amountSplitRule.equals("3")) {
            BigDecimal step = BigDecimal.valueOf(0.01).divide(unitPrice, 6, RoundingMode.HALF_UP);
            step = step.compareTo(BigDecimal.ZERO) == 0 ? BigDecimal.valueOf(1.0E-6) : step;
            return this.rejustAmountByQuanlity(unitPrice, quality, taxRate, step, splitItemAmountInfo.getDeductions(), amountSplitRule, itemAmountInfo, ruleLimit);
        }
        return null;
    }

    private Map<Boolean, ItemValueDistribution> rejustAmountByQuanlity(BigDecimal unitPrice, BigDecimal quality, BigDecimal taxRate, BigDecimal step, BigDecimal deduction, String type, ItemAmountInfo itemAmountInfo, BigDecimal ruleLimit) {
        HashMap<Boolean, ItemValueDistribution> ite = new HashMap<Boolean, ItemValueDistribution>();
        int num = 20;
        num = type.equals("3") ? quality.divide(step, 0, RoundingMode.DOWN).intValue() : unitPrice.divide(step, 0, RoundingMode.DOWN).intValue();
        num = num > 20 ? 20 : num;
        BigDecimal resQuality = BigDecimal.ZERO;
        BigDecimal resUnitPrice = BigDecimal.ZERO;
        BigDecimal resLimitValue = BigDecimal.ZERO;
        BigDecimal resTaxValue = BigDecimal.ZERO;
        BigDecimal resTaxValueDiff = BigDecimal.ZERO;
        BigDecimal resPreQuality = BigDecimal.ZERO;
        BigDecimal resPreUnitPrice = BigDecimal.ZERO;
        BigDecimal resPreLimitValue = BigDecimal.ZERO;
        BigDecimal resPreTaxValue = BigDecimal.ZERO;
        BigDecimal resPreTaxValueDiff = BigDecimal.ZERO;
        BigDecimal min = BigDecimal.ONE;
        boolean brk = false;
        boolean contin = false;
        boolean preLessLimit = false;
        for (int i = 0; i <= num - 2; ++i) {
            BigDecimal tmpQuality = type.equals("3") ? quality.subtract(step.multiply(BigDecimal.valueOf(i))) : quality;
            BigDecimal tmpUnitPrice = type.equals("1") ? unitPrice.subtract(step.multiply(BigDecimal.valueOf(i))) : unitPrice;
            BigDecimal limitValue = tmpQuality.multiply(tmpUnitPrice).setScale(2, RoundingMode.HALF_UP);
            BigDecimal preTmpQuality = type.equals("3") ? tmpQuality.subtract(step) : tmpQuality;
            BigDecimal preUnitPrice = type.equals("1") ? tmpUnitPrice.subtract(step) : tmpUnitPrice;
            BigDecimal preLimitValue = preTmpQuality.multiply(preUnitPrice).setScale(2, RoundingMode.HALF_UP);
            preLessLimit = ruleLimit.compareTo(itemAmountInfo.getAmountWithoutTax().subtract(limitValue)) >= 0;
            preLimitValue = preLessLimit ? itemAmountInfo.getAmountWithoutTax().subtract(limitValue) : preLimitValue;
            BigDecimal preDeduction = preLessLimit ? itemAmountInfo.getDeductions().subtract(deduction) : deduction;
            BigDecimal taxValue = limitValue.subtract(deduction).multiply(taxRate);
            BigDecimal preTaxValue = preLimitValue.subtract(preDeduction).multiply(taxRate);
            BigDecimal preDiff = preTaxValue.subtract(preTaxValue.setScale(2, RoundingMode.HALF_UP));
            BigDecimal diff = taxValue.subtract(taxValue.setScale(2, RoundingMode.HALF_UP));
            if (diff.compareTo(BigDecimal.ZERO) == 0) {
                preLimitValue = limitValue;
                preTmpQuality = tmpQuality;
                preUnitPrice = tmpUnitPrice;
                preTaxValue = taxValue;
                preDiff = diff;
                brk = true;
            }
            if (preDiff.compareTo(BigDecimal.ZERO) == 0 && !preLessLimit) {
                limitValue = preLimitValue;
                tmpQuality = preTmpQuality;
                tmpUnitPrice = preUnitPrice;
                taxValue = preTaxValue;
                brk = true;
            }
            if (diff.add(preDiff).abs().compareTo(diff.abs().add(preDiff.abs())) < 0 && min.compareTo(diff.abs().add(preDiff.abs())) > 0) {
                min = diff.abs().add(preDiff.abs());
                contin = true;
            }
            if (!contin && !brk) continue;
            resQuality = tmpQuality;
            resUnitPrice = tmpUnitPrice;
            resLimitValue = limitValue;
            resTaxValue = taxValue.setScale(2, RoundingMode.HALF_UP);
            resTaxValueDiff = diff;
            resPreQuality = preTmpQuality;
            resPreUnitPrice = preUnitPrice;
            resPreLimitValue = preLimitValue;
            resPreTaxValue = preTaxValue.setScale(2, RoundingMode.HALF_UP);
            resPreTaxValueDiff = preDiff;
            if (contin) {
                contin = false;
            }
            if (brk) break;
        }
        BigDecimal firstDecimal = resLimitValue;
        BigDecimal secondDecimal = resPreLimitValue;
        Boolean negation = preLessLimit ? preLessLimit : resTaxValueDiff.compareTo(BigDecimal.ZERO) < 0;
        ite.put(negation, new ItemValueDistribution(firstDecimal, resTaxValueDiff, resQuality, resUnitPrice, resTaxValue, preLessLimit));
        ite.put(negation == false, new ItemValueDistribution(secondDecimal, resPreTaxValueDiff, resPreQuality, resPreUnitPrice, resPreTaxValue, preLessLimit));
        return ite;
    }

    private ItemAmountInfo reCalculate(ItemValueDistribution itemValueDistribution, ItemAmountInfo itemAmountInfo) {
        ItemAmountInfo newItemAmountInfo = (ItemAmountInfo)JSON.parseObject((String)JSON.toJSONString((Object)itemAmountInfo), ItemAmountInfo.class);
        newItemAmountInfo.setUnitPrice(itemValueDistribution.getUnitPrice());
        newItemAmountInfo.setQuantity(itemValueDistribution.getQuanlity());
        newItemAmountInfo.setAmountWithoutTax(itemValueDistribution.getValue());
        newItemAmountInfo.setTaxAmount(itemValueDistribution.getTaxValue());
        newItemAmountInfo.setAmountWithTax(newItemAmountInfo.getAmountWithoutTax().add(newItemAmountInfo.getTaxAmount()));
        newItemAmountInfo.setDeductions(itemAmountInfo.getDeductions());
        return newItemAmountInfo;
    }

    private ItemAmountInfo reCalculateDiscount(ItemValueDistribution itemValueDistribution, ItemAmountInfo itemAmountInfo) {
        itemAmountInfo.setDiscountWithoutTax(itemValueDistribution.getValue());
        itemAmountInfo.setDiscountTax(itemValueDistribution.getTaxValue());
        itemAmountInfo.setDiscountWithTax(itemValueDistribution.getValue().add(itemValueDistribution.getTaxValue()));
        return itemAmountInfo;
    }

    private Map<Boolean, ItemValueDistribution> seekOptimumDiscountAmounts(BigDecimal limitValue, BigDecimal taxRate, Integer num, BigDecimal deduction, BigDecimal step) {
        int flag = 0;
        BigDecimal min = new BigDecimal("1");
        ArrayList<BigDecimal> diffs = new ArrayList<BigDecimal>(2);
        diffs.add(BigDecimal.ZERO);
        diffs.add(BigDecimal.ZERO);
        ArrayList<BigDecimal> taxValues = new ArrayList<BigDecimal>(2);
        taxValues.add(BigDecimal.ZERO);
        taxValues.add(BigDecimal.ZERO);
        HashMap<Boolean, ItemValueDistribution> ite = new HashMap<Boolean, ItemValueDistribution>();
        if (limitValue.compareTo(BigDecimal.ZERO) == 0) {
            ite.put(Boolean.FALSE, new ItemValueDistribution(BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO));
            ite.put(Boolean.TRUE, new ItemValueDistribution(BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO));
            return ite;
        }
        num = limitValue.divide(step, 0, RoundingMode.DOWN).intValue();
        num = step.compareTo(BigDecimal.ZERO) > 0 ? (num > 10 ? 10 : num) : 10;
        for (int i = num - 1; i >= 1; --i) {
            BigDecimal taxValue = limitValue.subtract(BigDecimal.valueOf(i).multiply(step)).subtract(deduction).multiply(taxRate);
            BigDecimal preTaxValue = limitValue.subtract(BigDecimal.valueOf(i - 1).multiply(step)).subtract(deduction).multiply(taxRate);
            BigDecimal preDiff = preTaxValue.subtract(preTaxValue.setScale(2, RoundingMode.HALF_UP));
            BigDecimal diff = taxValue.subtract(taxValue.setScale(2, RoundingMode.HALF_UP));
            BigDecimal diffStep = diff.abs().add(preDiff.abs());
            if (min.compareTo(diffStep) <= 0 || diff.add(preDiff).abs().compareTo(diff.abs().add(preDiff.abs())) >= 0) continue;
            diffs.set(0, diff);
            diffs.set(1, preDiff);
            min = diffStep;
            flag = i;
            taxValues.set(0, taxValue.setScale(2, RoundingMode.HALF_UP));
            taxValues.set(1, preTaxValue.setScale(2, RoundingMode.HALF_UP));
        }
        BigDecimal firstDecimal = limitValue.subtract(BigDecimal.valueOf(flag).multiply(step));
        BigDecimal secondDecimal = limitValue.subtract(BigDecimal.valueOf(flag - 1).multiply(step));
        Boolean negation = ((BigDecimal)diffs.get(0)).compareTo(BigDecimal.ZERO) < 0;
        ite.put(negation, new ItemValueDistribution(firstDecimal, (BigDecimal)diffs.get(0), BigDecimal.ZERO, BigDecimal.ZERO, (BigDecimal)taxValues.get(0)));
        ite.put(negation == false, new ItemValueDistribution(secondDecimal, (BigDecimal)diffs.get(1), BigDecimal.ZERO, BigDecimal.ZERO, (BigDecimal)taxValues.get(1)));
        return ite;
    }

    class DiscountRatio {
        private BigDecimal amount;
        private Boolean flag;
        private Integer num;

        public DiscountRatio(BigDecimal amount, Boolean flag) {
            this.amount = amount;
            this.flag = flag;
        }

        public BigDecimal getAmount() {
            return this.amount;
        }

        public void setAmount(BigDecimal amount) {
            this.amount = amount;
        }

        public Boolean getFlag() {
            return this.flag;
        }

        public void setFlag(Boolean flag) {
            this.flag = flag;
        }
    }

    static class ItemValueDistribution {
        private BigDecimal value;
        private BigDecimal diff;
        private BigDecimal taxValue;
        private BigDecimal quanlity;
        private BigDecimal unitPrice;
        private Boolean preLessLimit;

        public ItemValueDistribution(BigDecimal value, BigDecimal diff) {
            this.value = value;
            this.diff = diff;
        }

        public ItemValueDistribution(BigDecimal value, BigDecimal diff, BigDecimal quanlity, BigDecimal unitPrice, BigDecimal taxValue) {
            this.value = value;
            this.diff = diff;
            this.quanlity = quanlity;
            this.unitPrice = unitPrice;
            this.taxValue = taxValue;
        }

        public ItemValueDistribution(BigDecimal value, BigDecimal diff, BigDecimal quanlity, BigDecimal unitPrice, BigDecimal taxValue, Boolean preLessLimit) {
            this.value = value;
            this.diff = diff;
            this.quanlity = quanlity;
            this.unitPrice = unitPrice;
            this.taxValue = taxValue;
            this.preLessLimit = preLessLimit;
        }

        public BigDecimal getValue() {
            return this.value;
        }

        public void setValue(BigDecimal value) {
            this.value = value;
        }

        public BigDecimal getDiff() {
            return this.diff;
        }

        public void setDiff(BigDecimal diff) {
            this.diff = diff;
        }

        public BigDecimal getQuanlity() {
            return this.quanlity;
        }

        public void setQuanlity(BigDecimal quanlity) {
            this.quanlity = quanlity;
        }

        public BigDecimal getUnitPrice() {
            return this.unitPrice;
        }

        public void setUnitPrice(BigDecimal unitPrice) {
            this.unitPrice = unitPrice;
        }

        public BigDecimal getTaxValue() {
            return this.taxValue;
        }

        public void setTaxValue(BigDecimal taxValue) {
            this.taxValue = taxValue;
        }
    }
}

