/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.phoenix.split.domain;

import com.alibaba.fastjson.JSON;
import com.xforceplus.phoenix.split.exception.SplitBizException;
import com.xforceplus.phoenix.split.model.PriceMethod;
import com.xforceplus.phoenix.split.model.SplitRule;
import com.xforceplus.phoenix.split.service.AmountSplitRuleUtils;
import java.math.BigDecimal;
import java.math.RoundingMode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ItemAmountInfo {
    private static final BigDecimal MIN_QUANTITY = BigDecimal.ONE.movePointLeft(6);
    private Logger logger = LoggerFactory.getLogger(ItemAmountInfo.class);
    private static final BigDecimal MAX_SPLIT_RATE = new BigDecimal("0.99");
    private String salesbillItemId;
    private PriceMethod priceMethod;
    private BigDecimal quantity;
    private BigDecimal unitPrice;
    private String quantityUnit;
    private BigDecimal taxRate;
    private BigDecimal amountWithoutTax;
    private BigDecimal taxAmount;
    private BigDecimal amountWithTax;
    private BigDecimal discountWithoutTax = BigDecimal.ZERO;
    private BigDecimal discountTax = BigDecimal.ZERO;
    private BigDecimal discountWithTax = BigDecimal.ZERO;
    private BigDecimal deductions = BigDecimal.ZERO;
    private BigDecimal outterDiscountWithTax = BigDecimal.ZERO;
    private BigDecimal outterDiscountWithoutTax = BigDecimal.ZERO;
    private BigDecimal outterDiscountTax = BigDecimal.ZERO;
    private BigDecimal innerDiscountWithTax = BigDecimal.ZERO;
    private BigDecimal innerDiscountWithoutTax = BigDecimal.ZERO;
    private BigDecimal innerDiscountTax = BigDecimal.ZERO;
    private BigDecimal outterPrepayAmountWithTax = BigDecimal.ZERO;
    private BigDecimal outterPrepayAmountWithoutTax = BigDecimal.ZERO;
    private BigDecimal outterPrepayAmountTax = BigDecimal.ZERO;
    private BigDecimal innerPrepayAmountWithTax = BigDecimal.ZERO;
    private BigDecimal innerPrepayAmountWithoutTax = BigDecimal.ZERO;
    private BigDecimal innerPrepayAmountTax = BigDecimal.ZERO;
    private boolean flag;
    private BigDecimal balanceInvoiceAmount;

    public String getSalesbillItemId() {
        return this.salesbillItemId;
    }

    public void setSalesbillItemId(String billItemId) {
        this.salesbillItemId = billItemId;
    }

    public boolean getFlag() {
        return this.flag;
    }

    public void setFlag(boolean flag) {
        this.flag = flag;
    }

    public PriceMethod getPriceMethod() {
        return this.priceMethod;
    }

    public void setPriceMethod(PriceMethod priceMethod) {
        this.priceMethod = priceMethod;
    }

    public BigDecimal getQuantity() {
        return this.quantity;
    }

    public void setQuantity(BigDecimal quantity) {
        this.quantity = quantity;
    }

    public BigDecimal getUnitPrice() {
        return this.unitPrice;
    }

    public void setUnitPrice(BigDecimal unitPrice) {
        this.unitPrice = unitPrice;
    }

    public String getQuantityUnit() {
        return this.quantityUnit;
    }

    public void setQuantityUnit(String quantityUnit) {
        this.quantityUnit = quantityUnit;
    }

    public BigDecimal getTaxRate() {
        return this.taxRate;
    }

    public void setTaxRate(BigDecimal taxRate) {
        this.taxRate = taxRate;
    }

    public BigDecimal getAmountWithoutTax() {
        return this.amountWithoutTax;
    }

    public void setAmountWithoutTax(BigDecimal amountWithoutTax) {
        this.amountWithoutTax = amountWithoutTax;
    }

    public BigDecimal getTaxAmount() {
        return this.taxAmount;
    }

    public void setTaxAmount(BigDecimal taxAmount) {
        this.taxAmount = taxAmount;
    }

    public BigDecimal getAmountWithTax() {
        return this.amountWithTax;
    }

    public void setAmountWithTax(BigDecimal amountWithTax) {
        this.amountWithTax = amountWithTax;
    }

    public BigDecimal getDiscountWithoutTax() {
        return this.discountWithoutTax;
    }

    public void setDiscountWithoutTax(BigDecimal discountWithoutTax) {
        this.discountWithoutTax = discountWithoutTax;
    }

    public BigDecimal getDiscountTax() {
        return this.discountTax == null ? BigDecimal.ZERO : this.discountTax;
    }

    public void setDiscountTax(BigDecimal discountTax) {
        this.discountTax = discountTax;
    }

    public BigDecimal getDiscountWithTax() {
        return this.discountWithTax;
    }

    public void setDiscountWithTax(BigDecimal discountWithTax) {
        this.discountWithTax = discountWithTax;
    }

    public BigDecimal getDeductions() {
        return this.deductions;
    }

    public void setDeductions(BigDecimal deductions) {
        this.deductions = deductions;
    }

    public BigDecimal getOutterDiscountWithTax() {
        return this.outterDiscountWithTax;
    }

    public void setOutterDiscountWithTax(BigDecimal outterDiscountWithTax) {
        this.outterDiscountWithTax = outterDiscountWithTax;
    }

    public BigDecimal getOutterDiscountWithoutTax() {
        return this.outterDiscountWithoutTax;
    }

    public void setOutterDiscountWithoutTax(BigDecimal outterDiscountWithoutTax) {
        this.outterDiscountWithoutTax = outterDiscountWithoutTax;
    }

    public BigDecimal getOutterDiscountTax() {
        return this.outterDiscountTax;
    }

    public void setOutterDiscountTax(BigDecimal outterDiscountTax) {
        this.outterDiscountTax = outterDiscountTax;
    }

    public BigDecimal getInnerDiscountWithTax() {
        return this.innerDiscountWithTax;
    }

    public void setInnerDiscountWithTax(BigDecimal innerDiscountWithTax) {
        this.innerDiscountWithTax = innerDiscountWithTax;
    }

    public BigDecimal getInnerDiscountWithoutTax() {
        return this.innerDiscountWithoutTax;
    }

    public void setInnerDiscountWithoutTax(BigDecimal innerDiscountWithoutTax) {
        this.innerDiscountWithoutTax = innerDiscountWithoutTax;
    }

    public BigDecimal getInnerDiscountTax() {
        return this.innerDiscountTax;
    }

    public void setInnerDiscountTax(BigDecimal innerDiscountTax) {
        this.innerDiscountTax = innerDiscountTax;
    }

    public BigDecimal getOutterPrepayAmountWithTax() {
        return this.outterPrepayAmountWithTax;
    }

    public void setOutterPrepayAmountWithTax(BigDecimal outterPrepayAmountWithTax) {
        this.outterPrepayAmountWithTax = outterPrepayAmountWithTax;
    }

    public BigDecimal getOutterPrepayAmountWithoutTax() {
        return this.outterPrepayAmountWithoutTax;
    }

    public void setOutterPrepayAmountWithoutTax(BigDecimal outterPrepayAmountWithoutTax) {
        this.outterPrepayAmountWithoutTax = outterPrepayAmountWithoutTax;
    }

    public BigDecimal getOutterPrepayAmountTax() {
        return this.outterPrepayAmountTax;
    }

    public void setOutterPrepayAmountTax(BigDecimal outterPrepayAmountTax) {
        this.outterPrepayAmountTax = outterPrepayAmountTax;
    }

    public BigDecimal getInnerPrepayAmountWithTax() {
        return this.innerPrepayAmountWithTax;
    }

    public void setInnerPrepayAmountWithTax(BigDecimal innerPrepayAmountWithTax) {
        this.innerPrepayAmountWithTax = innerPrepayAmountWithTax;
    }

    public BigDecimal getInnerPrepayAmountWithoutTax() {
        return this.innerPrepayAmountWithoutTax;
    }

    public void setInnerPrepayAmountWithoutTax(BigDecimal innerPrepayAmountWithoutTax) {
        this.innerPrepayAmountWithoutTax = innerPrepayAmountWithoutTax;
    }

    public BigDecimal getInnerPrepayAmountTax() {
        return this.innerPrepayAmountTax;
    }

    public void setInnerPrepayAmountTax(BigDecimal innerPrepayAmountTax) {
        this.innerPrepayAmountTax = innerPrepayAmountTax;
    }

    public BigDecimal getBalanceInvoiceAmount() {
        return this.balanceInvoiceAmount;
    }

    public void setBalanceInvoiceAmount(BigDecimal balanceInvoiceAmount) {
        this.balanceInvoiceAmount = balanceInvoiceAmount;
    }

    public ItemAmountInfo createItemAmountByAmountWithoutTax(SplitRule rule, BigDecimal limitAmount) {
        ItemAmountInfo newItemAmountInfo = (ItemAmountInfo)JSON.parseObject((String)JSON.toJSONString((Object)this), ItemAmountInfo.class);
        BigDecimal splitRate = limitAmount.divide(this.amountWithoutTax.subtract(this.discountWithoutTax), 10, 1);
        if (splitRate.compareTo(MAX_SPLIT_RATE) > 0) {
            splitRate = MAX_SPLIT_RATE;
        }
        BigDecimal splitAmountWithoutTax = this.amountWithoutTax.multiply(splitRate).setScale(2, 4);
        newItemAmountInfo.setAmountWithoutTax(splitAmountWithoutTax);
        this.processUnitPriceAndQuantity(newItemAmountInfo, rule);
        splitRate = newItemAmountInfo.getAmountWithoutTax().divide(this.amountWithoutTax, 10, 1);
        splitAmountWithoutTax = newItemAmountInfo.getAmountWithoutTax();
        BigDecimal splitDeductions = this.deductions.multiply(splitRate).setScale(2, 1);
        BigDecimal splitTaxAmount = splitAmountWithoutTax.subtract(splitDeductions).multiply(this.taxRate).setScale(2, 1);
        BigDecimal splitAmountWithTax = splitAmountWithoutTax.add(splitTaxAmount);
        newItemAmountInfo.setAmountWithTax(splitAmountWithTax);
        newItemAmountInfo.setTaxAmount(splitTaxAmount);
        newItemAmountInfo.setDeductions(splitDeductions);
        this.splitDiscountByRateWithoutTax(newItemAmountInfo, splitRate);
        return newItemAmountInfo;
    }

    public ItemAmountInfo createItemAmountByAmountWithTax(SplitRule rule, BigDecimal limitAmount) {
        ItemAmountInfo newItemAmountInfo = (ItemAmountInfo)JSON.parseObject((String)JSON.toJSONString((Object)this), ItemAmountInfo.class);
        BigDecimal splitRate = limitAmount.divide(this.amountWithTax.subtract(this.discountWithTax), 20, 1);
        BigDecimal splitDiscountAmountWithTax = this.discountWithTax.multiply(splitRate).setScale(2, RoundingMode.HALF_UP);
        BigDecimal splitAmountWithTax = limitAmount.add(splitDiscountAmountWithTax).setScale(2, RoundingMode.HALF_UP);
        BigDecimal splitDeductions = this.deductions.multiply(splitRate).setScale(2, RoundingMode.HALF_UP);
        BigDecimal splitAmountWithoutTax = splitAmountWithTax.add(splitDeductions.multiply(this.taxRate)).divide(BigDecimal.ONE.add(this.taxRate), 2, RoundingMode.HALF_UP);
        BigDecimal splitTaxAmount = splitAmountWithTax.subtract(splitAmountWithoutTax);
        newItemAmountInfo.setAmountWithoutTax(splitAmountWithoutTax);
        this.processUnitPriceAndQuantity(newItemAmountInfo, rule);
        if (newItemAmountInfo.getAmountWithoutTax().compareTo(splitAmountWithoutTax) != 0) {
            splitTaxAmount = newItemAmountInfo.getAmountWithoutTax().subtract(splitDeductions).multiply(this.taxRate).setScale(2, RoundingMode.HALF_UP);
            splitAmountWithTax = newItemAmountInfo.getAmountWithoutTax().add(splitTaxAmount);
            if (splitDiscountAmountWithTax.compareTo(BigDecimal.ZERO) > 0) {
                if (splitAmountWithTax.compareTo(limitAmount) <= 0) {
                    throw new SplitBizException("\u6309\u7167\u6307\u5b9a\u542b\u7a0e\u91d1\u989d\u62c6\u5206\u65f6\u6298\u6263\u65e0\u6cd5\u62c6\u5206!");
                }
                splitDiscountAmountWithTax = splitAmountWithTax.subtract(limitAmount);
            } else {
                newItemAmountInfo.setFlag(true);
                this.logger.warn("\u5904\u7406\u5355\u4ef7\u6570\u91cf\u65f6\u4e0d\u542b\u7a0e\u91d1\u989d\u5df2\u6539\u53d8,\u5982\u679c\u6ca1\u6709\u6298\u6263\u5219\u4e0d\u80fd\u6309\u7167\u6307\u5b9a\u542b\u7a0e\u91d1\u989d\u62c6\u5206");
            }
        }
        newItemAmountInfo.setAmountWithTax(splitAmountWithTax);
        newItemAmountInfo.setTaxAmount(splitTaxAmount);
        newItemAmountInfo.setDeductions(splitDeductions);
        newItemAmountInfo.setDiscountWithTax(splitDiscountAmountWithTax);
        this.splitDiscountAmountByAmountWithTax(newItemAmountInfo);
        return newItemAmountInfo;
    }

    private void splitDiscountAmountByAmountWithTax(ItemAmountInfo newItemAmountInfo) {
        BigDecimal splitDiscountWithTax = newItemAmountInfo.getDiscountWithTax();
        if (splitDiscountWithTax.compareTo(BigDecimal.ZERO) > 0) {
            BigDecimal splitDiscountWithoutTax = splitDiscountWithTax.divide(BigDecimal.ONE.add(this.taxRate), 2, RoundingMode.HALF_UP);
            BigDecimal splitDiscountTax = splitDiscountWithTax.subtract(splitDiscountWithoutTax);
            newItemAmountInfo.setDiscountTax(splitDiscountTax);
            newItemAmountInfo.setDiscountWithoutTax(splitDiscountWithoutTax);
        }
    }

    private void processUnitPriceAndQuantity(ItemAmountInfo newItemAmountInfo, SplitRule rule) {
        int unitPriceScale = rule.getUnitPriceScale();
        if (AmountSplitRuleUtils.isQuantity(rule.getAmountSplitRule())) {
            newItemAmountInfo.calculateUnitPrice(unitPriceScale);
        } else if (AmountSplitRuleUtils.isUnitPriceAndQuantityInteger(rule.getAmountSplitRule()) || AmountSplitRuleUtils.recalculateQuantityRounding(rule.getAmountSplitRule())) {
            if (newItemAmountInfo.getUnitPrice().compareTo(BigDecimal.ZERO) > 0) {
                BigDecimal quantity = newItemAmountInfo.getAmountWithoutTax().divide(newItemAmountInfo.getUnitPrice(), 0, 1);
                if (quantity.compareTo(BigDecimal.ZERO) != 0) {
                    newItemAmountInfo.calculateQuantityAndQuantityInteger();
                } else {
                    newItemAmountInfo.calculateQuantity(unitPriceScale);
                }
            }
        } else if (AmountSplitRuleUtils.isUnitPrice(rule.getAmountSplitRule()) || AmountSplitRuleUtils.isUnitPriceAndRecalculateQuantity(rule.getAmountSplitRule())) {
            newItemAmountInfo.calculateQuantity(unitPriceScale);
        } else {
            throw new IllegalArgumentException(String.format("rule.amountSplitRule = [%s] is illegal!", rule.getAmountSplitRule()));
        }
    }

    public void deductNewItemAmount(ItemAmountInfo newItemAmountInfo) {
        this.amountWithoutTax = this.amountWithoutTax.subtract(newItemAmountInfo.getAmountWithoutTax());
        this.amountWithTax = this.amountWithTax.subtract(newItemAmountInfo.getAmountWithTax());
        this.taxAmount = this.taxAmount.subtract(newItemAmountInfo.getTaxAmount());
        this.deductions = this.deductions.subtract(newItemAmountInfo.getDeductions());
        this.discountTax = this.discountTax.subtract(newItemAmountInfo.getDiscountTax());
        this.discountWithoutTax = this.discountWithoutTax.subtract(newItemAmountInfo.getDiscountWithoutTax());
        this.discountWithTax = this.discountWithTax.subtract(newItemAmountInfo.getDiscountWithTax());
    }

    private void splitDiscountByRateWithoutTax(ItemAmountInfo newItemAmountInfo, BigDecimal splitRate) {
        BigDecimal discountWithoutTax = this.discountWithoutTax.multiply(splitRate).setScale(2, RoundingMode.UP);
        BigDecimal discountTax = discountWithoutTax.multiply(this.taxRate).setScale(2, 1);
        BigDecimal discountWithTax = discountWithoutTax.add(discountTax);
        newItemAmountInfo.setDiscountWithTax(discountWithTax);
        newItemAmountInfo.setDiscountTax(discountTax);
        newItemAmountInfo.setDiscountWithoutTax(discountWithoutTax);
    }

    private void bwSplitDiscountByRateWithoutTax(ItemAmountInfo newItemAmountInfo, BigDecimal splitRate) {
        BigDecimal discountWithoutTax = this.discountWithoutTax.multiply(splitRate).setScale(2, RoundingMode.UP);
        BigDecimal discountTax = discountWithoutTax.multiply(this.taxRate).setScale(2, RoundingMode.HALF_DOWN);
        BigDecimal discountWithTax = discountWithoutTax.add(discountTax);
        newItemAmountInfo.setDiscountWithTax(discountWithTax);
        newItemAmountInfo.setDiscountTax(discountTax);
        newItemAmountInfo.setDiscountWithoutTax(discountWithoutTax);
    }

    private void calculateQuantityAndQuantityInteger() {
        if (this.unitPrice.compareTo(BigDecimal.ZERO) > 0) {
            this.quantity = this.amountWithoutTax.divide(this.unitPrice, 0, 1);
            if (this.quantity.compareTo(BigDecimal.ZERO) != 0) {
                this.amountWithoutTax = this.quantity.multiply(this.unitPrice).setScale(2, 4);
            }
        }
    }

    private void calculateUnitPrice(int unitPriceScale) {
        if (this.quantity.compareTo(BigDecimal.ZERO) > 0) {
            this.unitPrice = this.amountWithoutTax.divide(this.quantity, unitPriceScale, 1);
            this.amountWithoutTax = this.quantity.multiply(this.unitPrice).setScale(2, 4);
        }
    }

    private void calculateQuantity(int unitPriceScale) {
        if (this.unitPrice.compareTo(BigDecimal.ZERO) > 0) {
            this.quantity = this.amountWithoutTax.divide(this.unitPrice, 6, 1);
            BigDecimal newAmountWithoutTax = this.quantity.multiply(this.unitPrice).setScale(2, 4);
            if (newAmountWithoutTax.compareTo(this.amountWithoutTax) < 0) {
                if (this.quantity.compareTo(BigDecimal.ZERO) == 0) {
                    this.quantity = MIN_QUANTITY;
                    this.unitPrice = this.amountWithoutTax.divide(this.quantity, unitPriceScale, 4);
                } else {
                    this.amountWithoutTax = newAmountWithoutTax;
                }
            }
        }
    }

    public ItemAmountInfo bwCreateItemAmountByAmountWithoutTax(SplitRule rule, BigDecimal limitAmount) {
        ItemAmountInfo newItemAmountInfo = (ItemAmountInfo)JSON.parseObject((String)JSON.toJSONString((Object)this), ItemAmountInfo.class);
        BigDecimal splitRate = limitAmount.divide(this.amountWithoutTax.subtract(this.discountWithoutTax), 10, RoundingMode.DOWN);
        if (splitRate.compareTo(MAX_SPLIT_RATE) > 0) {
            splitRate = MAX_SPLIT_RATE;
        }
        BigDecimal splitAmountWithoutTax = this.amountWithoutTax.multiply(splitRate).setScale(2, RoundingMode.HALF_UP);
        newItemAmountInfo.setAmountWithoutTax(splitAmountWithoutTax);
        this.bwProcessUnitPriceAndQuantity(newItemAmountInfo, rule);
        splitRate = newItemAmountInfo.getAmountWithoutTax().divide(this.amountWithoutTax, 10, RoundingMode.HALF_DOWN);
        splitAmountWithoutTax = newItemAmountInfo.getAmountWithoutTax();
        BigDecimal splitDeductions = this.deductions.multiply(splitRate).setScale(2, RoundingMode.DOWN);
        BigDecimal splitTaxAmount = splitAmountWithoutTax.subtract(splitDeductions).multiply(this.taxRate).setScale(2, RoundingMode.HALF_DOWN);
        BigDecimal splitAmountWithTax = splitAmountWithoutTax.add(splitTaxAmount);
        newItemAmountInfo.setAmountWithTax(splitAmountWithTax);
        newItemAmountInfo.setTaxAmount(splitTaxAmount);
        newItemAmountInfo.setDeductions(splitDeductions);
        this.bwSplitDiscountByRateWithoutTax(newItemAmountInfo, splitRate);
        return newItemAmountInfo;
    }

    private void bwProcessUnitPriceAndQuantity(ItemAmountInfo newItemAmountInfo, SplitRule rule) {
        int unitPriceScale = rule.getUnitPriceScale();
        if (AmountSplitRuleUtils.isQuantity(rule.getAmountSplitRule())) {
            newItemAmountInfo.calculateUnitPrice(unitPriceScale);
        } else if (AmountSplitRuleUtils.isUnitPriceAndQuantityInteger(rule.getAmountSplitRule()) || AmountSplitRuleUtils.recalculateQuantityRounding(rule.getAmountSplitRule())) {
            if (newItemAmountInfo.getUnitPrice().compareTo(BigDecimal.ZERO) > 0) {
                BigDecimal quantity = newItemAmountInfo.getAmountWithoutTax().divide(newItemAmountInfo.getUnitPrice(), 0, 1);
                if (quantity.compareTo(BigDecimal.ZERO) != 0) {
                    newItemAmountInfo.calculateQuantityAndQuantityInteger();
                } else {
                    newItemAmountInfo.calculateQuantity(unitPriceScale);
                }
            }
        } else if (AmountSplitRuleUtils.isUnitPrice(rule.getAmountSplitRule()) || AmountSplitRuleUtils.isUnitPriceAndRecalculateQuantity(rule.getAmountSplitRule())) {
            newItemAmountInfo.bwCalculateQuantity(rule.getInvoiceLimit());
        } else {
            throw new IllegalArgumentException(String.format("rule.amountSplitRule = [%s] is illegal!", rule.getAmountSplitRule()));
        }
    }

    private void bwCalculateQuantity(BigDecimal limite) {
        if (this.unitPrice.compareTo(BigDecimal.ZERO) > 0) {
            this.quantity = this.amountWithoutTax.divide(this.unitPrice, 6, RoundingMode.DOWN);
            if (this.quantity.compareTo(BigDecimal.ZERO) == 0) {
                throw new IllegalArgumentException(String.format("\u9650\u989d[%s] \u5355\u4ef7 [%s],\u65e0\u6cd5\u4fdd\u8bc1\u6570\u91cf\u5c0f\u6570\u4f4d6\u4f4d !", limite, this.unitPrice));
            }
            BigDecimal newAmountWithoutTax = this.quantity.multiply(this.unitPrice).setScale(2, RoundingMode.HALF_UP);
            if (newAmountWithoutTax.compareTo(this.amountWithoutTax) < 0) {
                this.amountWithoutTax = newAmountWithoutTax;
            }
        }
    }

    public String toString() {
        return JSON.toJSONString((Object)this);
    }
}

