/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.phoenix.split.service;

import com.google.common.collect.Sets;
import com.xforceplus.phoenix.split.constant.InvoiceType;
import com.xforceplus.phoenix.split.constant.SaleListOptionEnum;
import com.xforceplus.phoenix.split.constant.TaxInvoiceSourceEnum;
import com.xforceplus.phoenix.split.exception.SplitBizException;
import com.xforceplus.phoenix.split.model.BillInfo;
import com.xforceplus.phoenix.split.model.SplitRule;
import com.xforceplus.phoenix.split.service.SplitRuleUtil;
import java.math.BigDecimal;
import java.util.Set;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
public class SplitRuleService {
    @Value(value="${split.invoice.count.limit.each:1000}")
    private int splitInvoiceCount = 1000;
    @Value(value="#{'${config.remark.concat.comma.tenantIds}'.split(',')}")
    private Set<String> remarkCommaTenantIds;
    @Value(value="#{'${config.remark.remove.duplicate.tenantIds}'.split(',')}")
    private Set<String> remarkRemovalDuplicateTenantIds;
    @Value(value="#{'${config.ignore.item.tax-code.tenantIds}'.split(',')}")
    private Set<String> ignoreItemTaxCodeTenantIds = Sets.newHashSet((Object[])new String[]{"111"});
    @Value(value="#{'${config.ignore.item.tax-code.appIds}'.split(',')}")
    private Set<String> ignoreItemTaxCodeAppIds = Sets.newHashSet((Object[])new String[]{"20"});
    @Value(value="#{'${config.remove.item-name-illegal-character.tenantIds}'.split(',')}")
    private Set<String> removeItemNameIllegalCharacter = Sets.newHashSet((Object[])new String[]{"111"});

    public void preHandle(Long tenantId, long appId, BillInfo billInfo, SplitRule rule) {
        this.initializeSplitRule(tenantId, appId, rule, billInfo);
        SplitRuleUtil.validateSplitRule(rule);
        this.validateSplitCount(billInfo, rule);
    }

    private void initializeSplitRule(Long tenantId, long appId, SplitRule rule, BillInfo billInfo) {
        this.initializeTaxInvoiceSource(rule);
        this.initializeInvoiceMaxRow(rule, billInfo);
        this.initializeSaleListOption(rule, billInfo);
        this.initializeRemarkSeparator(tenantId, rule);
        this.initializeBillItemValidation(tenantId, appId, rule);
        this.initializeBillItemIllegalCharacterRemoval(tenantId, rule);
        this.initializeSplitAsyncMiddleWare(appId, rule);
    }

    public void initializeSplitAsyncMiddleWare(long appId, SplitRule rule) {
    }

    public void initializeBillItemIllegalCharacterRemoval(Long tenantId, SplitRule rule) {
        if (this.removeItemNameIllegalCharacter.contains(String.valueOf(tenantId))) {
            rule.setRemoveIllegalItemNameCharacter(true);
        }
    }

    public void initializeBillItemValidation(Long tenantId, long appId, SplitRule rule) {
        if (this.ignoreItemTaxCodeTenantIds.contains(String.valueOf(tenantId)) || this.ignoreItemTaxCodeAppIds.contains(String.valueOf(appId))) {
            rule.setIgnoreBillItemShortName(true);
            rule.setIgnoreBillItemName(true);
            rule.setIgnoreBillItemTaxRate(true);
            rule.setIgnoreBillItemGoodsTaxNo(true);
        }
    }

    public void initializeRemarkSeparator(Long tenantId, SplitRule rule) {
        if (!CollectionUtils.isEmpty(this.remarkCommaTenantIds) && this.remarkCommaTenantIds.contains(String.valueOf(tenantId))) {
            rule.setCargoNameSeparatorType(Integer.valueOf(2));
        }
        if (!CollectionUtils.isEmpty(this.remarkRemovalDuplicateTenantIds) && this.remarkRemovalDuplicateTenantIds.contains(String.valueOf(tenantId))) {
            rule.setRemoveRemarkItemDuplicate(true);
        }
    }

    public void initializeInvoiceMaxRow(SplitRule rule, BillInfo billInfo) {
        String taxInvoiceSource = rule.getTaxInvoiceSource();
        Integer invoiceItemMaxRow = rule.getInvoiceItemMaxRow();
        if (TaxInvoiceSourceEnum.QD.getValue().equals(taxInvoiceSource) && !InvoiceType.isAllElectronicNormalInvoice(billInfo.getInvoiceType())) {
            rule.setInvoiceItemMaxRow(Integer.valueOf(invoiceItemMaxRow == null || invoiceItemMaxRow == 0 ? 2000 : invoiceItemMaxRow));
        }
    }

    public void initializeTaxInvoiceSource(SplitRule rule) {
        String taxInvoiceSource = rule.getTaxInvoiceSource();
        rule.setTaxInvoiceSource(StringUtils.isEmpty((Object)taxInvoiceSource) ? "sk" : taxInvoiceSource);
    }

    public void initializeSaleListOption(SplitRule rule, BillInfo billInfo) {
        String taxInvoiceSource = rule.getTaxInvoiceSource();
        Integer invoiceItemMaxRow = rule.getInvoiceItemMaxRow();
        String saleListOption = rule.getSaleListOption();
        Integer salesListMaxRow = rule.getSalesListMaxRow();
        if (TaxInvoiceSourceEnum.QD.getValue().equals(taxInvoiceSource) && !InvoiceType.isAllElectronicNormalInvoice(billInfo.getInvoiceType())) {
            rule.setSaleListOption(StringUtils.isEmpty((Object)saleListOption) ? SaleListOptionEnum.ENABLE_LIST_OPTION.getValue() : saleListOption);
            rule.setSalesListMaxRow(salesListMaxRow == null || salesListMaxRow == 0 ? invoiceItemMaxRow : salesListMaxRow);
        }
    }

    public void validateSplitCount(BillInfo billInfo, SplitRule rule) {
        int splitCountAbs;
        boolean limitIsAmountWithTax = rule.isLimitIsAmountWithTax();
        BigDecimal totalSplitAmount = limitIsAmountWithTax ? billInfo.getAmountWithTax() : billInfo.getAmountWithoutTax();
        int splitCount = totalSplitAmount.divide(rule.getInvoiceLimit(), 0, 4).intValue();
        int n = splitCountAbs = splitCount < 0 ? -splitCount : splitCount;
        if (splitCountAbs > this.splitInvoiceCount) {
            throw new SplitBizException(String.format("\u9884\u4f30\u5355\u6b21\u62c6\u5206\u9884\u5236\u53d1\u7968\u6570\u91cf\u8fbe\u5230[%s]\u8d85\u8fc7\u9650\u5236\u6570\u91cf[%s]", splitCountAbs, this.splitInvoiceCount));
        }
    }
}

