/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.phoenix.split.service.dataflow.impl;

import com.xforceplus.phoenix.split.constant.RemarkConstant;
import com.xforceplus.phoenix.split.constant.TaxDeviceType;
import com.xforceplus.phoenix.split.domain.ItemGroup;
import com.xforceplus.phoenix.split.domain.RuleInfo;
import com.xforceplus.phoenix.split.exception.SplitBizException;
import com.xforceplus.phoenix.split.model.BillInfo;
import com.xforceplus.phoenix.split.model.BillItem;
import com.xforceplus.phoenix.split.model.FieldOfObj;
import com.xforceplus.phoenix.split.model.RemarkFieldMetadata;
import com.xforceplus.phoenix.split.service.dataflow.DataProcessPlugin;
import com.xforceplus.phoenix.split.util.CommonTools;
import com.xforceplus.phoenix.split.util.FieldUtils;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.ibatis.reflection.ReflectionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Component
public class FieldProcessPlugin
implements DataProcessPlugin {
    private Logger logger = LoggerFactory.getLogger(FieldProcessPlugin.class);
    @Value(value="${cargoNameLengthLimit:100}")
    private int cargoNameLengthLimit;
    @Value(value="${cargoNameLengthLimit:40}")
    private int itemSpecNameLengthLimit;
    private static final Charset GBK = Charset.forName("GBK");

    @Override
    public List<ItemGroup> processData(List<ItemGroup> itemGroups, BillInfo billInfo, RuleInfo ruleInfo) {
        List cargoNameFieldMetadatas = ruleInfo.getSplitRule().getCargoNameFiledMetadatas();
        List itemSpecFieldMetadatas = ruleInfo.getSplitRule().getItemSpecFiledMetadatas();
        Integer cargoNameSeparatorType = ruleInfo.getSplitRule().getCargoNameSeparatorType();
        if (CollectionUtils.isEmpty((Collection)cargoNameFieldMetadatas) && CollectionUtils.isEmpty((Collection)itemSpecFieldMetadatas)) {
            return itemGroups;
        }
        int itemSpecNameLengthLimit = ruleInfo.getSplitRule().getItemSpecNameLength() == null ? this.itemSpecNameLengthLimit : Math.min(ruleInfo.getSplitRule().getItemSpecNameLength(), this.itemSpecNameLengthLimit);
        for (ItemGroup itemGroup : itemGroups) {
            this.setValue(billInfo, cargoNameFieldMetadatas, itemSpecFieldMetadatas, itemSpecNameLengthLimit, itemGroup, cargoNameSeparatorType);
        }
        return itemGroups;
    }

    @Override
    public List<ItemGroup> processData(List<ItemGroup> itemGroups, BillInfo billInfo, RuleInfo ruleInfo, TaxDeviceType taxDeviceType) {
        return this.processData(itemGroups, billInfo, ruleInfo);
    }

    protected void setValue(BillInfo billInfo, List<RemarkFieldMetadata> cargoNameFieldMetadatas, List<RemarkFieldMetadata> itemSpecFieldMetadatas, int itemSpecNameLengthLimit, ItemGroup itemGroup, Integer cargoNameSeparatorType) {
        for (BillItem billItem : itemGroup.getBillItems()) {
            String itemSpecName;
            String joinName = cargoNameSeparatorType != null ? this.parseFieldValue(cargoNameFieldMetadatas, billInfo, billItem, cargoNameSeparatorType) : this.parseFieldValue(cargoNameFieldMetadatas, billInfo, billItem);
            if (StringUtils.hasText((String)joinName)) {
                billItem.setJoinName(joinName);
            }
            if (this.gtLimit(itemSpecName = this.parseFieldValue(itemSpecFieldMetadatas, billInfo, billItem), itemSpecNameLengthLimit)) {
                itemSpecName = CommonTools.substring(itemSpecName, itemSpecNameLengthLimit, GBK);
            }
            if (!StringUtils.hasText((String)itemSpecName)) continue;
            billItem.setItemSpec(itemSpecName);
        }
    }

    protected String parseFieldValue(List<RemarkFieldMetadata> fieldMetaDatas, BillInfo billInfo, BillItem billItem, Integer cargoNameSeparatorType) {
        if (CollectionUtils.isEmpty(fieldMetaDatas)) {
            return "";
        }
        ArrayList<String> values = new ArrayList<String>();
        for (int i = 0; i < fieldMetaDatas.size(); ++i) {
            RemarkFieldMetadata fieldMetadata = fieldMetaDatas.get(i);
            String fieldName = fieldMetadata.getFieldName();
            BillInfo obj = null;
            if (this.isBillInfoField(fieldMetadata)) {
                obj = billInfo;
            }
            if (this.isBillItemField(fieldMetadata)) {
                obj = billItem;
            }
            if (obj == null) {
                throw new SplitBizException("fieldGroupIndex value is illegal!");
            }
            String fieldValue = this.getCustomFieldValue(obj, fieldName);
            values.add(fieldValue);
        }
        String result = values.stream().filter(e -> !StringUtils.isEmpty((Object)e)).collect(Collectors.joining(this.concatSeparator(cargoNameSeparatorType)));
        return result;
    }

    protected String parseFieldValue(List<RemarkFieldMetadata> cargoNameFieldMetadatas, BillInfo billInfo, BillItem billItem) {
        if (CollectionUtils.isEmpty(cargoNameFieldMetadatas)) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        for (RemarkFieldMetadata fieldMetadata : cargoNameFieldMetadatas) {
            String fieldName = fieldMetadata.getFieldName();
            BillInfo obj = null;
            if (this.isBillInfoField(fieldMetadata)) {
                obj = billInfo;
            }
            if (this.isBillItemField(fieldMetadata)) {
                obj = billItem;
            }
            if (obj == null) {
                throw new SplitBizException("fieldGroupIndex value is illegal!");
            }
            Object fieldValue = null;
            try {
                fieldValue = FieldUtils.getFieldValue((Object)obj, fieldName);
            }
            catch (ReflectionException ignore) {
                this.logger.warn(String.format("field = [%s] not found from obj = [%s]!", fieldName, obj.getClass()));
            }
            sb.append(Objects.toString(fieldValue, ""));
        }
        return sb.toString();
    }

    protected String getCustomFieldValue(Object object, String fieldName) {
        String text = "";
        if (object instanceof BillItem) {
            text = "\u660e\u7ec6\u4fe1\u606f";
        } else if (object instanceof BillInfo) {
            text = "\u4e3b\u4fe1\u606f";
        }
        try {
            return Objects.toString(FieldUtils.getFieldValue(object, fieldName), "");
        }
        catch (ReflectionException e) {
            this.logger.warn("\u5143\u6570\u636e\u83b7\u53d6{}\u5b57\u6bb5\u503c\u9519\u8bef:{}", (Object)text, (Object)e.getMessage());
            return "";
        }
    }

    private CharSequence concatSeparator(Integer cargoNameSeparatorType) {
        String delimiter = "";
        if (cargoNameSeparatorType != null) {
            switch (cargoNameSeparatorType) {
                case 0: {
                    delimiter = RemarkConstant.SPACE;
                    break;
                }
                case 1: {
                    delimiter = RemarkConstant.TAB;
                    break;
                }
                case 2: {
                    delimiter = RemarkConstant.COMMA;
                }
            }
        }
        return delimiter;
    }

    private boolean gtLimit(String str, int lengthLimit) {
        return str.getBytes(GBK).length > lengthLimit;
    }

    private boolean isBillItemField(RemarkFieldMetadata remarkFieldMetadata) {
        return remarkFieldMetadata.getFieldGroupIndex() == FieldOfObj.BILL_ITEM;
    }

    private boolean isBillInfoField(RemarkFieldMetadata remarkFieldMetadata) {
        return remarkFieldMetadata.getFieldGroupIndex() == FieldOfObj.BILL_INFO;
    }

    public void setCargoNameLengthLimit(int cargoNameLengthLimit) {
        this.cargoNameLengthLimit = cargoNameLengthLimit;
    }

    public void setItemSpecNameLengthLimit(int itemSpecNameLengthLimit) {
        this.itemSpecNameLengthLimit = itemSpecNameLengthLimit;
    }
}

