/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.phoenix.split.service.dataflow.impl;

import com.google.common.collect.Lists;
import com.xforceplus.phoenix.split.constant.ErrorAmountPolicyEnum;
import com.xforceplus.phoenix.split.constant.InvoiceItemOrder;
import com.xforceplus.phoenix.split.constant.TaxDeviceType;
import com.xforceplus.phoenix.split.constant.TaxInvoiceSourceEnum;
import com.xforceplus.phoenix.split.domain.ItemGroup;
import com.xforceplus.phoenix.split.domain.RuleInfo;
import com.xforceplus.phoenix.split.domain.SplitGroupLimit;
import com.xforceplus.phoenix.split.exception.SplitBizException;
import com.xforceplus.phoenix.split.exception.SplitRuleParamException;
import com.xforceplus.phoenix.split.model.BillInfo;
import com.xforceplus.phoenix.split.model.BillItem;
import com.xforceplus.phoenix.split.model.ItemTypeCodeEnum;
import com.xforceplus.phoenix.split.model.SplitRule;
import com.xforceplus.phoenix.split.service.SplitRuleUtil;
import com.xforceplus.phoenix.split.service.dataflow.DataProcessPlugin;
import com.xforceplus.phoenix.split.service.dataflow.SpecialInvoiceService;
import com.xforceplus.phoenix.split.service.dataflow.impl.MinPackagePlugin2;
import com.xforceplus.phoenix.split.util.BillItemUtils;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class InvoiceLimitProcessPlugin
implements DataProcessPlugin {
    private static final Logger logger = LoggerFactory.getLogger(InvoiceLimitProcessPlugin.class);
    public static final String ERROR_AMOUNT = "0.01";
    @Value(value="${split.invoice.count.limit.each:1000}")
    private int splitInvoiceCount = 1000;
    @Value(value="#{${invoiceMaxErrorAmountPolicy}}")
    private Map<String, BigDecimal> invoiceMaxErrorAmountPolicy;
    @Autowired
    private MinPackagePlugin2 minPackagePlugin;
    @Value(value="#{${calculationConfig}}")
    private Map<String, String> calculationConfig;
    @Autowired
    private SpecialInvoiceService specialInvoiceService;

    @Override
    public List<ItemGroup> processData(List<ItemGroup> itemGroups, BillInfo billInfo, RuleInfo rule) {
        return this.processData(itemGroups, billInfo, rule, TaxDeviceType.HX_SINGL);
    }

    @Override
    public List<ItemGroup> processData(List<ItemGroup> itemGroups, BillInfo billInfo, RuleInfo rule, TaxDeviceType taxDeviceType) {
        SplitRule splitRule = rule.getSplitRule();
        SplitRuleUtil.validateSplitRule(splitRule);
        ArrayList allItemGroups = Lists.newArrayListWithExpectedSize((int)itemGroups.size());
        for (ItemGroup itemGroup : itemGroups) {
            this.assembleBillItems(allItemGroups, itemGroup, billInfo, splitRule, taxDeviceType);
            if (allItemGroups.size() <= this.splitInvoiceCount) continue;
            throw new SplitBizException("\u9884\u4f30\u5355\u6b21\u62c6\u5206\u9884\u5236\u53d1\u7968\u6570\u91cf\u8d85\u8fc7\u9650\u5236\u6570\u91cf:" + this.splitInvoiceCount);
        }
        return allItemGroups;
    }

    private void assembleBillItems(List<ItemGroup> allItemGroups, ItemGroup itemGroup, BillInfo billInfo, SplitRule splitRule, TaxDeviceType taxDeviceType) {
        List<BillItem> specialBillItems;
        List<BillItem> wholeBillItems = itemGroup.getBillItems();
        String invoiceOfGroupKey = UUID.randomUUID().toString();
        String itemTypeCode = wholeBillItems.get(0).getItemTypeCode();
        String taxInvoiceSource = splitRule.getTaxInvoiceSource();
        if (TaxInvoiceSourceEnum.QD.getValue().equals(taxInvoiceSource) && CollectionUtils.isNotEmpty(specialBillItems = wholeBillItems.stream().filter(e -> ItemTypeCodeEnum.isAllElectronicSpecialInvoice((String)e.getItemTypeCode())).collect(Collectors.toList()))) {
            logger.info("InvoiceLimitProcessPlugin.processData.assembleSpecialItems.billItems:{}", specialBillItems);
            allItemGroups.addAll(this.specialInvoiceService.assembleItems(splitRule, itemGroup, billInfo, specialBillItems));
            wholeBillItems.removeAll(specialBillItems);
            itemGroup.setBillItems(wholeBillItems);
        }
        if (CollectionUtils.isEmpty(wholeBillItems)) {
            return;
        }
        SplitGroupLimit splitGroupLimit = SplitRuleUtil.createSplitGroupLimit(splitRule, itemTypeCode, billInfo, wholeBillItems.get(0));
        BigDecimal defaultErrorAmount = this.getMaxErrorAmountByTaxDeviceType(taxDeviceType, splitRule);
        if (InvoiceItemOrder.ITEM_NO_ORDER == splitGroupLimit.getInvoiceItemOrder() || InvoiceItemOrder.ITEM_NO_MINIMUM_INVOICES == splitGroupLimit.getInvoiceItemOrder()) {
            splitGroupLimit.setInvoiceItemOrder(InvoiceItemOrder.ITEM_NO_ORDER);
            allItemGroups.addAll(this.orderSplitItemGroup(itemGroup, splitGroupLimit, invoiceOfGroupKey, taxDeviceType, splitRule));
        } else if (InvoiceItemOrder.MINIMUM_INVOICES == splitGroupLimit.getInvoiceItemOrder()) {
            splitGroupLimit.setInvoiceItemOrder(InvoiceItemOrder.MINIMUM_INVOICES);
            boolean isNegative = itemGroup.getBillItems().stream().anyMatch(item -> item.getAmountWithTax().compareTo(BigDecimal.ZERO) <= 0);
            if (!isNegative && Objects.nonNull(splitGroupLimit.getInvoiceMaxErrorAmount()) && defaultErrorAmount.compareTo(splitGroupLimit.getInvoiceMaxErrorAmount()) != 0) {
                allItemGroups.addAll(this.miniPlugin(itemGroup, splitGroupLimit, invoiceOfGroupKey, taxDeviceType));
            } else {
                allItemGroups.addAll(this.leastSplitItemGroup(itemGroup, splitGroupLimit, invoiceOfGroupKey, taxDeviceType, splitRule));
            }
        } else {
            throw new SplitRuleParamException("\u53d1\u7968\u660e\u7ec6\u987a\u5e8f\u89c4\u5219\u6709\u8bef");
        }
    }

    protected BigDecimal getMaxErrorAmountByTaxDeviceType(TaxDeviceType taxDeviceType, SplitRule splitRule) {
        boolean isQdSpecialAddition = splitRule.isEnableAdvancedValidation();
        if (isQdSpecialAddition) {
            logger.info("isQdSpecialAddition policyBigDecimal:1.27");
            return BigDecimal.valueOf(1.27);
        }
        BigDecimal policyBigDecimal = this.invoiceMaxErrorAmountPolicy != null && this.invoiceMaxErrorAmountPolicy.containsKey(taxDeviceType.getCode()) ? this.invoiceMaxErrorAmountPolicy.get(taxDeviceType.getCode()) : BigDecimal.valueOf(1.26);
        logger.info("policyBigDecimal:{}", (Object)policyBigDecimal);
        return policyBigDecimal;
    }

    private List<ItemGroup> orderSplitItemGroup(ItemGroup itemGroup, SplitGroupLimit splitGroupLimit, String invoiceOfGroupKey, TaxDeviceType taxDeviceType, SplitRule splitRule) {
        LinkedList processedItemGroups = Lists.newLinkedList();
        logger.debug("itemGroup.getBillItems size:{}", (Object)itemGroup.getBillItems().size());
        while (CollectionUtils.isNotEmpty(itemGroup.getBillItems())) {
            List<BillItem> processedItemList = this.splitByAmountAndLineLimit(itemGroup.getBillItems(), splitGroupLimit, taxDeviceType, splitRule);
            if (CollectionUtils.isEmpty(processedItemList)) {
                throw new SplitBizException("\u8bf7\u68c0\u67e5\u62c6\u7968\u89c4\u5219\u7684\u914d\u7f6e\u662f\u5426\u6b63\u786e");
            }
            ItemGroup processedItemGroup = new ItemGroup(itemGroup.getParentGroupFlag());
            processedItemGroup.setInvoiceOfGroupKey(invoiceOfGroupKey);
            processedItemGroup.setBillItems(processedItemList);
            processedItemGroups.add(processedItemGroup);
        }
        return processedItemGroups;
    }

    private List<ItemGroup> miniPlugin(ItemGroup itemGroup, SplitGroupLimit splitGroupLimit, String invoiceOfGroupKey, TaxDeviceType taxDeviceType) {
        LinkedList processedItemGroups = Lists.newLinkedList();
        List<List<BillItem>> result = this.minPackagePlugin.processData(itemGroup.getBillItems(), splitGroupLimit.getLimitAmount(), splitGroupLimit.getInvoiceMaxErrorAmount(), splitGroupLimit.isLimitIsAmountWithTax());
        if (CollectionUtils.isNotEmpty(result)) {
            for (List<BillItem> processedItemList : result) {
                ItemGroup processedItemGroup = new ItemGroup(itemGroup.getParentGroupFlag());
                processedItemGroup.setInvoiceOfGroupKey(invoiceOfGroupKey);
                processedItemGroup.setBillItems(processedItemList);
                processedItemGroups.add(processedItemGroup);
            }
            return processedItemGroups;
        }
        return Collections.EMPTY_LIST;
    }

    private List<ItemGroup> leastSplitItemGroup(ItemGroup itemGroup, SplitGroupLimit splitGroupLimit, String invoiceOfGroupKey, TaxDeviceType taxDeviceType, SplitRule splitRule) {
        LinkedList allItemGroups = Lists.newLinkedList();
        List<BillItem> billItems = itemGroup.getBillItems();
        Map<Boolean, List<BillItem>> isSplitItemMap = billItems.stream().collect(Collectors.groupingBy(BillItem::isSplitItem));
        List<Object> processItems = new LinkedList<BillItem>();
        List<BillItem> isNotSplitBillItems = isSplitItemMap.get(false);
        if (CollectionUtils.isNotEmpty(isNotSplitBillItems)) {
            processItems.addAll(isNotSplitBillItems);
        }
        List<BillItem> isSplitBillItems = isSplitItemMap.get(true);
        LinkedList noNeedProcessItems = Lists.newLinkedList();
        if (CollectionUtils.isNotEmpty(isSplitBillItems)) {
            Map<String, List<BillItem>> billIdItemsMap = isSplitBillItems.stream().collect(Collectors.groupingBy(BillItem::getSalesbillItemId));
            for (Map.Entry<String, List<BillItem>> entry : billIdItemsMap.entrySet()) {
                List<BillItem> items = entry.getValue();
                BillItem item = BillItemUtils.findMinAmountBillItem(items);
                items.remove(item);
                processItems.add(item);
                noNeedProcessItems.addAll(items);
            }
            for (BillItem billItem : noNeedProcessItems) {
                ItemGroup notNeedProcessItemGroup = new ItemGroup(itemGroup.getParentGroupFlag());
                notNeedProcessItemGroup.setInvoiceOfGroupKey(invoiceOfGroupKey);
                notNeedProcessItemGroup.setBillItems(Lists.newArrayList((Object[])new BillItem[]{billItem}));
                allItemGroups.add(notNeedProcessItemGroup);
            }
        }
        if (CollectionUtils.isNotEmpty(processItems)) {
            processItems = processItems.stream().sorted(((Comparator)(o1, o2) -> {
                BigDecimal value1 = this.actualAmount((BillItem)o1, splitGroupLimit.isLimitIsAmountWithTax());
                BigDecimal value2 = this.actualAmount((BillItem)o2, splitGroupLimit.isLimitIsAmountWithTax());
                return value1.compareTo(value2);
            }).reversed()).collect(Collectors.toList());
            logger.debug("itemGroup.processItems size:{}", (Object)processItems.size());
            List<List<BillItem>> invoices = this.minInvoice(processItems, splitGroupLimit, taxDeviceType, splitRule);
            for (List list : invoices) {
                ItemGroup newItemGroup = new ItemGroup(itemGroup.getParentGroupFlag());
                newItemGroup.setInvoiceOfGroupKey(invoiceOfGroupKey);
                newItemGroup.setBillItems(list);
                allItemGroups.add(newItemGroup);
            }
        }
        return allItemGroups;
    }

    protected List<List<BillItem>> minInvoice(List<BillItem> processItems, SplitGroupLimit splitGroupLimit, TaxDeviceType taxDeviceType, SplitRule splitRule) {
        ArrayList<List<BillItem>> result = new ArrayList<List<BillItem>>();
        while (processItems.size() > 0) {
            List<BillItem> processedItemList = this.splitByAmountAndLineLimit(processItems, splitGroupLimit, taxDeviceType, splitRule);
            if (processedItemList.size() == 0) {
                throw new SplitBizException("\u8bf7\u68c0\u67e5\u62c6\u7968\u89c4\u5219\u7684\u914d\u7f6e\u662f\u5426\u6b63\u786e");
            }
            result.add(processedItemList);
        }
        return result;
    }

    protected BigDecimal actualAmount(BillItem item, boolean limitIsAmountWithTax) {
        BigDecimal result = limitIsAmountWithTax ? item.getAmountWithTax().subtract(item.getDiscountWithTax()) : item.getAmountWithoutTax().subtract(item.getDiscountWithoutTax());
        return result;
    }

    protected List<BillItem> splitByAmountAndLineLimit(List<BillItem> billItems, SplitGroupLimit splitGroupLimit, TaxDeviceType taxDeviceType, SplitRule splitRule) {
        logger.debug("splitByAmountAndLineLimit billItems.size:{}", (Object)billItems.size());
        BigDecimal amount = BigDecimal.ZERO;
        int lineNum = 0;
        LinkedList splitGroup = Lists.newLinkedList();
        BigDecimal totalErrorAmount = BigDecimal.ZERO;
        BigDecimal totalErrorAmountAbs = BigDecimal.ZERO;
        BigDecimal basicInvoiceMaxErrorAmount = this.getMaxErrorAmountByTaxDeviceType(taxDeviceType, splitRule);
        BigDecimal businessInvoiceMaxErrorAmount = splitGroupLimit.getInvoiceMaxErrorAmount();
        Iterator<BillItem> it = billItems.iterator();
        while (it.hasNext()) {
            BillItem item = it.next();
            if (item.getDeductions().compareTo(BigDecimal.ZERO) > 0) {
                if (splitGroup.size() > 0) continue;
                splitGroup.add(item);
                it.remove();
                return splitGroup;
            }
            boolean isAmountGtLimit = amount.add(this.actualAmount(item, splitGroupLimit.isLimitIsAmountWithTax())).compareTo(splitGroupLimit.getLimitAmount()) > 0;
            boolean isLineGtLimit = lineNum + this.needLineNum(item) > splitGroupLimit.getLimitLine();
            BigDecimal currentItemErrorAmount = this.errorAmountCalculation(item, taxDeviceType);
            BigDecimal currentItemErrorAmountAbs = this.errorAmountCalculation(item, TaxDeviceType.HX_SINGL);
            boolean rateFor1dot27 = this.totalErrorAmountCalculation(totalErrorAmount, currentItemErrorAmount, basicInvoiceMaxErrorAmount, taxDeviceType);
            boolean rateForBusinessRule = this.totalErrorAmountCalculationForBusiness(totalErrorAmountAbs, currentItemErrorAmountAbs, businessInvoiceMaxErrorAmount);
            if (isLineGtLimit || rateFor1dot27 || rateForBusinessRule) {
                return splitGroup;
            }
            if (!isAmountGtLimit) {
                amount = amount.add(this.actualAmount(item, splitGroupLimit.isLimitIsAmountWithTax()));
                lineNum += this.needLineNum(item);
                totalErrorAmount = totalErrorAmount.add(currentItemErrorAmount);
                totalErrorAmountAbs = totalErrorAmountAbs.add(currentItemErrorAmountAbs);
                splitGroup.add(item);
                it.remove();
                continue;
            }
            if (splitGroupLimit.getInvoiceItemOrder() != InvoiceItemOrder.ITEM_NO_ORDER) continue;
            return splitGroup;
        }
        return splitGroup;
    }

    public Boolean totalErrorAmountCalculationForBusiness(BigDecimal totalErrorAmount, BigDecimal currentItemErrorAmount, BigDecimal businessInvoiceMaxErrorAmount) {
        return businessInvoiceMaxErrorAmount != null && businessInvoiceMaxErrorAmount.compareTo(BigDecimal.ZERO) != 0 && totalErrorAmount.add(currentItemErrorAmount).abs().compareTo(businessInvoiceMaxErrorAmount) > 0;
    }

    protected BigDecimal errorAmountCalculation(BillItem item, TaxDeviceType taxDeviceType) {
        String type = this.calculationConfig.get(taxDeviceType.getCode());
        BigDecimal diff = item.getAmountWithoutTax().multiply(item.getTaxRate()).subtract(item.getTaxAmount()).subtract(item.getDiscountWithoutTax().multiply(item.getTaxRate()).subtract(item.getDiscountTax()));
        return ErrorAmountPolicyEnum.ABS.name().equals(type) ? diff.abs() : diff;
    }

    protected Boolean totalErrorAmountCalculation(BigDecimal totalErrorAmount, BigDecimal currentItemAmount, BigDecimal basicInvoiceMaxErrorAmount, TaxDeviceType taxDeviceType) {
        if (TaxDeviceType.isBW(taxDeviceType)) {
            return Boolean.FALSE;
        }
        return totalErrorAmount.add(currentItemAmount).abs().compareTo(basicInvoiceMaxErrorAmount) > 0;
    }
}

