/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.phoenix.split.service.dataflow.impl;

import com.google.common.base.Stopwatch;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import com.google.common.collect.MultimapBuilder;
import com.xforceplus.phoenix.split.constant.TaxDeviceType;
import com.xforceplus.phoenix.split.domain.ItemGroup;
import com.xforceplus.phoenix.split.domain.PreInvoiceLimit;
import com.xforceplus.phoenix.split.domain.RuleInfo;
import com.xforceplus.phoenix.split.domain.SplitGroupLimit;
import com.xforceplus.phoenix.split.model.BillInfo;
import com.xforceplus.phoenix.split.model.BillItem;
import com.xforceplus.phoenix.split.service.SplitRuleUtil;
import com.xforceplus.phoenix.split.service.dataflow.DataProcessPlugin;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class MergeBySplitFieldPlugin
implements DataProcessPlugin {
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Override
    public List<ItemGroup> processData(List<ItemGroup> itemGroups, BillInfo billInfo, RuleInfo ruleInfo) {
        Stopwatch stopwatch = Stopwatch.createStarted();
        if (!ruleInfo.getSplitRule().isMergeBySplitFiled()) {
            return itemGroups;
        }
        LinkedList result = Lists.newLinkedList();
        HashMap<String, Multimap> temp = new HashMap<String, Multimap>();
        for (ItemGroup itemGroup : itemGroups) {
            String parentGroupFlag = itemGroup.getParentGroupFlag();
            String invoiceOfGroupKey = itemGroup.getInvoiceOfGroupKey();
            Multimap invoices = (Multimap)temp.get(parentGroupFlag);
            if (invoices == null) {
                invoices = MultimapBuilder.linkedHashKeys().linkedListValues().build();
                temp.put(parentGroupFlag, invoices);
            }
            invoices.put((Object)invoiceOfGroupKey, (Object)itemGroup);
        }
        for (Map.Entry entry : temp.entrySet()) {
            Multimap invoices = (Multimap)entry.getValue();
            result.addAll(this.merge((Multimap<String, ItemGroup>)invoices, ruleInfo));
        }
        this.logger.info("mergeBySplitFieldPlugin handle elapsed time = {} ms, itemGroup size:{}", (Object)stopwatch.elapsed().toMillis(), (Object)itemGroups.size());
        return result;
    }

    @Override
    public List<ItemGroup> processData(List<ItemGroup> itemGroups, BillInfo billInfo, RuleInfo ruleInfo, TaxDeviceType taxDeviceType) {
        return this.processData(itemGroups, billInfo, ruleInfo);
    }

    private List<ItemGroup> merge(Multimap<String, ItemGroup> invoices, RuleInfo ruleInfo) {
        LinkedList result = Lists.newLinkedList();
        List<ItemGroup> toBeProcessItemGroup = new ArrayList<ItemGroup>();
        for (String key : invoices.keySet()) {
            if (invoices.get((Object)key).size() > 1) {
                result.addAll(invoices.get((Object)key));
                continue;
            }
            toBeProcessItemGroup.addAll(invoices.get((Object)key));
        }
        if (toBeProcessItemGroup.size() > 1) {
            toBeProcessItemGroup = this.mergerInvoice(toBeProcessItemGroup, ruleInfo);
        }
        result.addAll(toBeProcessItemGroup);
        return result;
    }

    private List<ItemGroup> mergerInvoice(List<ItemGroup> toBeProcessItemGroup, RuleInfo ruleInfo) {
        SplitGroupLimit splitGroupLimit = SplitRuleUtil.createSplitGroupLimit(ruleInfo.getSplitRule(), toBeProcessItemGroup.get(0).getBillItems().get(0).getItemTypeCode());
        List<List<BillItem>> invoices = this.greedyMergeInvoices(toBeProcessItemGroup, ruleInfo, splitGroupLimit);
        LinkedList result = Lists.newLinkedList();
        invoices.forEach(invoice -> {
            ItemGroup itemGroup = new ItemGroup();
            itemGroup.setBillItems((List<BillItem>)invoice);
            result.add(itemGroup);
        });
        return result;
    }

    private List<List<BillItem>> greedyMergeInvoices(List<ItemGroup> toBeProcessItemGroup, RuleInfo ruleInfo, SplitGroupLimit splitGroupLimit) {
        ArrayList<List<BillItem>> invoices = new ArrayList<List<BillItem>>();
        ArrayList groupRemainInvoices = new ArrayList();
        for (ItemGroup itemGroup : toBeProcessItemGroup) {
            List<BillItem> billItems = itemGroup.getBillItems();
            while (billItems.size() > 0) {
                ArrayList<BillItem> invoice = new ArrayList<BillItem>();
                PreInvoiceLimit limit = new PreInvoiceLimit(splitGroupLimit);
                for (int i = 0; i < billItems.size() && limit.canAddItem(billItems.get(i)); ++i) {
                    invoice.add(billItems.get(i));
                    limit.addItem(billItems.get(i));
                }
                billItems.removeAll(invoice);
                if (billItems.size() != 0) {
                    invoices.add(invoice);
                    continue;
                }
                groupRemainInvoices.add(invoice);
            }
        }
        while (groupRemainInvoices.size() > 0) {
            ArrayList invoice = new ArrayList();
            PreInvoiceLimit limit = new PreInvoiceLimit(splitGroupLimit);
            ArrayList<Integer> groupMergedIndexes = new ArrayList<Integer>();
            for (int i = 0; i < groupRemainInvoices.size() && limit.canAddInvoice((List)groupRemainInvoices.get(i)); ++i) {
                invoice.addAll((Collection)groupRemainInvoices.get(i));
                limit.addInvoice((List)groupRemainInvoices.get(i));
                groupMergedIndexes.add(i);
            }
            invoices.add(invoice);
            int count = 0;
            for (Integer index : groupMergedIndexes) {
                groupRemainInvoices.remove(index - count);
                ++count;
            }
        }
        return invoices;
    }

    private List<List<BillItem>> sortGroupRemainInvoices(List<List<BillItem>> groupRemainInvoices, RuleInfo ruleInfo) {
        groupRemainInvoices = groupRemainInvoices.stream().sorted((o1, o2) -> {
            BigDecimal value1 = this.getGroupRemainBillItemSumAmount((List<BillItem>)o1, ruleInfo);
            BigDecimal value2 = this.getGroupRemainBillItemSumAmount((List<BillItem>)o2, ruleInfo);
            return value2.compareTo(value1);
        }).collect(Collectors.toList());
        return groupRemainInvoices;
    }

    private BigDecimal getGroupRemainBillItemSumAmount(List<BillItem> list, RuleInfo ruleInfo) {
        if (ruleInfo.getSplitRule().isLimitIsAmountWithTax()) {
            return list.stream().map(BillItem::getAmountWithTax).reduce(BigDecimal.ZERO, BigDecimal::add);
        }
        return list.stream().map(BillItem::getAmountWithoutTax).reduce(BigDecimal.ZERO, BigDecimal::add);
    }

    private List<BillItem> sortGroupBillItem(List<BillItem> billItems, RuleInfo ruleInfo) {
        billItems = billItems.stream().sorted((o1, o2) -> {
            BigDecimal value1 = this.getBillItemAmount((BillItem)o1, ruleInfo);
            BigDecimal value2 = this.getBillItemAmount((BillItem)o1, ruleInfo);
            return value2.compareTo(value1);
        }).collect(Collectors.toList());
        return billItems;
    }

    private BigDecimal getBillItemAmount(BillItem item, RuleInfo ruleInfo) {
        if (ruleInfo.getSplitRule().isLimitIsAmountWithTax()) {
            return item.getAmountWithTax();
        }
        return item.getAmountWithoutTax();
    }

    private List<ItemGroup> sortItemGroup(List<ItemGroup> itemGroups, RuleInfo ruleInfo) {
        itemGroups = itemGroups.stream().sorted((o1, o2) -> {
            BigDecimal value1 = this.getItemGroupBillItemSumAmount((ItemGroup)o1, ruleInfo);
            BigDecimal value2 = this.getItemGroupBillItemSumAmount((ItemGroup)o2, ruleInfo);
            return value2.compareTo(value1);
        }).collect(Collectors.toList());
        return itemGroups;
    }

    private BigDecimal getItemGroupBillItemSumAmount(ItemGroup itemGroup, RuleInfo ruleInfo) {
        if (ruleInfo.getSplitRule().isLimitIsAmountWithTax()) {
            return itemGroup.getBillItems().stream().map(BillItem::getAmountWithTax).reduce(BigDecimal.ZERO, BigDecimal::add);
        }
        return itemGroup.getBillItems().stream().map(BillItem::getAmountWithoutTax).reduce(BigDecimal.ZERO, BigDecimal::add);
    }
}

