/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.phoenix.split.service.dataflow.impl;

import com.google.common.base.Stopwatch;
import com.xforceplus.phoenix.split.model.BillItem;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Service;

@Service
@Scope(value="prototype")
public class MinPackagePlugin2 {
    private static final Logger logger = LoggerFactory.getLogger(MinPackagePlugin2.class);
    Map<Integer, List<Integer>> POSITION_MAP = new HashMap<Integer, List<Integer>>();
    Boolean isturn;

    public MinPackagePlugin2() {
        this.POSITION_MAP.put(3, Arrays.asList(1, 0));
        this.POSITION_MAP.put(2, Arrays.asList(0, 1));
        this.POSITION_MAP.put(1, Arrays.asList(0, 1));
        this.POSITION_MAP.put(0, Arrays.asList(1, 0));
        this.isturn = false;
    }

    public Map<Integer, Group> distributeGroup(List<BillItem> list, BigDecimal limitAmount) {
        HashMap<Integer, Group> map = new HashMap<Integer, Group>();
        map.put(0, new Group(new CopyOnWriteArrayList<Element>()));
        map.put(1, new Group(new CopyOnWriteArrayList<Element>()));
        map.put(2, new Group(new CopyOnWriteArrayList<Element>()));
        map.put(3, new Group(new CopyOnWriteArrayList<Element>()));
        BigDecimal median = limitAmount.divide(BigDecimal.valueOf(2L), RoundingMode.DOWN);
        list.forEach(item -> {
            boolean overMedian = item.getAmountWithoutTax().subtract(item.getDiscountWithoutTax()).compareTo(median) > 0;
            BigDecimal diff = item.getAmountWithoutTax().multiply(item.getTaxRate()).subtract(item.getTaxAmount()).add(item.getDiscountWithoutTax().multiply(item.getTaxRate()).subtract(item.getDiscountTax()));
            boolean taxDiffPosition = diff.compareTo(BigDecimal.ZERO) > 0;
            Integer index = this.getGroupIndex(overMedian, taxDiffPosition);
            BigDecimal amount = item.getAmountWithoutTax().subtract(item.getDiscountWithoutTax());
            BigDecimal amountWithTax = item.getAmountWithTax().subtract(item.getDiscountWithTax());
            Group group = (Group)map.get(index);
            group.elementList.add(new Element((BillItem)item, amount, diff, amountWithTax));
        });
        map.values().stream().forEach(key -> Collections.sort(key.elementList, Comparator.comparing(Element::getAmountWithoutTax)));
        return map;
    }

    public Map<Integer, Group> distributeGroupWithTax(List<BillItem> list, BigDecimal limitAmount) {
        HashMap<Integer, Group> map = new HashMap<Integer, Group>();
        map.put(0, new Group(new CopyOnWriteArrayList<Element>()));
        map.put(1, new Group(new CopyOnWriteArrayList<Element>()));
        map.put(2, new Group(new CopyOnWriteArrayList<Element>()));
        map.put(3, new Group(new CopyOnWriteArrayList<Element>()));
        BigDecimal median = limitAmount.divide(BigDecimal.valueOf(2L), RoundingMode.DOWN);
        list.forEach(item -> {
            boolean overMedian = item.getAmountWithTax().subtract(item.getDiscountWithTax()).compareTo(median) > 0;
            BigDecimal diff = this.calTaxAmountByAmountWithTax(item.getAmountWithTax(), item.getTaxRate()).subtract(item.getTaxAmount()).add(this.calTaxAmountByAmountWithTax(item.getDiscountWithTax(), item.getTaxRate()).subtract(item.getDiscountTax()));
            boolean taxDiffPosition = diff.compareTo(BigDecimal.ZERO) > 0;
            Integer index = this.getGroupIndex(overMedian, taxDiffPosition);
            BigDecimal amount = item.getAmountWithoutTax().subtract(item.getDiscountWithoutTax());
            BigDecimal amountWithTax = item.getAmountWithTax().subtract(item.getDiscountWithTax());
            Group group = (Group)map.get(index);
            group.elementList.add(new Element((BillItem)item, amount, diff, amountWithTax));
        });
        map.values().forEach(key -> key.elementList.sort(Comparator.comparing(Element::getAmountWithTax)));
        return map;
    }

    private BigDecimal calTaxAmountByAmountWithTax(BigDecimal amountWithTax, BigDecimal taxRate) {
        return amountWithTax.multiply(taxRate).divide(BigDecimal.ONE.add(taxRate), 2, RoundingMode.HALF_UP);
    }

    public List<List<BillItem>> processData(List<BillItem> billItems, BigDecimal limit, BigDecimal taxDiff, boolean limitIsAmountWithTax) {
        ArrayList<ResGroup> RES = new ArrayList<ResGroup>();
        Stopwatch stopwatch = Stopwatch.createStarted();
        logger.info("MinPackagePlugin2 \u5904\u7406 \u5f00\u59cb");
        Map<Integer, Group> groupMap = limitIsAmountWithTax ? this.distributeGroupWithTax(billItems, limit) : this.distributeGroup(billItems, limit);
        ResGroup resGroup = new ResGroup(new ArrayList<Element>(), BigDecimal.ZERO, BigDecimal.ZERO);
        resGroup = this.packageItem(groupMap, 3, limit, taxDiff, resGroup, RES, limitIsAmountWithTax);
        resGroup = this.packageItem(groupMap, 2, limit, taxDiff, resGroup, RES, limitIsAmountWithTax);
        resGroup = this.packageItem(groupMap, 1, limit, taxDiff, resGroup, RES, limitIsAmountWithTax);
        resGroup = this.packageItem(groupMap, 0, limit, taxDiff, resGroup, RES, limitIsAmountWithTax);
        List<List<BillItem>> lastGroup = this.processLast(groupMap, limit, taxDiff);
        ArrayList<List<BillItem>> splitGroup = new ArrayList<List<BillItem>>();
        splitGroup.addAll(lastGroup);
        RES.stream().filter(tmpGroup -> tmpGroup.getTotalAmount().compareTo(BigDecimal.ZERO) > 0).forEach(tmpGroup -> splitGroup.add(tmpGroup.elementList.stream().map(element -> element.billItem).collect(Collectors.toList())));
        logger.info("MinPackagePlugin2 \u5904\u7406 \u5b8c\u6210 \u8017\u65f6{}  \u6761\u6570{}", (Object)stopwatch.elapsed(TimeUnit.MILLISECONDS), (Object)splitGroup.size());
        return splitGroup;
    }

    private List<List<BillItem>> processLast(Map<Integer, Group> groupMap, BigDecimal limit, BigDecimal taxDiffLimit) {
        ArrayList<List<BillItem>> splitGroup = new ArrayList<List<BillItem>>();
        CopyOnWriteArrayList splitItems = new CopyOnWriteArrayList();
        groupMap.values().stream().filter(tmpGroup -> CollectionUtils.isNotEmpty(tmpGroup.elementList)).forEach(group -> {
            for (Element element : group.getElementList()) {
                splitItems.add(element);
            }
        });
        BigDecimal totalAmount = BigDecimal.ZERO;
        BigDecimal totalDiff = BigDecimal.ZERO;
        Integer originalNum = splitItems.size();
        while (splitItems.size() > 0) {
            ArrayList<BillItem> tmpRes = new ArrayList<BillItem>();
            for (Element element : splitItems) {
                if (element.amountWithoutTax.compareTo(limit) > 0) {
                    tmpRes.add(element.billItem);
                    splitItems.remove(element);
                    continue;
                }
                totalAmount = totalAmount.add(element.amountWithoutTax);
                if ((totalDiff = totalDiff.add(element.taxAmountDiff)).abs().compareTo(taxDiffLimit) > 0 || totalAmount.compareTo(limit) > 0) continue;
                tmpRes.add(element.billItem);
                splitItems.remove(element);
            }
            if (originalNum.intValue() == splitItems.size()) {
                throw new IllegalArgumentException("miniPackage data exception");
            }
            if (!CollectionUtils.isNotEmpty(tmpRes)) continue;
            splitGroup.add(tmpRes);
            totalAmount = BigDecimal.ZERO;
            totalDiff = BigDecimal.ZERO;
        }
        return splitGroup;
    }

    private Integer getGroupIndex(Boolean overMedian, Boolean taxDiffPosition) {
        if (overMedian.booleanValue()) {
            if (taxDiffPosition.booleanValue()) {
                return 2;
            }
            return 3;
        }
        if (taxDiffPosition.booleanValue()) {
            return 0;
        }
        return 1;
    }

    public ResGroup packageItem(Map<Integer, Group> map, Integer mapPosition, BigDecimal limit, BigDecimal diffLimit, ResGroup resGroup, List<ResGroup> RES, boolean limitIsAmountWithTax) {
        Group targetGroup = map.get(mapPosition);
        List<Integer> matchPositions = this.POSITION_MAP.get(mapPosition);
        if (CollectionUtils.isEmpty(targetGroup.elementList)) {
            return resGroup;
        }
        resGroup = this.doMatch(map, targetGroup, mapPosition, resGroup, limit, diffLimit, RES, limitIsAmountWithTax);
        Integer matchPosition = matchPositions.get(0);
        Group matchGroup = map.get(matchPosition);
        resGroup = this.doMatch(map, matchGroup, 0, resGroup, limit, diffLimit, RES, limitIsAmountWithTax);
        matchGroup = map.get(matchPositions.get(1));
        this.doMatch(map, matchGroup, 1, resGroup, limit, diffLimit, RES, limitIsAmountWithTax);
        return resGroup;
    }

    private ResGroup doMatch(Map<Integer, Group> map, Group group, Integer matchPosition, ResGroup resGroup, BigDecimal limit, BigDecimal diffLimit, List<ResGroup> RES, boolean limitIsAmountWithTax) {
        for (Element element : group.getElementList()) {
            if (resGroup.getTaxDiff().add(element.getTaxAmountDiff()).abs().compareTo(diffLimit) > 0) {
                matchPosition = matchPosition > 0 ? 0 : 1;
                group = map.get(matchPosition);
                if (CollectionUtils.isEmpty(group.elementList)) {
                    if (!RES.contains(resGroup)) {
                        RES.add(resGroup);
                    }
                    return this.doMatch(map, group, matchPosition, new ResGroup(new ArrayList<Element>(), BigDecimal.ZERO, BigDecimal.ZERO), limit, diffLimit, RES, limitIsAmountWithTax);
                }
                this.isturn = true;
                return this.doMatch(map, group, matchPosition, resGroup, limit, diffLimit, RES, limitIsAmountWithTax);
            }
            BigDecimal totalAmount = limitIsAmountWithTax ? resGroup.getTotalAmount().add(element.getAmountWithTax()) : resGroup.getTotalAmount().add(element.getAmountWithoutTax());
            if (totalAmount.compareTo(limit) > 0) {
                if (!this.isturn.booleanValue()) {
                    matchPosition = matchPosition > 0 ? 0 : 1;
                    group = map.get(matchPosition);
                    if (CollectionUtils.isEmpty(group.elementList)) {
                        if (!RES.contains(resGroup)) {
                            RES.add(resGroup);
                        }
                        return this.doMatch(map, group, matchPosition, new ResGroup(new ArrayList<Element>(), BigDecimal.ZERO, BigDecimal.ZERO), limit, diffLimit, RES, limitIsAmountWithTax);
                    }
                    this.isturn = true;
                    return this.doMatch(map, group, matchPosition, resGroup, limit, diffLimit, RES, limitIsAmountWithTax);
                }
                if (this.isturn.booleanValue()) {
                    this.isturn = false;
                    if (!RES.contains(resGroup)) {
                        RES.add(resGroup);
                    }
                    return this.doMatch(map, group, matchPosition, new ResGroup(new ArrayList<Element>(), BigDecimal.ZERO, BigDecimal.ZERO), limit, diffLimit, RES, limitIsAmountWithTax);
                }
            }
            resGroup.elementList.add(element);
            resGroup.setTotalAmount(totalAmount);
            if (resGroup.getTaxDiff().add(element.getTaxAmountDiff()).abs().compareTo(diffLimit) >= 0) {
                System.out.println(resGroup);
            }
            resGroup.setTaxDiff(resGroup.getTaxDiff().add(element.getTaxAmountDiff()));
            group.getElementList().remove(element);
        }
        if (!RES.contains(resGroup)) {
            RES.add(resGroup);
            if (!this.isturn.booleanValue()) {
                matchPosition = matchPosition > 0 ? 0 : 1;
                group = map.get(matchPosition);
                if (CollectionUtils.isEmpty(group.elementList)) {
                    if (!RES.contains(resGroup)) {
                        RES.add(resGroup);
                    }
                    return resGroup;
                }
                this.isturn = true;
                return this.doMatch(map, group, matchPosition, resGroup, limit, diffLimit, RES, limitIsAmountWithTax);
            }
        }
        return resGroup;
    }

    class Element
    implements Comparable<Element> {
        BillItem billItem;
        BigDecimal amountWithoutTax;
        BigDecimal taxAmountDiff;
        BigDecimal amountWithTax;

        public Element(BillItem billItem, BigDecimal amountWithoutTax, BigDecimal taxAmountDiff, BigDecimal amountWithTax) {
            this.billItem = billItem;
            this.amountWithoutTax = amountWithoutTax;
            this.taxAmountDiff = taxAmountDiff;
            this.amountWithTax = amountWithTax;
        }

        public BigDecimal getAmountWithoutTax() {
            return this.amountWithoutTax;
        }

        public BigDecimal getTaxAmountDiff() {
            return this.taxAmountDiff;
        }

        public BigDecimal getAmountWithTax() {
            return this.amountWithTax;
        }

        @Override
        public int compareTo(Element o) {
            return this.getAmountWithoutTax().compareTo(o.getAmountWithoutTax());
        }
    }

    class Group {
        List<Element> elementList;

        public Group(List<Element> elementList) {
            this.elementList = elementList;
        }

        public void setElementList(List<Element> elementList) {
            this.elementList = elementList;
        }

        public List<Element> getElementList() {
            return this.elementList;
        }
    }

    static class ResGroup {
        List<Element> elementList;
        BigDecimal totalAmount;
        BigDecimal taxDiff;

        public ResGroup(List<Element> elementList, BigDecimal totalAmount, BigDecimal taxDiff) {
            this.elementList = elementList;
            this.totalAmount = totalAmount;
            this.taxDiff = taxDiff;
        }

        public void setElementList(List<Element> elementList) {
            this.elementList = elementList;
        }

        public List<Element> getElementList() {
            return this.elementList;
        }

        public BigDecimal getTotalAmount() {
            return this.totalAmount;
        }

        public void setTotalAmount(BigDecimal totalAmount) {
            this.totalAmount = totalAmount;
        }

        public BigDecimal getTaxDiff() {
            return this.taxDiff;
        }

        public void setTaxDiff(BigDecimal taxDiff) {
            this.taxDiff = taxDiff;
        }
    }
}

