package com.xforceplus.phoenix.split.constant;

import java.util.Arrays;

public enum InvoiceItemOrder {

    /**
     * 顺序优先
     */
    ITEM_NO_ORDER("0"),

    /**
     * 张数优先
     */
    MINIMUM_INVOICES("1"),

    /**
     * 张数最少
     */
    ITEM_NO_MINIMUM_INVOICES("2");


    private final String orderType;

    InvoiceItemOrder(String orderType){
        this.orderType = orderType;
    }

    public String value(){
        return this.orderType;
    }
    public static InvoiceItemOrder fromValue(String value){
        return Arrays.stream(InvoiceItemOrder.values())
                .filter(s -> s.value().equals(value))
                .findAny()
                .orElseThrow(() -> new RuntimeException("错误的类型"));
    }
}
