package com.xforceplus.phoenix.split.constant;

import org.apache.commons.lang3.StringUtils;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Stream;

/**
 * @author YY
 */
public enum InvoiceType {
    NORMAL("c", "增值税普通发票"),
    SPECIAL("s", "增值税专用发票"),

    SE("se", "专电票种"),

    VEHICLE("v", "机动车销售发票"),

    UNIVERSAL("t", "通用机打发票"),
    ELECTRONIC("ce", "增值税电子普通发票"),

    ELECTRONIC_SPECIAL("se", "增值税电子专票"),
    NORMAL_ROLL("ju", " 增值税普通发票(卷票)"),

    ALL_ELECTRONIC_NORMAL("cz", "全电纸票"),

    ALL_ELECTRONIC_SPECIAL("sz", "全电专票"),

    QV("qv", "电子发票（机动车销售统一发票）");

    private final String type;
    private final String desc;

    InvoiceType(String type, String description) {
        this.type = type;
        this.desc = description;
    }

    public String value() {
        return this.type;
    }

    public static InvoiceType fromValue(String value) throws RuntimeException {
        return Stream.of(InvoiceType.values())
                .filter(t -> t.value().equals(value))
                .findFirst().orElseThrow(() -> new RuntimeException("不存在对应类型的票"));
    }

    public static boolean isNormal(String invoiceType) {
        return Arrays.asList(NORMAL.type, ELECTRONIC.type, NORMAL_ROLL.type).contains(invoiceType);
    }

    public static boolean isElectronic(String invoiceType) {
        return Arrays.asList(ELECTRONIC.type, ELECTRONIC_SPECIAL.type).contains(invoiceType);
    }

    public static boolean isNormalOrSpecialInvoice(String invoiceType) {
        return Arrays.asList(NORMAL.type, SPECIAL.type).contains(invoiceType);
    }

    public static boolean isSpecial(String invoiceType) {
        return Arrays.asList(SPECIAL).contains(invoiceType);
    }

    public static List<String> special() {
        return Arrays.asList(SPECIAL.value());
    }

    public static boolean isAllElectronicNormalInvoice(String value) {
        // return Arrays.asList(ALL_ELECTRONIC_NORMAL.type, ALL_ELECTRONIC_SPECIAL.type, NORMAL.type, SPECIAL.type, ELECTRONIC.type, ELECTRONIC_SPECIAL.type).contains(value);
        return Arrays.asList(ALL_ELECTRONIC_NORMAL.type, ALL_ELECTRONIC_SPECIAL.type, NORMAL.type, SPECIAL.type).contains(value);
    }

    public static boolean isVehicle(String invoiceType) {
        return StringUtils.equalsAny(invoiceType, VEHICLE.value(), QV.value());
    }

}
