package com.xforceplus.phoenix.split.constant;

import com.xforceplus.phoenix.split.exception.SplitRuleParamException;
import org.apache.commons.lang3.StringUtils;

public enum ReturnMode {
    /**
     * 同步
     */
    SYNC("sync"),

    /**
     * 异步
     */
    CALLBACK("callback");

    private String value;

    ReturnMode(String value) {
        this.value = value;
    }

    public static ReturnMode getDefaultOrByValue(String value) {
        if (StringUtils.isBlank(value)) {
            return CALLBACK;
        } else {
            for (ReturnMode returnMode : ReturnMode.values()) {
                if (returnMode.value.equals(value)) {
                    return returnMode;
                }
            }
        }
        throw new SplitRuleParamException(String.format("returnMode = [%s] is invalid", value));
    }
}
