package com.xforceplus.phoenix.split.service;

/**
 * 类描述：
 * @ClassName AmountSplitRuleUtils
 * @Description TODO
 * @Author ZZW
 * @Date 2021/11/2 19:23
 */
public class AmountSplitRuleUtils {

    /**
     * 按数量拆单价
     */
    public static boolean isQuantity(String amountSplitRule) {
        return "1".equals(amountSplitRule);
    }

    /**
     * 按单价拆数量, 不能反算数量，保证数量总数与原单一致
     */
    public static boolean isUnitPrice(String amountSplitRule) {
        return "3".equals(amountSplitRule);
    }

    /**
     * 按单价拆数量，并保证数量为整数， 最后一笔不保证
     */
    public static boolean isUnitPriceAndQuantityInteger(String amountSplitRule) {
        return "2".equals(amountSplitRule);
    }

    /**
     * 按单价拆数量，必要时反算数量（不保证数量总数与原单一致）
     */
    public static boolean isUnitPriceAndRecalculateQuantity(String amountSplitRule) {
        return "4".equals(amountSplitRule);
    }

    /**
     * 数量尽量去整
     * @param amountSplitRule
     * @return
     */
    public static boolean recalculateQuantityRounding(String amountSplitRule) {
        return "5".equals(amountSplitRule);
    }
}
