package com.xforceplus.phoenix.split.service;

import java.math.BigDecimal;
import java.math.RoundingMode;

public class BigDecimalUtils {

    /**
     * 判断给定的 BigDecimal 是否表示一个非零整数。
     *
     * @param number 要检查的 BigDecimal 对象
     * @return 如果 number 是一个整数，则返回 true；否则返回 false
     */
    public static boolean isQuanlityOfJdc(BigDecimal number) {
        if (number == null) {
            return false;
        }

        // 使用setScale将BigDecimal的小数部分舍去，并检查是否等于原数
        BigDecimal stripped = number.setScale(0, RoundingMode.DOWN);
        return number.compareTo(stripped) == 0 && BigDecimal.ZERO.compareTo(number) != 0;
    }
}
