package com.xforceplus.phoenix.split.service;

import com.xforceplus.phoenix.split.constant.TaxDeviceType;
import com.xforceplus.phoenix.split.model.SplitRule;
import com.xforceplus.phoenix.split.service.impl.BWSplitBillItemByAmountWithTaxServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;

@Service
public class SplitBillItemAmountServiceFactory {

    @Autowired
    @Qualifier("defaultSplitBillItemAmountServiceImpl")
    private SplitBillItemAmountService defaultSplitBillItemAmountService;

    @Autowired
    @Qualifier("splitBillItemByAmountWithTaxServiceImpl")
    private SplitBillItemAmountService splitBillItemByAmountWithTaxServiceImpl;

    @Autowired
    @Qualifier("BWSplitBillItemByAmountWithTaxServiceImpl")
    private BWSplitBillItemByAmountWithTaxServiceImpl bWSplitBillItemByAmountWithTaxServiceImpl;

    public SplitBillItemAmountService getByRule(SplitRule rule ) {
        if (rule.isLimitIsAmountWithTax()) {
            return  splitBillItemByAmountWithTaxServiceImpl;
        } else {
            return defaultSplitBillItemAmountService;
        }
    }
    public SplitBillItemAmountService getByRule(SplitRule rule, TaxDeviceType taxDeviceType) {
        if (rule.isLimitIsAmountWithTax()) {
             return splitBillItemByAmountWithTaxServiceImpl;
        } else {
            return (taxDeviceType == TaxDeviceType.BW_SERVER || taxDeviceType == TaxDeviceType.BW_SINGL) ?
                    bWSplitBillItemByAmountWithTaxServiceImpl : defaultSplitBillItemAmountService;

        }
    }

}
