package com.xforceplus.phoenix.split.service.dataflow;

import com.xforceplus.phoenix.split.config.DataProcessPluginConfig;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

@Service
public class DataProcessPluginFactory {

    @Autowired
    private ApplicationContext applicationContext;

    @Autowired
    private DataProcessPluginConfig dataProcessPluginConfig;

    private Map<String, List<DataProcessPlugin>> cache = new ConcurrentHashMap<>();

    public List<DataProcessPlugin> getPluginByCode(String ruleCode) {
        if (cache.get(ruleCode) != null) {
            return cache.get(ruleCode);
        }
        synchronized (DataProcessPlugin.class) {
            if (cache.get(ruleCode) == null) {
                List<String> dataProcessPluginBeanNames = dataProcessPluginConfig.getBeanNamesByRuleCode(ruleCode);
                if (CollectionUtils.isEmpty(dataProcessPluginBeanNames)) {
                    throw new IllegalStateException("data process plugins bean name not config!");
                }
                List<DataProcessPlugin> dataProcessPlugins = new ArrayList<>(dataProcessPluginBeanNames.size());
                for (String beanName : dataProcessPluginBeanNames) {
                    dataProcessPlugins.add(applicationContext.getBean(beanName, DataProcessPlugin.class));
                }
                cache.put(ruleCode, dataProcessPlugins);
            }
        }

        return cache.get(ruleCode);
    }


}
