package com.xforceplus.phoenix.split.service.dataflow.impl;

import com.xforceplus.phoenix.split.domain.ItemGroup;
import com.xforceplus.phoenix.split.model.BillItem;
import com.xforceplus.phoenix.split.model.SplitRule;
import com.xforceplus.phoenix.split.service.dataflow.AbstractBillItemGroupPlugin;
import org.apache.commons.beanutils.BeanMap;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.util.List;
import java.util.Map;

/**
 * 根据规则拆分字段分组
 */
@Service
public class GroupItemBySplitFieldPlugin extends AbstractBillItemGroupPlugin {


    @Override
    protected String generateKey(BillItem billItem, SplitRule rule) {
        StringBuilder splitKey = new StringBuilder();
        Map<Object, Object> map = new BeanMap(billItem);
        rule.getSplitFiledList()
                .forEach(e -> splitKey.append(null == map.get(e) ? "" : map.get(e)));
        return splitKey.toString();
    }

    @Override
    public boolean support(SplitRule rule, List<ItemGroup> itemGroups) {
        return !CollectionUtils.isEmpty(rule.getSplitFiledList());
    }



}
