package com.xforceplus.phoenix.split.service.impl;

import com.xforceplus.phoenix.split.domain.ItemAmountInfo;
import com.xforceplus.phoenix.split.model.SplitRule;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;
import java.util.List;

@Service
public class MinInvoiceSplitItemServiceImpl extends DefaultSplitBillItemAmountServiceImpl {


    @Override
    protected ItemAmountInfo initFirstSplitItem(SplitRule rule, ItemAmountInfo originalItem,
                                                List<ItemAmountInfo> result, BigDecimal limitAmount) {

        ItemAmountInfo newItem = splitFirstItemAmountInfo(rule, originalItem, originalItem.getBalanceInvoiceAmount());
        result.add(newItem);

        ItemAmountInfo first = null;
        if (gtLimitAmount(originalItem, limitAmount)) {
            first = splitFirstItemAmountInfo(rule, originalItem, limitAmount);
            result.add(first);
        }

        return first;
    }
}
