/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.phoenix.split.constant;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;

public enum InvoiceType {
    NORMAL("c", "\u589e\u503c\u7a0e\u666e\u901a\u53d1\u7968"),
    SPECIAL("s", "\u589e\u503c\u7a0e\u4e13\u7528\u53d1\u7968"),
    SE("se", "\u4e13\u7535\u7968\u79cd"),
    VEHICLE("v", "\u673a\u52a8\u8f66\u9500\u552e\u53d1\u7968"),
    UNIVERSAL("t", "\u901a\u7528\u673a\u6253\u53d1\u7968"),
    ELECTRONIC("ce", "\u589e\u503c\u7a0e\u7535\u5b50\u666e\u901a\u53d1\u7968"),
    ELECTRONIC_SPECIAL("se", "\u589e\u503c\u7a0e\u7535\u5b50\u4e13\u7968"),
    NORMAL_ROLL("ju", " \u589e\u503c\u7a0e\u666e\u901a\u53d1\u7968(\u5377\u7968)"),
    ALL_ELECTRONIC_NORMAL("cz", "\u5168\u7535\u7eb8\u7968"),
    ALL_ELECTRONIC_SPECIAL("sz", "\u5168\u7535\u4e13\u7968"),
    QV("qv", "\u7535\u5b50\u53d1\u7968\uff08\u673a\u52a8\u8f66\u9500\u552e\u7edf\u4e00\u53d1\u7968\uff09");

    private final String type;
    private final String desc;

    private InvoiceType(String type, String description) {
        this.type = type;
        this.desc = description;
    }

    public String value() {
        return this.type;
    }

    public static InvoiceType fromValue(String value) throws RuntimeException {
        return Stream.of(InvoiceType.values()).filter(t -> t.value().equals(value)).findFirst().orElseThrow(() -> new RuntimeException("\u4e0d\u5b58\u5728\u5bf9\u5e94\u7c7b\u578b\u7684\u7968"));
    }

    public static boolean isNormal(String invoiceType) {
        return Arrays.asList(InvoiceType.NORMAL.type, InvoiceType.ELECTRONIC.type, InvoiceType.NORMAL_ROLL.type).contains(invoiceType);
    }

    public static boolean isElectronic(String invoiceType) {
        return Arrays.asList(InvoiceType.ELECTRONIC.type, InvoiceType.ELECTRONIC_SPECIAL.type).contains(invoiceType);
    }

    public static boolean isNormalOrSpecialInvoice(String invoiceType) {
        return Arrays.asList(InvoiceType.NORMAL.type, InvoiceType.SPECIAL.type).contains(invoiceType);
    }

    public static boolean isSpecial(String invoiceType) {
        return Arrays.asList(SPECIAL).contains(invoiceType);
    }

    public static List<String> special() {
        return Arrays.asList(SPECIAL.value());
    }

    public static boolean isAllElectronicNormalInvoice(String value) {
        return Arrays.asList(InvoiceType.ALL_ELECTRONIC_NORMAL.type, InvoiceType.ALL_ELECTRONIC_SPECIAL.type, InvoiceType.NORMAL.type, InvoiceType.SPECIAL.type).contains(value);
    }

    public static boolean isVehicle(String invoiceType) {
        return StringUtils.equalsAny((CharSequence)invoiceType, (CharSequence[])new CharSequence[]{VEHICLE.value(), QV.value()});
    }
}

