/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.phoenix.split.constant;

import com.xforceplus.phoenix.split.exception.SplitRuleParamException;
import java.util.Arrays;
import org.apache.commons.lang3.StringUtils;

public enum RemarkFieldNameEnum {
    REMARK("remark"),
    FIXED_REMARK("fixedRemark"),
    TAX_PRE("taxPre"),
    ZERO_TAX("zeroTax"),
    PRICE_METHOD("priceMethod"),
    AMOUNT_WITHOUT_TAX("amountWithoutTax"),
    AMOUNT_WITH_TAX("amountWithTax"),
    TAX_AMOUNT("taxAmount"),
    INNER_DISCOUNT_TAX("innerDiscountTax"),
    INNER_DISCOUNT_WITHOUT_TAX("innerDiscountWithoutTax"),
    INNER_DISCOUNT_WITH_TAX("innerDiscountWithTax"),
    OUTER_DISCOUNT_TAX("outterDiscountTax"),
    OUTER_DISCOUNT_WITHOUT_TAX("outterDiscountWithoutTax"),
    OUTER_DISCOUNT_WITH_TAX("outterDiscountWithTax");

    private String value;

    public String getValue() {
        return this.value;
    }

    private RemarkFieldNameEnum(String value) {
        this.value = value;
    }

    public static boolean isAmountKindField(String fieldName) {
        return Arrays.asList(RemarkFieldNameEnum.AMOUNT_WITHOUT_TAX.value, RemarkFieldNameEnum.AMOUNT_WITH_TAX.value, RemarkFieldNameEnum.TAX_AMOUNT.value, RemarkFieldNameEnum.INNER_DISCOUNT_TAX.value, RemarkFieldNameEnum.INNER_DISCOUNT_WITHOUT_TAX.value, RemarkFieldNameEnum.INNER_DISCOUNT_WITH_TAX.value, RemarkFieldNameEnum.OUTER_DISCOUNT_TAX.value, RemarkFieldNameEnum.OUTER_DISCOUNT_WITHOUT_TAX.value, RemarkFieldNameEnum.OUTER_DISCOUNT_WITH_TAX.value).contains(fieldName);
    }

    public static RemarkFieldNameEnum getDefaultOrByValue(String value) {
        if (StringUtils.isBlank((CharSequence)value)) {
            return null;
        }
        for (RemarkFieldNameEnum returnMode : RemarkFieldNameEnum.values()) {
            if (!returnMode.value.equals(value)) continue;
            return returnMode;
        }
        throw new SplitRuleParamException(String.format("returnMode = [%s] is invalid", value));
    }
}

